﻿$.validator.setDefaults({
    submitHandler: function (form) { form.submit(); }
});
jQuery.validator.addMethod("UserName", function (value, element) {
    var regex = /[0-9A-Za-z]{5,20}$/;
    return regex.exec(value);
}, "账号名称只能是数字和字母组合");
jQuery.validator.addMethod("Mobile", function (value, element) {
    if (value == "") return true;
    var regex = /^0{0,1}(13|14|15|18)[0-9]{9}$/;
    return regex.exec(value);
}, "手机格式错误");
jQuery.validator.addMethod("Email", function (value, element) {
    if (value == "") return true;
    var regex = /^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$/;
    return regex.exec(value);
}, "电子邮件格式错误");
/*
验证调用接口扩展
obj提交的表单对象
rulesValue规则JSON
messagesValue规则JSON
*/
jQuery.validator.ValidateForm = function(obj, rulesValue, messagesValue) {
    var resultForm = obj.validate({
        /*验证规则*/
        rules: rulesValue,
        messages: messagesValue,
        /*重写错误显示消息方法,以alert方式弹出错误消息*/
        showErrors: function (errorMap, errorList) {
            var msg = "";
            $.each(errorList, function (i, v) {
                msg += (v.message + "\r\n");
            });
            if (msg != "") alert(msg);
        },
        /* 失去焦点时不验证 */
        onkeyup: false,
        onfocusout: false
    });
    return resultForm;
}