﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="Statistics.aspx.cs"
    Inherits="OAWeb.crm.Statistics" Title="统计信息" Theme="Default" EnableViewState="true" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/TontJiLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:TaskNav ID="TaskNav1" runat="server" />
            </td>
            <td class="main_center">
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title">
                            <tr>
                                <td class="data_caption">
                                    销售统计
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    部门：<asp:DropDownList ID="ddlDepartment" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlDepartment_SelectedIndexChanged">
                                    </asp:DropDownList>
                                    &nbsp; 姓名：<asp:DropDownList ID="ddlUserName" runat="server">
                                    </asp:DropDownList>
                                    &nbsp; 日期：<asp:DropDownList ID="ddlDate" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlDate_SelectedIndexChanged">
                                        <asp:ListItem Text="自定义" Value="0"></asp:ListItem>
                                        <asp:ListItem Text="今天" Value="1"></asp:ListItem>
                                        <asp:ListItem Text="昨天" Value="2"></asp:ListItem>
                                        <asp:ListItem Text="本周" Value="3"></asp:ListItem>
                                        <asp:ListItem Text="上周" Value="4"></asp:ListItem>
                                        <asp:ListItem Text="本月" Value="5"></asp:ListItem>
                                        <asp:ListItem Text="上月" Value="6"></asp:ListItem>
                                    </asp:DropDownList>
                                    &nbsp;或<asp:TextBox ID="txtStartDate" runat="server" onfocus="WdatePicker()"></asp:TextBox>
                                    至
                                    <asp:TextBox ID="txtEndDate" runat="server" onfocus="WdatePicker()"></asp:TextBox>
                                    &nbsp;<asp:Button ID="btnSearch" runat="server" Text="查 询" OnClick="btnSearch_Click"
                                        CssClass="btn-77px" />
                                </td>
                            </tr>
                        </table>
                        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" OnRowDataBound="GridView1_RowDataBound">
                            <Columns>
                                <asp:BoundField HeaderText="姓名" DataField="RealName" />
                                <asp:TemplateField HeaderText="部门">
                                    <ItemTemplate>
                                        <%# OACore.Caches.BaseDepartmentCache.Instance.GetNameById(Eval("DeptId")) %>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField HeaderText="联系客户数" DataField="ActionCount" />
                                <asp:BoundField HeaderText="机会数" DataField="OpportunityCount" />
                                <asp:BoundField HeaderText="订单数" DataField="OrderCount" />
                                <asp:BoundField HeaderText="签约金额" DataField="AmountCount" />
                                <asp:BoundField HeaderText="销售收款" DataField="GatherCount" />
                                <asp:TemplateField HeaderText="预收款">
                                    <ItemTemplate>
                                        <%# ObjTodecimal(Eval("PrePaidCount"))%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField HeaderText="销售费用" DataField="" />
                                <asp:BoundField HeaderText="销售总额" DataField="" />
                            </Columns>
                        </asp:GridView>
                    </div>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
