﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Dialog/DialogMaster.Master" AutoEventWireup="true"
    CodeBehind="DataList.aspx.cs" Inherits="OAWeb.crm.promote.DataList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <style>
        .table_list th
        {
            padding: 0px;
        }
        .table_form td
        {
            height: auto;
            line-height: normal;
            padding: 0px;
        }
        .data_title
        {
            border-top: none;
            border-left: none;
            border-right: none;
        }
        .data_field ul li
        {
            float: left;
            width: 220px;
        }
    </style>
    <div class="list">
        <table class="data_title">
            <tr>
                <td class="data_field">
                    <table width="100%">
                        <tr>
                            <td class="data-label">
                                <asp:PlaceHolder ID="phlCluesSearch" runat="server">姓名：<asp:TextBox ID="txtContactMan"
                                    runat="server" CssClass="text_box"></asp:TextBox>&nbsp;
                                    <asp:CheckBox ID="chkCluesDaySend" runat="server" Text="过滤" /><asp:TextBox ID="txtDayNum"
                                        runat="server" CssClass="text_box width50"></asp:TextBox>天内已发送的线索 </asp:PlaceHolder>
                                <asp:PlaceHolder ID="phlCustomerSearch" runat="server">
                                    <ul>
                                        <li>所在省份：<asp:DropDownList ID="ddlProviceId" runat="server" Width="150">
                                        </asp:DropDownList>
                                        </li>
                                        <li>最后交易：<asp:DropDownList ID="ddlLastBuyDate" runat="server" Width="150">
                                            <asp:ListItem Value="0">不限</asp:ListItem>
                                            <asp:ListItem Value="1">1个月内</asp:ListItem>
                                            <asp:ListItem Value="3">3个月内</asp:ListItem>
                                            <asp:ListItem Value="4">3个月以前</asp:ListItem>
                                        </asp:DropDownList>
                                        </li>
                                        <li>最近创建：<asp:DropDownList ID="ddlCreateDate" runat="server" Width="150">
                                            <asp:ListItem Value="0">不限</asp:ListItem>
                                            <asp:ListItem Value="1">1周内</asp:ListItem>
                                            <asp:ListItem Value="2">1个月内</asp:ListItem>
                                            <asp:ListItem Value="3">3个月内</asp:ListItem>
                                            <asp:ListItem Value="4">3个月以前</asp:ListItem>
                                        </asp:DropDownList>
                                        </li>
                                        <li>客户状态：<asp:DropDownList ID="ddlState" runat="server" Width="150">
                                            <asp:ListItem Value="0">所有客户</asp:ListItem>
                              
                                            <asp:ListItem Value="1">成交客户</asp:ListItem>
                                            <asp:ListItem Value="2">潜在客户</asp:ListItem>
                                        </asp:DropDownList>
                                        </li>
                                        <li>客户种类：<asp:DropDownList ID="ddlBizTypeID" runat="server" Width="150">
                                        </asp:DropDownList>
                                        </li>
                                        <li>客户名称:<asp:TextBox ID="txtCustomerName" runat="server" CssClass="text_box"></asp:TextBox></li>
                                        <li>消费金额：<asp:TextBox ID="txtExpenditureStart" runat="server" CssClass="text_box width50"></asp:TextBox>到<asp:TextBox
                                            ID="txtExpenditureEnd" runat="server" CssClass="text_box width50"></asp:TextBox>元</li>
                                        <li>交易次数：<asp:TextBox ID="txtBuyNumStart" runat="server" CssClass="text_box width50"></asp:TextBox>到<asp:TextBox
                                            ID="txtBuyNumEnd" runat="server" CssClass="text_box width50"></asp:TextBox>次</li>
                                        <li>过滤已搁置<asp:TextBox ID="txtLastContactTime" runat="server" CssClass="text_box width50"></asp:TextBox>天以内的客户
                                        </li>
                                        <li>
                                            <asp:CheckBox ID="chkCustomerDaySend" runat="server" Text="过滤" /><asp:TextBox ID="txtCustomerDayNum"
                                                runat="server" CssClass="text_box width50"></asp:TextBox>天内已发送的客户 </li>
                                        <li>
                                            <asp:CheckBox ID="chkBlack" runat="server" Text="过滤黑名单客户" />
                                        </li>
                                    </ul>
                                </asp:PlaceHolder>
                                <asp:Button ID="btnSearch" runat="server" Text=" 查 询 " CssClass="btn_77px" />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <asp:GridView ID="gvCustomer" runat="server" AutoGenerateColumns="False" DataKeyNames="CustomerID"
            GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
            OnRowDataBound="gvCustomerList_RowDataBound">
            <RowStyle HorizontalAlign="Left" />
            <Columns>
                <asp:TemplateField>
                    <ItemTemplate>
                        <input id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("CustomerID")%>' />
                    </ItemTemplate>
                    <ItemStyle Width="20px" />
                </asp:TemplateField>
                <asp:BoundField DataField="CustomerID" HeaderText="编号" Visible="false">
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:BoundField>
                <asp:TemplateField HeaderText="客户相关信息">
                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        <asp:HyperLink ID="hypView" runat="server" Target="_blank"><strong><%# Eval("CustomerName").ToString()%></strong></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="CityName" HeaderText="城市"></asp:BoundField>
                <asp:BoundField DataField="StageName" HeaderText="阶段" Visible="False"></asp:BoundField>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <asp:Label ID="lblState" runat="server" Text="Label"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="交易数">
                    <ItemTemplate>
                        <%# ObjToStr(Eval("OrderCount")) == "0" ? "" : Eval("OrderCount")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="最近交易">
                    <ItemTemplate>
                        <%# ObjToStr(Eval("LastTradeDate")).Contains("0001") ? "" :Convert.ToDateTime(Eval("LastTradeDate")).ToShortDateString()%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="业务负责">
                    <ItemTemplate>
                        <asp:Label ID="lblOwnerName" runat="server" Text='<%#Eval("OwnerName") %>'></asp:Label>
                        <asp:Label ID="lblOwnerID" runat="server" Text='<%#Eval("OwnerID") %>' Visible="false"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="CreateDate" HeaderText="创建日期" SortExpression="Customer.CreateDate"
                    DataFormatString="{0:g}" HtmlEncode="false"></asp:BoundField>
            </Columns>
        </asp:GridView>
        <asp:GridView ID="gvCluesData" runat="server" AutoGenerateColumns="False" DataKeyNames="ID"
            GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
            OnRowDataBound="gvClues_RowDataBound">
            <RowStyle HorizontalAlign="Left" />
            <Columns>
                <asp:TemplateField>
                    <ItemTemplate>
                        <input id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("Id")%>' />
                    </ItemTemplate>
                    <ItemStyle Width="20px" />
                </asp:TemplateField>
                <asp:BoundField DataField="ContactMan" HeaderText="姓名"></asp:BoundField>
                <asp:BoundField DataField="CustomerName" HeaderText="公司名称"></asp:BoundField>
                <asp:BoundField DataField="Telephone" HeaderText="电话">
                    <ItemStyle Width="100px" />
                </asp:BoundField>
                <asp:BoundField DataField="Mobile" HeaderText="手机">
                    <ItemStyle Width="80px" />
                </asp:BoundField>
                <asp:BoundField DataField="Fax" HeaderText="传真" />
                <asp:BoundField DataField="Email" HeaderText="Email" />
                <asp:BoundField DataField="CreateDate" HeaderText="创建时间" />
                <asp:BoundField DataField="TransformStateText" HeaderText="状态" />
            </Columns>
        </asp:GridView>
        <div class="pager-bar">
            <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                PageSize="10" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                ShowBoxThreshold="5" SubmitButtonText="跳 转" UrlPaging="True">
            </webdiyer:AspNetPager>
        </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            var selectIds = $("#ctl00_ContentPlace_hidSelectIds", window.parent.document).val().split(',');
            $('input[type="checkbox"]').each(function () {
                if ($(this).attr("name").lastIndexOf("chkItem") > 0) {
                    if ($.inArray($(this).val(), selectIds) > -1)
                        $(this).attr("checked", "true");
                }
            })
            $('input[type="checkbox"]').bind("click", function () {
                var checkedValue = $(this).attr("checked");
                var value = $(this).val();
                var sIds = [];
                $.each(selectIds, function (n, v) {
                    if (value != v) {
                        sIds.push(v);
                    }
                });
                if (checkedValue) {
                    sIds.push(value);
                }
                selectIds = sIds;
                $("#ctl00_ContentPlace_hidSelectIds", window.parent.document).val(selectIds);
            })
            $("#<%=btnSearch.ClientID %>").click(function () {
                selectIds = [];
                $("#ctl00_ContentPlace_hidSelectIds", window.parent.document).val(selectIds);
            })
            var vFilter = "<%=Filter %>";
            if (vFilter != "" && $('input[type="checkbox"]').length > 0)
                $("#ctl00_ContentPlace_hidFromFilter", window.parent.document).val("<%=Filter %>");
            else
                $("#ctl00_ContentPlace_hidFromFilter", window.parent.document).val("");
        });
    </script>
</asp:Content>
