﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="OrderRecycleList.aspx.cs" Inherits="OAWeb.crm.orders.OrderRecycleList" %>

<%@ Register Src="../../UserControls/OrderNav.ascx" TagName="OrderNav" TagPrefix="uc1" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:OrderNav ID="OrderNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    订单回收站
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    <asp:DropDownList ID="ddlField" runat="server">
                                        <asp:ListItem Value="OrderSN">订单号</asp:ListItem>
                                        <asp:ListItem Value="CustomerName">客户名称</asp:ListItem>
                                    </asp:DropDownList>
                                    <asp:TextBox ID="txtKeyword" runat="server" CssClass="text_box"></asp:TextBox><asp:Button
                                        ID="btnSearch" runat="server" Text="查  询" class="btn_77px" />
                                </td>
                            </tr>
                        </table>
                        <div class="list">
                            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                                GridLines="None" OnRowDataBound="gvData_RowDataBound" CellSpacing="0" CellPadding="0"
                                CssClass="table_list" EnableModelValidation="True">
                                <RowStyle HorizontalAlign="Left" />
                                <Columns>
                                    <asp:TemplateField HeaderText="编号">
                                        <HeaderTemplate>
                                            <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                                        </HeaderTemplate>
                                        <ItemTemplate>
                                            <input id="chkItem" type="checkbox" value="<%#Eval("Id") %>" <%#(Eval("AuditState").ToString() != "0" && Eval("AuditState").ToString() != "2") ? "disabled=disabled" : ""%> />
                                        </ItemTemplate>
                                        <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                                        <ItemStyle HorizontalAlign="Center" Width="10px"></ItemStyle>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="订单号">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="hypView" runat="server" Text='<%# Eval("OrderSN") %>'></asp:HyperLink>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="CustomerName" HeaderText="客户名称"></asp:BoundField>
                                    <asp:BoundField DataField="OrderDate" HeaderText="下单时间"></asp:BoundField>
                                    <asp:BoundField DataField="OrderTotal" HeaderText="订单金额" DataFormatString="{0:f2}">
                                    </asp:BoundField>
                                    <asp:BoundField DataField="AuditStateText" HeaderText="订单状态"></asp:BoundField>
                                    <asp:BoundField DataField="PayStateText" HeaderText="付款状态"></asp:BoundField>
                                    <asp:BoundField DataField="DeliveryStatusText" HeaderText="发货状态"></asp:BoundField>
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                            <asp:LinkButton ID="lbtnOrder" runat="server">还原</asp:LinkButton>
                                            <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                            <div class="pager-bar">
                                <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                                    PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                                    ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="true">
                                </webdiyer:AspNetPager>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
