﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="OrderProduct.aspx.cs" Inherits="OAWeb.crm.orders.OrderProduct" %>

<%@ Register Src="../../UserControls/OrderNav.ascx" TagName="OrderNav" TagPrefix="uc1" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:OrderNav ID="OrderNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    <em style="float: left">
                                        <img src="/images/10.gif" />
                                    </em>销售明细<br />
                                    <span class="tip01">管理订单销售明细</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    <a href="OrderProduct.aspx">全部</a> <a href="OrderProduct.aspx?s=0">待发货</a> <a href="OrderProduct.aspx?s=2">
                                        部分发货</a> <a href="OrderProduct.aspx?s=1">已发货</a> <a href="OrderProduct.aspx?s=3">部分退货</a>
                                    <a href="OrderProduct.aspx?s=4">已退货</a><br />
                                    客户名称:
                                    <asp:TextBox ID="txtCustomerName" runat="server" CssClass="text_box" ReadOnly="True"></asp:TextBox>&nbsp;
                                    <input type="button" value="选择" onclick="OpenRadioDialog('/Dialog/CustomerDialog.aspx', '选择客户', CallbackFun);" />
                                    &nbsp;<input type="button" value="置空" onclick=" Reset();" />
                                    品项:
                                    <asp:TextBox ID="txtProductName" runat="server" CssClass="text_box"></asp:TextBox>
                                    类型:<asp:DropDownList ID="ddlType" runat="server">
                                        <asp:ListItem Value="-1">请选择</asp:ListItem>
                                        <asp:ListItem Value="0">首单</asp:ListItem>
                                        <asp:ListItem Value="1">续单</asp:ListItem>
                                    </asp:DropDownList>
                                    下单时间：<asp:TextBox ID="txtCreateDateStart" runat="server" CssClass="text_box" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})"></asp:TextBox>-<asp:TextBox
                                        ID="txtCreateDateEnd" runat="server" CssClass="text_box" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})"></asp:TextBox>
                                    <asp:HiddenField ID="hdfCustomerId" runat="server" />
                                    <asp:Button ID="btnSearch" runat="server" Text="查  询" class="btn_77px" />
                                </td>
                            </tr>
                        </table>
                        <div class="list">
                            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                                GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                                OnRowDataBound="gvData_RowDataBound">
                                <RowStyle HorizontalAlign="Left" />
                                <Columns>
                                    <asp:TemplateField HeaderText="品项">
                                        <ItemTemplate>
                                            <%# Eval("ProductName") %>
                                            <span class="red">
                                                <%# Eval("TypeText").ToString() == "续单" ? "（续单）" : ""%></span><br />
                                            <%# Eval("SN").ToString() == "" ? "" : ("(序列号：" + Eval("SN").ToString() + ")")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="销售单">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="hypView" Target="_blank" runat="server" Text='<%# Eval("OrderSN") %>'></asp:HyperLink>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:HyperLinkField DataNavigateUrlFields="CustomerId" DataNavigateUrlFormatString="/crm/customer/CustomerView.aspx?CustomerID={0}"
                                        DataTextField="CustomerName" HeaderText="客户名称" Target="_blank" />
                                    <asp:BoundField DataField="CreateDate" HeaderText="下单时间"></asp:BoundField>
                                    <asp:BoundField DataField="StateText" HeaderText="状态"></asp:BoundField>
                                    <asp:BoundField DataField="RealPrice" HeaderText="成交价格" 
                                        DataFormatString="￥{0:F2}"></asp:BoundField>
                                    <asp:TemplateField HeaderText="订购数量">
                                        <ItemTemplate>
                                            <%# Eval("PayNum") %>
                                            <%# Eval("Unit") %>
                                        </ItemTemplate>
                                        <EditItemTemplate>
                                            <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("[PayNum,Unit]") %>'></asp:TextBox>
                                        </EditItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="Amount" HeaderText="金额"></asp:BoundField>
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                            <asp:LinkButton ID="lbtnShip" runat="server">发货</asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                            <div class="pager-bar">
                                <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                                    PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                                    ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                                </webdiyer:AspNetPager>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        function CallbackFun(text, value) {
            $('#<%=txtCustomerName.ClientID %>').val(text);
            $('#<%=hdfCustomerId.ClientID %>').val(value);
        }
        function Reset() {
            $('#<%=txtCustomerName.ClientID %>').val("");
            $('#<%=hdfCustomerId.ClientID %>').val("");
        }
    </script>
</asp:Content>
