﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Main.Master" CodeBehind="OrderEdit2.aspx.cs"
    Inherits="OAWeb.crm.orders.OrderEdit2" %>

<%@ Register Src="../../UserControls/OrderNav.ascx" TagName="OrderNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script src="/js/jquery.form.js" type="text/javascript"></script>
    <style type="text/css">
        .list .table_list th, .list .table_list td
        {
            line-height: 14px;
            height: 14px;
        }
        .div_pane
        {
            height: auto;
        }
        .TopText
        {
            margin-right: 10px;
            font-weight: normal;
        }
        .CenterText
        {
            margin-left: 10px;
            height: 35px;
            line-height: 35px;
        }
        .OrderTotal span
        {
            height: 30px;
            line-height: 30px;
        }
        .RadioList label
        {
            margin-left: 10px;
            margin-right: 10px;
        }
    </style>
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:OrderNav ID="OrderNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <div class="div_pane bgColor01" style="border: solid 1px #ddd;">
                            <em style="float: left; margin-right: 10px">
                                <img src="/images/10.gif" />
                            </em><span style="font-size: 18px;">
                                <%=Id == Guid.Empty ? "新增":"编辑"%>订单：<asp:Label ID="lblOrderSn" runat="server" Text=""></asp:Label></span><br />
                            <span style="">客户：</span> <span class="TopText"><a target="_blank" id="LinkCustomer" runat="server">
                                <asp:Label ID="lblCustomerName" runat="server" Text=""></asp:Label></a></span>
                            <span class="TopText"><a id="btnCustomerSelect"  runat="server" href="javascript:void(0)">
                                [ 选择 ]</a></span> <span style="">下单时间：</span> <span class="TopText">
                                    <asp:Label ID="lblCreateDate" runat="server" Text=""></asp:Label></span>
                            <span>业务员：</span> <span class="TopText">
                                <asp:Label ID="lblTrackUserName" runat="server" Text=""></asp:Label></span>
                            <span class="TopText"><a id="btnUserSelect" href="javascript:void(0)">[ 修改 ]</a></span>
                        </div>
                        <div class="order_widget">
                            <strong class="fonts " style="margin: 10px;">收货地址</strong> <span id="" style="color: #4395B9;">
                                <asp:Literal ID="ltlAddrs" runat="server"></asp:Literal></span> <a href="javascript:void(0)"
                                    class="addrsDialog">[ 填写收货地址 ]</a>
                            <br />
                            <span id="addrs" style="color: #4395B9;" class="CenterText" runat="server"><font
                                color="red">您还没有填写收货地址信息 </font></span>
                        </div>
                        <div class="order_widget">
                            <strong class="fonts " style="margin: 10px;">配送方式</strong>
                            <br />
                            <span class="CenterText">
                                <asp:RadioButtonList ID="ddlShippingId" runat="server" RepeatDirection="Horizontal"
                                    RepeatLayout="Flow" CssClass="RadioList">
                                </asp:RadioButtonList>
                                <span style="margin: 15px;">运费:
                                    <asp:TextBox ID="txtFreight" runat="server" CssClass="text width50" MaxLength="8">0</asp:TextBox></span>
                            </span>
                        </div>
                        <div class="order_widget">
                            <strong class="fonts " style="margin: 10px;">支付方式</strong>
                            <br />
                            <span class="CenterText">
                                <asp:RadioButtonList ID="ddlPayMothodId" runat="server" RepeatDirection="Horizontal"
                                    RepeatLayout="Flow" CssClass="RadioList">
                                </asp:RadioButtonList>
                            </span>
                        </div>
                        <div class="order_widget">
                            <strong class="fonts " style="margin: 10px;">发票信息</strong>
                            <br />
                            <span class="CenterText"><span>
                                <asp:CheckBox ID="chkbInvoice" runat="server" />开启发票 &nbsp;&nbsp;&nbsp;</span>
                                <div style="display: none;" class="bInvoice_item ">
                                    发票类型：<asp:RadioButtonList ID="rdoInvType" runat="server" RepeatDirection="Horizontal"
                                        RepeatLayout="Flow">
                                        <asp:ListItem Value="0" Selected="True">普通发票</asp:ListItem>
                                        <asp:ListItem Value="1">增值税发票</asp:ListItem>
                                    </asp:RadioButtonList>
                                    <br />
                                    <div id="DivInv" runat="server">
                                        增值税发票资质：<br />
                                        <asp:TextBox ID="txtInvoiceAptitude" Width="250" Height="50" runat="server" TextMode="MultiLine"></asp:TextBox>
                                        <br />
                                    </div>
                                    <span>发票抬头：<asp:TextBox ID="txtInvPayee" runat="server" CssClass="text width200"></asp:TextBox></span><br />
                                    <span style="display: none;">发票内容：<asp:TextBox ID="txtInvContent" Visible="false"
                                        runat="server" CssClass="text width200"></asp:TextBox></span>
                                </div>
                            </span>
                        </div>
                        <div class="order_widget">
                            <strong class="fonts " style="margin: 10px;">商品清单</strong>
                            <br />
                            <div class="list" style="margin-left: 10px; margin-top: 10px;">
                                <table class="table_list" cellspacing="0" cellpadding="0" border="0" id="ctl00_ContentPlace_gvData"
                                    style="border-collapse: collapse;">
                                    <tr>
                                        <th scope="col" style="width: 50px; background-color: #E2E8EB">
                                            <input name="btnAdd" type="button" value="添加" />
                                        </th>
                                        <th scope="col" style="background-color: #E2E8EB">
                                            商品货号
                                        </th>
                                        <th scope="col" style="background-color: #E2E8EB">
                                            商品名称
                                        </th>
                                        <th scope="col" style="background-color: #E2E8EB">
                                            成交价
                                        </th>
                                        <th scope="col" style="background-color: #E2E8EB">
                                            购买数量
                                        </th>
                                    </tr>
                                    <tr class="good_tip" style="display: <%=Id ==  Guid.Empty && SnId== Guid.Empty ? "" : "none"%>">
                                        <td colspan="5">
                                            您还没有添加任何商品，请点此<a href="javascript:void(0)" class="btnAdd">添加</a>。
                                        </td>
                                    </tr>
                                    <asp:Repeater ID="rptData" runat="server">
                                        <ItemTemplate>
                                            <tr align="left">
                                                <td>
                                                    <a href="javascript:void(0)" class="item_delete">删除</a>
                                                    <input name="p_id[<%#Eval("ProductId") %>]" value="<%#Eval("ProductId") %>" type="hidden" />
                                                    <input name="p_SN[<%#Eval("ProductId") %>]" value="<%#Eval("SN") %>" type="hidden" />
                                                    <input name="p_IsRenewal[<%#Eval("ProductId") %>]" value="<%#Eval("IsRenewal") %>"
                                                        type="hidden" />
                                                </td>
                                                <td>
                                                    <%#Eval("ProductSN")%>
                                                </td>
                                                <td>
                                                    <%#Eval("ProductName")%>
                                                    <span class="red">
                                                        <%#Eval("IsRenewal").ToString() == "1" ? "[续单]" : ""%>
                                                    </span>
                                                    <%#Eval("SN").ToString() != "" ? ("(序列号：" + Eval("SN").ToString() + ")") : ""%>
                                                </td>
                                                <td class="product_price">
                                                    <input type="text" name="p_price[<%#Eval("ProductId") %>]" class="p_price text width50"
                                                        value="<%#Eval("RealPrice") %>" />
                                                </td>
                                                <td>
                                                    <input type="text" name="p_paynum[<%#Eval("ProductId") %>]" class="p_paynum text width50"
                                                        value="<%#Eval("PayNum") %>" />
                                                    <%#Eval("Unit") %>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </table>
                            </div>
                        </div>
                        <div class="order_widget">
                            <table style="width: 100%">
                                <tr>
                                    <td>
                                        <strong class="fonts " style="margin: 10px;">订单备注</strong>
                                        <br />
                                        <br />
                                        <span class="CenterText" style="">
                                            <asp:TextBox ID="txtRemark" runat="server" CssClass="text" Width="300" TextMode="MultiLine"
                                                Height="80px"></asp:TextBox>
                                        </span>
                                    </td>
                                    <td class="OrderTotal" style="text-align: right">
                                        <span>商品总价：<span id="pAmount" style="color: #A40200"><asp:Literal ID="ltlGoodsAmountText"
                                            runat="server" Text="0.00"></asp:Literal></span></span><br />
                                        运费：<span id="freight"><asp:Literal ID="ltlFreightText" runat="server" Text="0.00"></asp:Literal></span><br />
                                        保险费：<span id="Insurance"><asp:Literal ID="ltlInsurance" runat="server" Text="0.00"></asp:Literal></span><br />
                                        手续费：<span id="fee"><asp:Literal ID="ltlPayFeeText" runat="server" Text="0.00"></asp:Literal></span><br />
                                        <span>税金：</span><span id="Span1"><asp:TextBox ID="txtTax" runat="server" Text="0.00"
                                            Width="30"></asp:TextBox></span><br />
                                        <span style="color: #A40200">订单总金额：<span id="amount"><asp:Literal ID="ltlOrderTotalText"
                                            runat="server" Text="0.00"></asp:Literal></span></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align: center; padding-top: 15px;">
                                        <input id="btnSave" type="button" value=" 保 存 " class="btn_77px" />
                                        <input id="btnClose" type="button" value=" 返 回 " onclick="window.location.href = '<%=ReturnUrl %>'"
                                            class="btn_77px" />
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
                <asp:HiddenField ID="hdfTrackUserID" runat="server" />
                <asp:HiddenField ID="hdfCustomerId" runat="server" />
                <asp:HiddenField ID="hdfRegionId" runat="server" Value="0" />
                <asp:HiddenField ID="hdfPayFee" runat="server" />
                <asp:HiddenField ID="hdfGoodsAmount" runat="server" />
                <asp:HiddenField ID="hifOrderTotal" runat="server" />
                <asp:HiddenField ID="hdfIsRenewal" runat="server" />
            </td>
        </tr>
    </table>
    <script type="text/javascript">

        $(document).ready(function () {
            $("#btnSave").click(function () { return FormPostAjax("/crm/orders/OrderEdit2.aspx?op=Save&Id=<%=Id %>", "ok", function () { window.location.href = "<%=ReturnUrl %>"; }); });
        });
    </script>
    <script src="order.helper2.js" type="text/javascript"></script>
    <script>

        $(document).ready(function () {
            if ("<%=Id %>" == "00000000-0000-0000-0000-000000000000")
                document.getElementsByName("ctl00$ContentPlace$ddlShippingId")[0].click();
        })

    </script>
</asp:Content>
