﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="OrderEdit.aspx.cs" Inherits="OAWeb.crm.orders.OrderEdit" %>

<%@ Register Src="../../UserControls/OrderNav.ascx" TagName="OrderNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script src="/js/jquery.form.js" type="text/javascript"></script>
    <style type="text/css">
        .list .table_list th, .list .table_list td
        {
            line-height: 14px;
            height: 14px;
        }
    </style>
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:OrderNav ID="OrderNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <div class="div_pane bgColor01" style="border: solid 1px #ddd; border-bottom: none;">
                            <em style="float: left">
                                <img src="/images/10.gif" />
                            </em>
                            <%=Id == Guid.Empty ? "新增":"编辑"%>订单
                        </div>
                        <div class="form" style="border: solid 1px #ddd; padding: 5px;">
                            <table cellpadding="0" cellspacing="0" border="0" class="table_form">
                                <tr>
                                    <td class="title" colspan="4">
                                        <h1>
                                            基本信息</h1>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="right">
                                        订单号:
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtOrderSN" Text="" runat="server" CssClass="text" ReadOnly="True"></asp:TextBox>
                                    </td>
                                    <td class="right ">
                                        <span class="red">*</span> 负责人:
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtTrackUserName" runat="server" CssClass="TrackUserName text" ReadOnly="True">
                                        </asp:TextBox>&nbsp;<input id="btnUserSelect" type="button" value="选择" />
                                        &nbsp;<input id="btnUserClear" type="button" value="置空" />
                                    </td>
                                </tr>
                                <tr>
                                    <td class="right">
                                        下单时间:
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtOrderDate" Text="" runat="server" CssClass="text" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})"></asp:TextBox>
                                    </td>
                                    <td class="right ">
                                        <span class="red">*</span> 下单客户:
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtCustomerName" runat="server" CssClass="CustomerName text" ReadOnly="True">
                                        </asp:TextBox>&nbsp;<input id="btnCustomerSelect" type="button" value="选择" />
                                        &nbsp;<input id="btnCustomerClear" type="button" value="置空" />
                                    </td>
                                </tr>
                                <tr>
                                    <td class="right">
                                        物流公司:
                                    </td>
                                    <td>
                                        <asp:TextBox ID="txtLogistic" runat="server" CssClass="text" MaxLength="8"></asp:TextBox>
                                    </td>
                                    <td class="right">
                                        <span class="red">*</span> 货币类型:
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlCurrency" runat="server">
                                            <asp:ListItem Value="0">-请选择-</asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="right">
                                        <span class="red">*</span> 配送方式:
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlShippingId" runat="server">
                                            <asp:ListItem Value="0">请选择配送方式</asp:ListItem>
                                        </asp:DropDownList>
                                        运费:
                                        <asp:TextBox ID="txtFreight" runat="server" CssClass="text width50" MaxLength="8">0</asp:TextBox>
                                    </td>
                                    <td class="right ">
                                        <span class="red">*</span> 支付方式:
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlPayMothodId" runat="server">
                                            <asp:ListItem Value="0">请选择支付方式</asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="right ">
                                        保险费:
                                    </td>
                                    <td colspan="3">
                                        <asp:TextBox ID="txtInsurance" runat="server" CssClass="text width50" MaxLength="8">0</asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="right">
                                        订单备注:
                                    </td>
                                    <td colspan="3">
                                        <asp:TextBox ID="txtRemark" runat="server" CssClass="text" Width="99%" TextMode="MultiLine"
                                            Height="100px"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="right">
                                        收货地址:
                                    </td>
                                    <td colspan="3" style="color: #4395B9;">
                                        <span id="addrs">
                                            <asp:Literal ID="ltlAddrs" runat="server"></asp:Literal></span>
                                        <img class='ico03 addrsDialog' src="/images/transparent.gif" style="cursor: hand"
                                            onclick="" />
                                    </td>
                                </tr>
                                <tr>
                                    <td class="title" colspan="4">
                                        <h1>
                                            商品清单</h1>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4">
                                        <div class="list">
                                            <table class="table_list" cellspacing="0" cellpadding="0" border="0" id="ctl00_ContentPlace_gvData"
                                                style="border-collapse: collapse;">
                                                <tr>
                                                    <th scope="col" style="width: 50px; background-color: #E2E8EB">
                                                        <input name="btnAdd" type="button" value="添加" />
                                                    </th>
                                                    <th scope="col" style="background-color: #E2E8EB">
                                                        商品货号
                                                    </th>
                                                    <th scope="col" style="background-color: #E2E8EB">
                                                        商品名称
                                                    </th>
                                                    <th scope="col" style="background-color: #E2E8EB">
                                                        成交价
                                                    </th>
                                                    <th scope="col" style="background-color: #E2E8EB">
                                                        购买数量
                                                    </th>
                                                </tr>
                                                <tr class="good_tip" style="display: <%=Id ==  Guid.Empty && SnId== Guid.Empty ? "" : "none"%>">
                                                    <td colspan="5">
                                                        您还没有添加任何商品，请点此<a href="javascript:void(0)" class="btnAdd">添加</a>。
                                                    </td>
                                                </tr>
                                                <asp:Repeater ID="rptData" runat="server">
                                                    <ItemTemplate>
                                                        <tr align="left">
                                                            <td>
                                                                <a href="javascript:void(0)" class="item_delete">删除</a>
                                                                <input name="p_id[<%#Eval("ProductId") %>]" value="<%#Eval("ProductId") %>" type="hidden" />
                                                                <input name="p_SN[<%#Eval("ProductId") %>]" value="<%#Eval("SN") %>" type="hidden" />
                                                                <input name="p_IsRenewal[<%#Eval("ProductId") %>]" value="<%#Eval("IsRenewal") %>"
                                                                    type="hidden" />
                                                            </td>
                                                            <td>
                                                                <%#Eval("ProductSN")%>
                                                            </td>
                                                            <td>
                                                                <%#Eval("ProductName")%>
                                                                <span class="red">
                                                                    <%#Eval("IsRenewal").ToString() == "1" ? "[续单]" : ""%>
                                                                </span>
                                                                <%#Eval("SN").ToString() != "" ? ("(序列号：" + Eval("SN").ToString() + ")") : ""%>
                                                            </td>
                                                            <td class="product_price">
                                                                <input type="text" name="p_price[<%#Eval("ProductId") %>]" class="p_price text width50"
                                                                    value="<%#Eval("RealPrice") %>" />
                                                            </td>
                                                            <td>
                                                                <input type="text" name="p_paynum[<%#Eval("ProductId") %>]" class="p_paynum text width50"
                                                                    value="<%#Eval("PayNum") %>" />
                                                                <%#Eval("Unit") %>
                                                            </td>
                                                        </tr>
                                                    </ItemTemplate>
                                                </asp:Repeater>
                                            </table>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="order_result">
                                        <div style="float: right;">
                                            <span>商品总价:<span id="pAmount" style="color: #A40200"><asp:Literal ID="ltlGoodsAmountText"
                                                runat="server" Text="0.00"></asp:Literal></span></span><br />
                                            运费:<span id="freight"><asp:Literal ID="ltlFreightText" runat="server" Text="0.00"></asp:Literal></span><br />
                                            保险费：<span id="Insurance"><asp:Literal ID="ltlInsurance" runat="server" Text="0.00"></asp:Literal></span><br />
                                            手续费：<span id="fee"><asp:Literal ID="ltlPayFeeText" runat="server" Text="0.00"></asp:Literal></span><br />
                                            <span style="color: #A40200">订单总金额:<span id="amount"><asp:Literal ID="ltlOrderTotalText"
                                                runat="server" Text="0.00"></asp:Literal></span></span>
                                        </div>
                                        <span>
                                            <asp:CheckBox ID="chkbInvoice" runat="server" />开启发票 &nbsp;&nbsp;&nbsp;发票号：<asp:TextBox
                                                ID="txtInvNo" runat="server" CssClass="text width200"></asp:TextBox></span>
                                        <div style="display: none;" class="bInvoice_item">
                                            发票类型：<asp:RadioButtonList ID="rdoInvType" runat="server" RepeatDirection="Horizontal"
                                                RepeatLayout="Flow">
                                                <asp:ListItem Value="0" Selected="True">普通发票</asp:ListItem>
                                                <asp:ListItem Value="1">增值税发票</asp:ListItem>
                                            </asp:RadioButtonList>
                                            <br />
                                            <span>&nbsp;&nbsp;&nbsp;发票税：<asp:TextBox ID="txtTax" runat="server" CssClass="text width50"
                                                Text="0"></asp:TextBox></span><br />
                                            <span>发票抬头：<asp:TextBox ID="txtInvPayee" runat="server" CssClass="text width200"></asp:TextBox></span><br />
                                            <span style="display: none;">发票内容：<asp:TextBox ID="txtInvContent" Visible="false"
                                                runat="server" CssClass="text width200"></asp:TextBox></span><br />
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4" style="text-align: center">
                                        <asp:HiddenField ID="hdfTrackUserID" runat="server" />
                                        <asp:HiddenField ID="hdfCustomerId" runat="server" />
                                        <asp:HiddenField ID="hdfRegionId" runat="server" Value="0" />
                                        <asp:HiddenField ID="hdfPayFee" runat="server" />
                                        <asp:HiddenField ID="hdfGoodsAmount" runat="server" />
                                        <asp:HiddenField ID="hifOrderTotal" runat="server" />
                                        <asp:HiddenField ID="hdfIsRenewal" runat="server" />
                                        <input id="btnSave" type="button" value=" 保 存 " class="btn_77px" />
                                        <input id="btnClose" type="button" value=" 返 回 " onclick="window.location.href = '<%=ReturnUrl %>'"
                                            class="btn_77px" />
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#btnSave").click(function () { return FormPostAjax("/crm/orders/OrderEdit.aspx?op=Save&Id=<%=Id %>", "ok", function () { window.location.href = "<%=ReturnUrl %>"; }); });
        });
    </script>
    <script src="order.helper.js" type="text/javascript"></script>
</asp:Content>
