﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="InvoiceList.aspx.cs" Inherits="OAWeb.crm.orders.InvoiceList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="../../UserControls/OrderNav.ascx" TagName="OrderNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:OrderNav ID="OrderNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    <em style="float: left">
                                        <img src="/images/03.gif" />
                                    </em>发票管理<br />
                                    <span class="tip01">您可以编辑、删除发票,可以在订单详细创建新发票。</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    <%=LoadLinkOP() %>
                                    <br />
                                    客户名称：<asp:TextBox ID="txtCustomerName" runat="server" CssClass="text_box"></asp:TextBox>
                                    类型：<asp:DropDownList ID="ddlInvoiceType" runat="server">
                                        <asp:ListItem Value="">请选择</asp:ListItem>
                                        <asp:ListItem Value="0">普通发票</asp:ListItem>
                                        <asp:ListItem Value="1">增值税票</asp:ListItem>
                                    </asp:DropDownList>
                                    日期：<asp:TextBox ID="txtPayDateStart" runat="server" CssClass="text_box" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})"></asp:TextBox>-<asp:TextBox
                                        ID="txtPayDateEnd" runat="server" CssClass="text_box" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})"></asp:TextBox>
                                    <asp:Button ID="btnSearch" runat="server" Text="查  询" class="btn_77px" />
                                </td>
                            </tr>
                        </table>
                        <div class="list">
                            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                                GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                                OnRowDataBound="gvData_RowDataBound">
                                <RowStyle HorizontalAlign="Left" />
                                <Columns>
                                    <asp:BoundField DataField="InvoiceTypeText" HeaderText="发票类型"></asp:BoundField>
                                    <asp:BoundField DataField="InvoiceTax" HeaderText="开票金额" DataFormatString="￥{0:F2}">
                                    </asp:BoundField>
                                    <asp:BoundField DataField="InvoiceNo" HeaderText="发票号码"></asp:BoundField>
                                    <asp:HyperLinkField DataNavigateUrlFields="CustomerId" DataNavigateUrlFormatString="/crm/customer/CustomerView.aspx?CustomerID={0}"
                                        DataTextField="CustomerName" HeaderText="客户" Target="_blank" />
                                    <asp:HyperLinkField DataNavigateUrlFields="OrderId" DataNavigateUrlFormatString="/crm/orders/OrderView.aspx?Id={0}"
                                        DataTextField="OrderSN" HeaderText="订单" Target="_blank" />
                                    <asp:BoundField DataField="StateText" HeaderText="状态"></asp:BoundField>
                                    <asp:BoundField DataField="CreateDate" HeaderText="创建时间"></asp:BoundField>
                                    <asp:BoundField DataField="CreateUserName" HeaderText="创建人"></asp:BoundField>
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                            <asp:LinkButton ID="hypView" runat="server">查看</asp:LinkButton>
                                            
                                            <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                            <div class="pager-bar">
                                <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                                    PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                                    ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                                </webdiyer:AspNetPager>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
