﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="ContactList.aspx.cs"
    Inherits="OAWeb.crm.contact.ContactList" Title="联系人列表" Theme="Default" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/CustomerLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        function Open_Modal_Window(ContactID) {
            OpenWindow('ContactEdit.aspx?ContactID=' + ContactID, 800, 660);
            return false;
        }	
    </script>
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:TaskNav ID="TaskNav1" runat="server" />
            </td>
            <td class="main_center">
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" style=" margin-top:10px;">
                            <tr>
                                <td class="data_caption">
                                    查询联系人
                                </td>
                            </tr>
                            <tr>
                                <td class="data-field">
                                    <asp:RadioButtonList ID="rblOwner" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                        <asp:ListItem Selected="True" Value="1">我的联系人</asp:ListItem>
                                        <asp:ListItem Value="0">所有联系人</asp:ListItem>
                                    </asp:RadioButtonList>
                                    联系人:&nbsp;
                                    <asp:TextBox ID="txtName" runat="server" Width="70px"></asp:TextBox>
                                    QQ:
                                    <asp:TextBox ID="txtQQ" runat="server" Width="70px"></asp:TextBox>
                                    电话/手机:
                                    <asp:TextBox ID="txtMobilePhone" runat="server" Width="80px"></asp:TextBox>
                                    &nbsp;客户名称：<asp:TextBox ID="txtCustomer" runat="server" Width="80px"></asp:TextBox>
                                    <asp:Button ID="btnSearch" runat="server" Text="查  询"  CssClass="btn_77px" />
                                </td>
                            </tr>
                        </table>
                        <div class="buttons-bar" style="  margin-bottom :10px;">
                            <table class="w100p">
                                <tr>
                                    <td class="algin-left">
                                        <asp:Button ID="btnAdd" runat="server" Text="新增" CssClass="btn_77px" />
                                        <asp:Button ID="btnDelete" runat="server" Text="删除" CssClass="btn_77px"/>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <asp:GridView ID="gvContact" runat="server" AutoGenerateColumns="False" DataKeyNames="ContactID,CustomerID"
                            OnRowDataBound="gvContact_RowDataBound">
                            <HeaderStyle  Wrap="False" />
                            <Columns>
                                <asp:TemplateField>
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <input type="checkbox" id="chkItem" value="<%# Eval("ContactId") %>" />
                                    </ItemTemplate>
                                    <ItemStyle Width="20px" />
                                </asp:TemplateField>
                                <asp:BoundField DataField="ContactID" HeaderText="编号" Visible="false">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="名称">
                                    <ItemTemplate>
                                        <asp:LinkButton ID="ViewContact" runat="server" CausesValidation="false" CommandName="lbtViewContact"
                                            CommandArgument='<%#DataBinder.Eval(Container.DataItem,"ContactID").ToString()%>'><%# ObjToStr( Eval("Name")).Length > 10 ? ObjToStr( Eval("Name")).Substring(0, 10) + "..." : Eval("Name")%></asp:LinkButton>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="客户名称">
                                    <ItemTemplate>
                                        <span title='<%#  ObjToStr( Eval("CustomerName"))%>'>
                                            <asp:LinkButton ID="ViewCustomer" runat="server" CausesValidation="false" CommandName="lbtViewCustomer"
                                                CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'><%# ObjToStr(Eval("CustomerName")).Length > 10 ? ObjToStr(Eval("CustomerName")).Substring(0, 10) + "..." : Eval("CustomerName")%></asp:LinkButton>
                                        </span>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:TemplateField>
                                <asp:BoundField DataField="Title" HeaderText="称谓">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                </asp:BoundField>
                                <asp:BoundField DataField="Telphone" HeaderText="电话">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                </asp:BoundField>
                                <asp:BoundField DataField="MobilePhone" HeaderText="手机">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                </asp:BoundField>
                                <asp:BoundField DataField="QQ" HeaderText="QQ">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                </asp:BoundField>
                                <asp:BoundField DataField="IsPrimary" HeaderText="主联系人" />
                                <asp:TemplateField HeaderText="操作">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:LinkButton ID="Edit" runat="server" CausesValidation="false" CommandName="lbtEdit">编辑</asp:LinkButton>
                                        <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                        <div class="pager-bar">
                            <webdiyer:AspNetPager ID="plContact" runat="server" AlwaysShow="True" Direction="LeftToRight"
                                FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                                PrevPageText="[上一页]" ShowCustomInfoSection="Left"
                                Width="100%"  UrlPaging="True">
                            </webdiyer:AspNetPager>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
