﻿<%@ Page Language="C#" MasterPageFile="~/SpmisMaster.Master" AutoEventWireup="true"
    CodeBehind="ClueRuleList.aspx.cs" Inherits="Web.crm.clues.ClueRuleList" Theme="Default" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <script language="javascript" type="text/javascript"> 
    function OpenClue(Id,type){
	  var diag = new Dialog("Clue");
	  if(type=="add"){
	    Dialog.OpenDialog("AddDialog","新增线索待审批规则", "/crm/clues/ClueRuleEdit.aspx", 580, 470);
	  }else if(type == "edit")
	  {
	    Dialog.OpenDialog("EditDialog","编辑线索待审批规则", "/crm/clues/ClueRuleEdit.aspx?ID="+Id, 580, 490);
	  }else
	  {
	    Dialog.OpenDialog("EditDialog","线索待审批规则详细", "/crm/clues/ClueRuleView.aspx?ID="+Id, 580, 470);
	  }
    }        
    </script>

    <div class="buttons-bar">
        <table class="w100p">
            <tr>
                <td class="algin-right">
                    <asp:Button ID="btnAddClue" runat="server" OnClientClick="OpenClue(0,'add'); return false;"
                        Text="新增" CssClass="btn-77px" />
                    <asp:Button ID="btnDel" runat="server" OnClientClick='return confirm("确定要删除吗?")'
                        Text="删除" CssClass="btn-77px" OnClick="btnDel_Click" />
                    <asp:Button ID="btnUpdateDataCache" runat="server" Text="更新缓存" 
                        CssClass="btn-77px" onclick="btnUpdateDataCache_Click" />
                    <input type="button" value="返回" class="btn-77px" onclick="closeWin(true);" />
                </td>
            </tr>
        </table>
    </div>
    <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="ID"
        OnRowDataBound="gvData_RowDataBound" OnRowCommand="gvData_RowCommand">
        <HeaderStyle CssClass="title" Wrap="False" />
        <Columns>
            <asp:TemplateField>
                <HeaderTemplate>
                    <asp:CheckBox ID="chkAll" runat="server" onclick="selectAll(this);" />
                </HeaderTemplate>
                <ItemTemplate>
                    <asp:CheckBox ID="CB_SelectID" runat="server" />
                </ItemTemplate>
                <ItemStyle Width="20px" />
            </asp:TemplateField>
            <asp:BoundField DataField="RuleName" HeaderText="规则名称">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
            </asp:BoundField>
            <asp:BoundField DataField="CreateMan" HeaderText="创建人">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
            </asp:BoundField>
            <asp:BoundField DataField="CreateDate" HeaderText="创建时间"></asp:BoundField>
            <asp:BoundField DataField="AvailDate" HeaderText="使用期限" DataFormatString="{0:d}">
            </asp:BoundField>
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <a href="javascript:void(0)" onclick="OpenClue('<%#Eval("Id") %>','view'); return false;">
                        查看</a>
                    <asp:LinkButton ID="lbtnEdit" runat="server" CommandName="ClueEdit">编辑</asp:LinkButton>
                    <asp:LinkButton ID="lbtnDelete" runat="server" CommandName="cmdDel" CommandArgument='<%#Eval("ID")%>'
                        OnClientClick='return confirm("您确定要删除吗?")'>删除</asp:LinkButton>
                </ItemTemplate>
                <HeaderStyle HorizontalAlign="Center" />
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    <div class="pager-bar">
        <webdiyer:AspNetPager ID="pager" runat="server" AlwaysShow="True" Direction="LeftToRight"
            FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
            PrevPageText="[上一页]" ShowCustomInfoSection="Left" Width="100%" OnPageChanged="pager_PageChanged">
        </webdiyer:AspNetPager>
    </div>
</asp:Content>
