﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="ActionList.aspx.cs"
    Inherits="OAWeb.crm.action.ActionList" Title="活动记录列表" Theme="Default" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/CustomerLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        /*编辑*/
        function OpenWin(ActionID) {
            var Url = "/crm/action/ActionEdit.aspx?ActionID=" + ActionID;
            return OpenDialog(Url, "");
        }
    </script>
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:TaskNav ID="TaskNav1" runat="server" />
            </td>
            <td class="main_center">
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title">
                            <tr>
                                <td class="data-caption" colspan="2">
                                    <asp:Literal ID="ltlCaption" runat="server"></asp:Literal>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    员工姓名:
                                    <asp:TextBox ID="txtName" runat="server" Width="70px"></asp:TextBox>&nbsp; 客户名称:
                                    <asp:TextBox ID="txtCustomerName" runat="server" Width="80px"></asp:TextBox>&nbsp;
                                    &nbsp; 方向:
                                    <asp:DropDownList ID="ddlIsIn" runat="server">
                                        <asp:ListItem Value="-1">全部</asp:ListItem>
                                        <asp:ListItem Value="1">被动</asp:ListItem>
                                        <asp:ListItem Value="0">主动</asp:ListItem>
                                    </asp:DropDownList>
                                    &nbsp; &nbsp; 类型:
                                    <asp:DropDownList ID="ddlActionTypeID" runat="server">
                                    </asp:DropDownList>
                                    &nbsp; &nbsp; 活动主题:
                                    <asp:TextBox ID="txtTopic" runat="server" Width="80px"></asp:TextBox>&nbsp; &nbsp;
                                    活动时间:
                                    <asp:TextBox ID="txtBegionActionDate" runat="server" onfocus="WdatePicker()" Width="70px"></asp:TextBox>
                                    到<asp:TextBox ID="txtEndActionDate" runat="server" onfocus="WdatePicker()" Width="70px"></asp:TextBox>
                                    <asp:Button ID="btnSearch" runat="server" Text="查  询" CssClass="btn_77px" />
                                </td>
                                <td class="data-field">
                                    <asp:DropDownList ID="ddlSearchView" runat="server" AutoPostBack="True" Width="200px"
                                        OnSelectedIndexChanged="ddlSearchView_SelectedIndexChanged" Visible="false">
                                    </asp:DropDownList>
                                    <asp:Button ID="btnEditSearchView" runat="server" Text="视图管理" CssClass="btn_77px"
                                        Visible="false" />
                                </td>
                            </tr>
                        </table>
                        <div class="buttons-bar" style="margin-bottom: 10px;">
                            <asp:Button ID="btnAdd" runat="server" Text="新建" CssClass="btn_77px" />
                            <asp:Button ID="btnBatchDelete" runat="server" Text="批量删除" CssClass="btn_77px" />
                        </div>
                        <asp:GridView ID="gvAction" runat="server" AutoGenerateColumns="False" DataKeyNames="ActionID"
                            OnRowCommand="gvAction_RowCommand" OnRowDataBound="gvAction_RowDataBound">
                            <HeaderStyle CssClass="title" Wrap="False" />
                            <Columns>
                                <asp:TemplateField>
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <input type="checkbox" id="chkItem" value="<%# Eval("ActionId") %>" />
                                    </ItemTemplate>
                                    <ItemStyle Width="20px" />
                                </asp:TemplateField>
                                <asp:BoundField DataField="ActionID" HeaderText="编号" Visible="false">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="主题">
                                    <ItemTemplate>
                                        <span title='<%#DataBinder.Eval(Container.DataItem,"Topic").ToString()%>'>
                                            <asp:LinkButton ID="View" runat="server" CausesValidation="false" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"ActionID").ToString()%>'
                                                CommandName="lbtView"><%# Eval("Topic").ToString().Length > 10 ? Eval("Topic").ToString().Substring(0, 10) + "..." : Eval("Topic").ToString()%></asp:LinkButton>
                                        </span>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="客户名称">
                                    <ItemTemplate>
                                        <span title='<%#DataBinder.Eval(Container.DataItem,"CustomerName").ToString()%>'>
                                            <asp:LinkButton ID="ViewCustomer" runat="server" CausesValidation="false" CommandName="lbtViewCustomer"
                                                CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'><%# Eval("CustomerName").ToString().Length > 10 ? Eval("CustomerName").ToString().Substring(0, 10) + "..." : Eval("CustomerName").ToString()%></asp:LinkButton>
                                        </span>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="对方号码">
                                    <ItemStyle HorizontalAlign="Center" />
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <span id="spNumber" runat="server">
                                            <%# Eval("ActionTypeInfo") %></span> <span id="spInfo" runat="server"></span>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="类型">
                                    <ItemStyle HorizontalAlign="Center" />
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:Label ID="lblIsIn" runat="server" Text=''></asp:Label>
                                        (
                                        <%# Eval("ActionTypeName")%>
                                        )
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="开始时间">
                                    <ItemStyle HorizontalAlign="Center" />
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:Label ID="lblTime" runat="server" Text=''></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="SpendTime" HeaderText="时长(分)">
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:BoundField>
                                <asp:BoundField DataField="RealName" HeaderText="员工" />
                                <asp:TemplateField HeaderText="操作">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:LinkButton ID="LinkPlay" runat="server" Visible="false">播放</asp:LinkButton>
                                        <asp:LinkButton ID="Edit" runat="server" CausesValidation="false" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"ActionID").ToString()%>'
                                            CommandName="lbtEdit">编辑</asp:LinkButton>
                                        <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                        <div class="pager-bar">
                            <webdiyer:AspNetPager ID="plAction" runat="server" AlwaysShow="True" Direction="LeftToRight"
                                FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                                PrevPageText="[上一页]" ShowCustomInfoSection="Left" Width="100%" PageSize="20"
                                UrlPaging="True">
                            </webdiyer:AspNetPager>
                        </div>
                        <asp:HiddenField ID="hdfSql" runat="server" />
                    </div>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
