﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="WorkReportList.aspx.cs" Inherits="OAWeb.WorkReport.WorkReportList" EnableViewState="true" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption">
                        工作报告-<asp:Label ID="lblTitle" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        类型：<asp:DropDownList ID="ddlType" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlType_SelectedIndexChanged">
                            <asp:ListItem Value="1">日报</asp:ListItem>
                            <asp:ListItem Value="2">周报</asp:ListItem>
                            <asp:ListItem Value="3">月报</asp:ListItem>
                        </asp:DropDownList>
                        &nbsp;&nbsp;&nbsp;&nbsp; 状态：<asp:DropDownList ID="ddlState" runat="server" AutoPostBack="True"
                            OnSelectedIndexChanged="ddlState_SelectedIndexChanged">
                            <asp:ListItem Value="1">全部</asp:ListItem>
                            <asp:ListItem Value="4">待审核</asp:ListItem>
                        </asp:DropDownList>
                        <a href="WorkReportList.aspx?ReportType=4" style="color: Blue; text-decoration: none;">
                            待审核(<asp:Label ID="lblUnRead" runat="server" Text=""></asp:Label>)</a> &nbsp;&nbsp;&nbsp;&nbsp;
                        <div runat="server" id="search" style="display: inline">
                            <asp:DropDownList ID="ddlDepartment" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlDepartment_SelectedIndexChanged">
                            </asp:DropDownList>
                            <asp:DropDownList ID="ddlUserName" runat="server">
                            </asp:DropDownList>
                            <asp:DropDownList ID="ddlYear" runat="server">
                            </asp:DropDownList>
                            <asp:DropDownList ID="ddlMooth" runat="server">
                            </asp:DropDownList>
                            <asp:Button ID="btnSearch" runat="server" Text="查询" OnClick="btnSearch_Click" />
                        </div>
                    </td>
                </tr>
            </table>
            <div class="page_op">
                <input type="button" value="新增报告" onclick="window.location.href='WorkReportEdit.aspx'"
                    class="btn_77px" />
            </div>
            <div class="list">
                <asp:GridView ID="gvReport" runat="server" AutoGenerateColumns="False" DataKeyNames="ReportID"
                    Width="100%" OnRowDataBound="gvReport_RowDataBound" HorizontalAlign="Center"
                    CellSpacing="0" CellPadding="0" CssClass="table_list" GridLines="None">
                    <Columns>
                        <asp:BoundField DataField="ReportID" HeaderText="报告编号" SortExpression="ReportID"
                            Visible="false" />
                        <asp:TemplateField HeaderText="日期">
                            <ItemTemplate>
                                <%# Convert.ToDateTime( Eval("ReportDate")).ToShortDateString()%>(<%# GetWeekOfCN(Convert.ToDateTime(Eval("ReportDate")).DayOfWeek.ToString())%>)
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="ReportType" HeaderText="类型" SortExpression="ReportType">
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="RealName" HeaderText="报告人">
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="附件">
                            <ItemTemplate>
                                <asp:Label ID="lblAttach" runat="server" Text="有/无"></asp:Label>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="Comments" HeaderText="评论数" NullDisplayText="0">
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="最后评论">
                            <ItemTemplate>
                                <asp:Label ID="lblComment" runat="server" Text='<%# Bind("Comment") %>'></asp:Label>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="审阅状态">
                            <ItemTemplate>
                                <asp:Label ID="lblAudit" runat="server" Text='<% #DataBinder.Eval(Container.DataItem,"AuditState").ToString() == "0" ? "未审阅" : "已审阅" %>'></asp:Label>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <asp:HyperLink ID="hlnkView" runat="server">查看</asp:HyperLink>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                    </Columns>
                    <PagerSettings FirstPageText="首页" LastPageText="末页" Mode="NumericFirstLast" NextPageText="下一页"
                        PreviousPageText="上一页" />
                    <PagerStyle HorizontalAlign="Right" />
                </asp:GridView>
                <table id="ctl00_ContentPlaceHolder1_gvReport" border="0" cellpadding="0" cellspacing="0"
                    class="table_list">
                    <tr align="middle" style="background-color: #f0f0f0; height: 22px; font-size: 13px"
                        runat="server" id="Contain">
                        <th scope="col">
                            日期
                        </th>
                        <th scope="col">
                            类型
                        </th>
                        <th scope="col">
                            报告人
                        </th>
                        <th scope="col">
                            提交时间
                        </th>
                        <th scope="col">
                            附件
                        </th>
                        <th scope="col">
                            评论数
                        </th>
                        <th scope="col">
                            状态
                        </th>
                        <th scope="col">
                            最后评论
                        </th>
                        <th scope="col">
                            审阅状态
                        </th>
                        <th scope="col" width="15%">
                            操作
                        </th>
                    </tr>
                    <%foreach (OACore.Model.ReportModel modelReport in list)
                      { %>
                    <%if (ReportType == 1)
                      { %>
                    <tr>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.ReportDate.ToShortDateString()%>(<%=GetWeekOfCN(modelReport.ReportDate.DayOfWeek.ToString())%>)&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.ReportType%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.RealName%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CreateTime.ToString().Contains("0001") ? "---" : modelReport.CreateTime.ToString()%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CountAttach%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.Comments%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CreateTime.ToString().Contains("0001") ? "---" : "<b>√</b>"%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%= getStr1(modelReport.Comment, 10)%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.AuditState==0?"未审阅":"已审阅"%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <a href='<%=!modelReport.CreateTime.ToString().Contains("0001") ?GetViewUrl(modelReport.ReportID.ToString()):"#"%>'
                                style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001") ?"#000000":"#E1E1E1"%>'>
                                    查看</font></a>&nbsp;&nbsp; <a href='<%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0&&modelReport.ReportDate>=DateTime.Now.AddDays(-1).Date ?GetEditUrl(modelReport.ReportID.ToString()):"#"%>'
                                        style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0&&modelReport.ReportDate>=DateTime.Now.AddDays(-1).Date  ?"#000000":"#E1E1E1"%>'>
                                            编辑</font></a>&nbsp;&nbsp; <a href='<%=!modelReport.CreateTime.ToString().Contains("0001") ?GetDeleteUrl(modelReport.ReportID.ToString()):"#"%>'
                                                style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0 ?"#000000":"#E1E1E1"%>'
                                                    onclick='<%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0 ?"return confirm(\"确定要删除吗?\")":"return false;"%>'>
                                                    删除</font></a>
                        </td>
                    </tr>
                    <%}
                      else if (ReportType == 2)
                      { %>
                    <tr>
                        <td align="center" bgcolor="#FFFFFF">
                            第<%=GetWeekOffset(modelReport.ReportDate.ToShortDateString())%>周<br />
                            (<%=modelReport.ReportDate.AddDays(-6).ToShortDateString()%>~<%=modelReport.ReportDate.ToShortDateString()%>)&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.ReportType%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.RealName%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CreateTime.ToString().Contains("0001") ? "---" : modelReport.CreateTime.ToString()%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CountAttach%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.Comments%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CreateTime.ToString().Contains("0001") ? "---" : "<b>√</b>"%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%= getStr1(modelReport.Comment, 10)%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.AuditState==0?"未审阅":"已审阅"%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <a href='<%=!modelReport.CreateTime.ToString().Contains("0001")?GetViewUrl(modelReport.ReportID.ToString()):"#"%>'
                                style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001") ?"#000000":"#E1E1E1"%>'>
                                    查看</font></a>&nbsp;&nbsp; <a href='<%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0&&modelReport.ReportDate>=DateTime.Now.AddDays(Convert.ToInt32 (1 - Convert.ToInt32(DateTime.Now.DayOfWeek)) - 7).Date  ?GetEditUrl(modelReport.ReportID.ToString()):"#"%>'
                                        style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0&&modelReport.ReportDate>=DateTime.Now.AddDays(Convert.ToInt32 (1 - Convert.ToInt32(DateTime.Now.DayOfWeek)) - 7).Date  ?"#000000":"#E1E1E1"%>'>
                                            编辑</font></a>&nbsp;&nbsp; <a href='<%=!modelReport.CreateTime.ToString().Contains("0001") ?GetDeleteUrl(modelReport.ReportID.ToString()):"#"%>'
                                                style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001") && modelReport.AuditState==0 ?"#000000":"#E1E1E1"%>'
                                                    onclick='<%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0 ?"return confirm(\"确定要删除吗?\")":"return false;"%>'>
                                                    删除</font></a>
                        </td>
                        </td>
                    </tr>
                    <%}
                      else if (ReportType == 3)
                      {%>
                    <tr>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.ReportDate.Year%>年<%=modelReport.ReportDate.Month%>月
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.ReportType%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.RealName%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CreateTime.ToString().Contains("0001") ? "---" : modelReport.CreateTime.ToString()%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CountAttach%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.Comments%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.CreateTime.ToString().Contains("0001") ? "---" : "<b>√</b>"%>
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%= getStr1(modelReport.Comment, 10)%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <%=modelReport.AuditState==0?"未审阅":"已审阅"%>&nbsp;
                        </td>
                        <td align="center" bgcolor="#FFFFFF">
                            <a href='<%=!modelReport.CreateTime.ToString().Contains("0001") ?GetViewUrl(modelReport.ReportID.ToString()):"#"%>'
                                style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001")?"#000000":"#E1E1E1"%>'>
                                    查看</font></a>&nbsp;&nbsp; <a href='<%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0 &&modelReport.ReportDate>=DateTime.Parse(DateTime.Now.ToString("yyyy-MM-01")).AddMonths(-1)?GetEditUrl(modelReport.ReportID.ToString()):"#"%>'
                                        style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0&&modelReport.ReportDate>=DateTime.Parse(DateTime.Now.ToString("yyyy-MM-01")).AddMonths(-1)  ?"#000000":"#E1E1E1"%>'>
                                            编辑</font></a>&nbsp;&nbsp; <a href='<%=!modelReport.CreateTime.ToString().Contains("0001") ?GetDeleteUrl(modelReport.ReportID.ToString()):"#"%>'
                                                style="text-decoration: none;"><font style='color: <%=!modelReport.CreateTime.ToString().Contains("0001") && modelReport.AuditState==0 ?"#000000":"#E1E1E1"%>'
                                                    onclick='<%=!modelReport.CreateTime.ToString().Contains("0001")&& modelReport.AuditState==0 ?"return confirm(\"确定要删除吗?\")":"return false;"%>'>
                                                    删除</font></a>
                        </td>
                        </td>
                    </tr>
                    <%} %>
                    <%} %>
                </table>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="plReport" runat="server" AlwaysShow="True" Direction="LeftToRight"
                        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                        PageSize="30" PrevPageText="[上一页]" ShowCustomInfoSection="Left" OnPageChanged="plReport_PageChanged"
                        UrlPaging="True">
                    </webdiyer:AspNetPager>
                    <webdiyer:AspNetPager ID="AspNetPager1" runat="server" AlwaysShow="True" Direction="LeftToRight"
                        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                        PageSize="52" PrevPageText="[上一页]" ShowCustomInfoSection="Left" UrlPaging="True">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
    </div> </div> </div>
</asp:Content>
