﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="SnList.ascx.cs" Inherits="OAWeb.UserControls.SnList" EnableViewState="true" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>

<asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="SNId"
    GridLines="None" CellPadding="0" CssClass="table_list" 
    OnRowDataBound="gvData_RowDataBound" onrowcommand="gvData_RowCommand">
    <RowStyle HorizontalAlign="Left" />
    <Columns>
        
        <asp:TemplateField HeaderText="序列号">
            <ItemTemplate>
                <asp:LinkButton ID="lbtnProductSN" runat="server"><%# Eval("ProductSN") %></asp:LinkButton>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:BoundField DataField="SKUName" HeaderText="品名"></asp:BoundField>
        <asp:BoundField HeaderText="仓库"></asp:BoundField>
        <asp:BoundField DataField="AgentUserName" HeaderText="经销商"></asp:BoundField>
        <asp:BoundField DataField="CustomerCompanyName" HeaderText="客户名称" Visible="false"></asp:BoundField>
        
        <asp:BoundField DataField="CreateDate" HeaderText="创建日期"  DataFormatString="{0:yyyy-MM-dd}"></asp:BoundField>
        <asp:BoundField DataField="AuditDate" HeaderText="交付日期"  DataFormatString="{0:yyyy-MM-dd}"></asp:BoundField>
        <asp:BoundField DataField="AvailDate" HeaderText="服务期限"></asp:BoundField>
        <asp:BoundField DataField="UseStateText" HeaderText="状态"></asp:BoundField>
        <asp:TemplateField HeaderText="操作">
            <ItemTemplate>
                <asp:HyperLink ID="hypPay" runat="server">订购</asp:HyperLink>
                
                <asp:LinkButton ID="lbtnEdit" runat="server"  Visible="false">编辑</asp:LinkButton>
                <asp:LinkButton ID="lbtnDelete" runat="server" CommandName="del" CommandArgument='<%# Eval("SNId") %>' Visible="false">删除</asp:LinkButton>
            </ItemTemplate>
        </asp:TemplateField>
    </Columns>
</asp:GridView>
<div class="pager-bar">
    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
        PageSize="10" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
        ShowBoxThreshold="10" SubmitButtonText="跳 转" OnPageChanged="pager_PageChanged"  >
    </webdiyer:AspNetPager>
</div>
