﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="OrderList.ascx.cs" Inherits="OAWeb.UserControls.OrderList"
    EnableViewState="true" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:GridView ID="gvOrder" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
    GridLines="None" CellPadding="0" CssClass="table_list" OnRowDataBound="gvOrder_RowDataBound"
    OnRowCommand="gvOrder_RowCommand">
    <RowStyle HorizontalAlign="Left" />
    <Columns>
        <asp:TemplateField HeaderText="订单号">
            <ItemTemplate>
                <asp:HyperLink ID="hypView" runat="server" Text='<%# Eval("OrderSN") %>'></asp:HyperLink>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:BoundField DataField="OrderDate" HeaderText="下单时间" DataFormatString="{0:yyyy-MM-dd}">
        </asp:BoundField>
        <asp:BoundField DataField="CustomerName" HeaderText="客户名称" Visible="false"></asp:BoundField>
        <asp:BoundField DataField="OrderTotal" HeaderText="订单金额" DataFormatString="￥{0:f2}">
        </asp:BoundField>
        <asp:BoundField HeaderText="交易状态" />
        <asp:BoundField DataField="TrackUserName" HeaderText="业务员"></asp:BoundField>
        <asp:TemplateField HeaderText="操作">
            <ItemTemplate>
                <asp:HyperLink ID="hypEdit" runat="server" Text='编辑'></asp:HyperLink>
                <asp:LinkButton ID="lbtnDelete" runat="server" CommandName="del" CommandArgument='<%# Eval("Id") %>'>删除</asp:LinkButton>
            </ItemTemplate>
        </asp:TemplateField>
    </Columns>
</asp:GridView>
<div class="pager-bar">
    <webdiyer:AspNetPager ID="pager" runat="server"  OnPageChanged="pager_PageChanged"  CssClass="anpager" currentpagebuttonclass="cpb"
        PageSize="10" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
        ShowBoxThreshold="10" SubmitButtonText="跳 转">
    </webdiyer:AspNetPager>
</div>
