﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/User/Main.Master"
    EnableViewState="true" CodeBehind="ProductAdd.aspx.cs" Inherits="OAWeb.User.ProductAdd" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/UserLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <div class="w main">
        <div class="right">
            <table class="data_title" cellspacing="3" style=" border:none">
                <tr>
                    <td class="data_caption" style="vertical-align: middle;">
                        订购商品
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        商品名称：
                        <asp:TextBox ID="txtKeyword" runat="server" CssClass="text_box"></asp:TextBox><asp:Button
                            ID="btnSearch" runat="server" Text="查  询" class="btn_77px" 
                            onclick="btnSearch_Click" />
                    </td>
                </tr>
            </table>
            <div class="optiongroup mainwidth">
                <ul>
                    <li class="menucurrent"><a href="javascript:void(0);"><span>1.选择商品</span></a></li>
                    <li><a href="OrderAdd.aspx"><span>2.提交订单</span></a></li>
                    <li class="optionend"><a href="Pay.aspx"><span>3.在线付款</span></a></li>
                </ul>
            </div>
            <div class="dataarea mainwidth">
                <div class="list">
                    <asp:GridView ID="rptData" runat="server" AutoGenerateColumns="False" DataKeyNames="SkuId"
                        GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                        OnRowDataBound="rptData_RowDataBound" OnRowCommand="rptData_RowCommand">
                        <RowStyle HorizontalAlign="Left" />
                        <HeaderStyle HorizontalAlign="Center" />
                        <Columns>
                            <asp:TemplateField HeaderText="商品货号">
                                <ItemTemplate>
                                    <asp:Label ID="lblSkuId" runat="server" Text='<%# Eval("SkuId") %>' Visible="false"></asp:Label>
                                    <%# Eval("SKUCode")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="商品">
                                <ItemTemplate>
                                    <%#Eval("SKUName")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="SalePrice" HeaderText="订购价"></asp:BoundField>
                            <asp:BoundField DataField="Stock" HeaderText="库存"></asp:BoundField>
                            <asp:TemplateField HeaderText="订购数">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtNum" runat="server" Width="30" Text="1"></asp:TextBox>
                                    <%#Eval("Unit")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="操作">
                                <ItemTemplate>
                                    <asp:LinkButton ID="lbtnAdd" CommandName="Add" CommandArgument='<%# Eval("SkuId") %>'
                                        runat="server">添加</asp:LinkButton>
                                    <asp:LinkButton ID="lbtnDel" ForeColor="Red" CommandName="Del" CommandArgument='<%# Eval("SkuId") %>'
                                        runat="server" Visible="false">取消</asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                    <div class="pager-bar">
                        <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                            PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                            ShowBoxThreshold="10" SubmitButtonText="跳 转" OnPageChanged="pager_PageChanged">
                        </webdiyer:AspNetPager>
                    </div>
                </div>
                <div style="text-align: center; margin-top: 10px">
                    <asp:Button ID="Button1" runat="server" Text="确认" CssClass="btn_77px" OnClick="Button1_Click" />
                </div>
            </div>
        </div>
        <div class="left">
            <uc1:TaskNav ID="TaskNav1" runat="server" />
        </div>
    </div>
</asp:Content>
