﻿<%@ Page Language="C#" MasterPageFile="~/User/Main.Master" EnableViewState="true"
    Theme="Default" AutoEventWireup="true" CodeBehind="CustomerServiceList.aspx.cs"
    Inherits="OAWeb.User.CustomerServiceList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/UserLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <div class="w main">
        <div class="right">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption">
                        咨询留言
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        <asp:Button ID="btnAdd" runat="server" Text="新建" CssClass="btn_77px" />
                    </td>
                </tr>
            </table>
            <asp:GridView ID="gvOpportunity" runat="server" AutoGenerateColumns="False" DataKeyNames="IssueId"
                OnRowDataBound="gvOpportunity_RowDataBound" OnRowCommand="gvOpportunity_RowCommand"
                PageSize="20">
                <HeaderStyle Wrap="False" />
                <Columns>
                    <asp:TemplateField Visible="false">
                        <HeaderTemplate>
                            <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                        </HeaderTemplate>
                        <ItemTemplate>
                            <input runat="server" id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("IssueId")%>' />
                        </ItemTemplate>
                        <ItemStyle Width="20px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="标题">
                        <ItemTemplate>
                            <a href="" id="LinkView" runat="server">
                                <%# Eval("title") %></a>
                        </ItemTemplate>
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="创建时间">
                        <ItemTemplate>
                            <%# ObjToStr(Eval("CreateDate")).Contains("0001") ? "" : Eval("CreateDate")%>
                        </ItemTemplate>
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="内容">
                        <ItemTemplate>
                            <%# getStr1(ObjToStr(Eval("Description")), 20)%>
                        </ItemTemplate>
                    </asp:TemplateField>
                  
                    <asp:TemplateField HeaderText="操作">
                        <ItemTemplate>
                            <a id="LinkEdit" runat="server" href="javascript:void(0)">编辑</a>
                            <a id="LinkComment" runat="server" href="javascript:void(0)">查看回复</a>
                            <asp:LinkButton ID="lnkbtnDelete" runat="server" OnClientClick="return confirm('确定要删除?')"
                                CommandName="Del" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"IssueID").ToString()%>'>删除</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <div class="pager-bar">
                <webdiyer:AspNetPager ID="plOpportunity" runat="server" AlwaysShow="True" Direction="LeftToRight"
                    FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                    OnPageChanged="plOpportunity_PageChanged" PrevPageText="[上一页]" ShowCustomInfoSection="Left"
                    Width="100%" PageSize="20">
                </webdiyer:AspNetPager>
            </div>
        </div>
        <div class="left">
            <uc1:TaskNav ID="TaskNav1" runat="server" />
        </div>
    </div>
</asp:Content>
