﻿<%@ Page Language="C#" AutoEventWireup="true" Theme="Default" EnableViewState="true"
    MasterPageFile="~/Main.Master" CodeBehind="ShopList.aspx.cs" Inherits="OAWeb.Shop.ShopList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <div style="padding: 0 10px 10px 10px;">
        <table class="data_title" style="margin-top: 10px;">
            <tr>
                <td class="data_caption">
                    网店管理
                </td>
            </tr>
            <tr>
                <td class="data-field">
                    <asp:Button ID="btnAdd" runat="server" Text="新增" CssClass="btn_77px" />
                </td>
            </tr>
        </table>
        <div class="list">
            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames=""
                GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                OnRowDataBound="gvData_RowDataBound" OnRowCommand="gvData_RowCommand">
                <RowStyle HorizontalAlign="Left" />
                <Columns>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            淘宝
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="ShopName" HeaderText="店铺名称"></asp:BoundField>
                    <asp:BoundField DataField="ShopCode" HeaderText="店铺编码"></asp:BoundField>
                    <asp:BoundField DataField="NickName" HeaderText="卖家昵称"></asp:BoundField>
                    <asp:TemplateField HeaderText="操作">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbtnEdit" CommandName="Edit" CommandArgument='<%# Eval("Id") %>'
                                runat="server">编辑</asp:LinkButton>
                            <asp:HyperLink ID="hypSessiongKey" runat="server">授权</asp:HyperLink>
                            <asp:LinkButton ID="lbtnDel" OnClientClick="return confirm('确定要删除？')" CommandName="Del"
                                CommandArgument='<%# Eval("Id") %>' runat="server">删除</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <div class="pager-bar">
                <webdiyer:AspNetPager ID="plCustomer" runat="server" OnPageChanged="plCustomer_PageChanged"
                    PageSize="10">
                </webdiyer:AspNetPager>
            </div>
        </div>
    </div>
</asp:Content>
