﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="RoleList.aspx.cs" Inherits="OAWeb.Role.RoleList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体-->
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption">
                        角色管理
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        角色名称：<asp:TextBox ID="txtRoleName" runat="server" CssClass="text_box"></asp:TextBox>
                        <asp:Button ID="btnSearch" runat="server" Text="搜 索" CssClass="btn_77px" />
                    </td>
                </tr>
            </table>
            <div class="page_op">
                <asp:Button ID="btnNewRole" runat="server" Text="新增角色" CssClass="btn_77px" OnClientClick="return OpenDialog('/Role/RoleEdit.aspx','新增角色');" /><asp:Button
                    ID="BtnAudit" runat="server" Text="启用角色" CssClass="btn_77px" />
                <asp:Button ID="btnFreeze" runat="server" Text="禁用角色" CssClass="btn_77px" />
            </div>
            <div class="list">
                <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    GridLines="None" OnRowDataBound="gvData_RowDataBound" CellPadding="0" CssClass="table_list"
                    EnableModelValidation="True">
                    <RowStyle HorizontalAlign="Left" />
                    <Columns>
                        <asp:TemplateField HeaderText="编号">
                            <HeaderTemplate>
                                <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <input id="chkItem" type="checkbox" value="<%#Eval("Id") %>" />
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="30px"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField DataField="Code" HeaderText="编号"></asp:BoundField>
                        <asp:BoundField DataField="RoleName" HeaderText="角色名称" />
                        <asp:TemplateField HeaderText="启用状态">
                            <ItemTemplate>
                                <img class='<%#Eval("Enabled").ToString().Equals("1") ? "ico01" : "ico02"%>' src="/images/transparent.gif" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="Remark" HeaderText="描述" />
                        <asp:BoundField DataField="SortCode" HeaderText="排序号" />
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbtnEdit" runat="server">编辑</asp:LinkButton>
                                <asp:LinkButton ID="lbtnPermission" runat="server">权限</asp:LinkButton>
                                <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                            </ItemTemplate>
                            <ItemStyle Width="200px" />
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                        PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                        ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
