﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="DepartmentList.aspx.cs" Inherits="OAWeb.Department.DepartmentList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体-->
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption">
                        部门管理
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        部门名称:<asp:TextBox ID="txtFullName" runat="server" CssClass="text_box"></asp:TextBox>
                        <asp:DropDownList ID="ddlDepartment" runat="server">
                        </asp:DropDownList>
                        <asp:Button ID="btnSearch" runat="server" Text="搜 索" CssClass="btn_77px" />
                    </td>
                </tr>
            </table>
            <div class="page_op">
                <asp:Button ID="btnNewDepartment" runat="server" Text="新增部门" CssClass="btn_77px"
                    OnClientClick="return OpenDialog('/Department/DepartmentEdit.aspx','新增部门');" />
            </div>
            <div class="list">
                <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    GridLines="None" OnRowDataBound="gvData_RowDataBound" CellPadding="0" CssClass="table_list"
                    EnableModelValidation="True">
                    <RowStyle HorizontalAlign="Left" />
                    <Columns>
                        <asp:TemplateField HeaderText="编号">
                            <HeaderTemplate>
                                <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <span id='<%#Eval("Id") %>'>
                                    <asp:CheckBox ID="chkItem" runat="server"></asp:CheckBox>
                                </span>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="10px"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField DataField="FullName" HeaderText="部门名称"></asp:BoundField>
                        <asp:BoundField DataField="EmployId" HeaderText="部门主管"></asp:BoundField>
                        <asp:BoundField DataField="Remark" HeaderText="备注"></asp:BoundField>
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbtnEdit" runat="server">编辑</asp:LinkButton>
                                <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                        PageSize="100" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                        ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
