﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Dialog/DialogMaster.Master" AutoEventWireup="true"
    CodeBehind="DepartmentEdit.aspx.cs" Inherits="OAWeb.Department.DepartmentEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="form" style="width: 600px; padding: 10px;">
        <table cellpadding="0" cellspacing="0" border="0" class="table_form">
            <tr>
                <td class="right">
                    上级部门：
                </td>
                <td>
                    <asp:DropDownList ID="ddlParentId" runat="server">
                        <asp:ListItem Value="0">选择部门</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td class="right">
                    部门名称：
                </td>
                <td>
                    <asp:TextBox ID="txtFullName" runat="server" CssClass="text"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="right">
                    部门简称：
                </td>
                <td>
                    <asp:TextBox ID="txtShortName" runat="server" CssClass="text"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="right">
                    部门主管：
                </td>
                <td>
                    <asp:TextBox ID="txtEmployName" runat="server" CssClass="text"></asp:TextBox>&nbsp;
                    <input id="btnSelect" type="button" value="选择" onclick="OpenRadioDialog('/Dialog/EmploySelectDialog.aspx?user=0','选择主管',CallbackRadioFun);" />
                    <input id="btnClear" type="button" value="置空" onclick=" Reset(false);" />
                    <asp:HiddenField ID="hdfEmployIdValue" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="right">
                    部门副主管：
                </td>
                <td>
                    <asp:TextBox ID="txtAssistantEmployName" runat="server" CssClass="text"></asp:TextBox>&nbsp;
                    <input id="btnSelect2" type="button" value="选择" onclick="OpenCheckedDialog('/Dialog/EmploySelectDialog.aspx?user=0&type=1','选择副主管',CallbackCheckedFun);" />
                    <input id="btnClear2" type="button" value="置空" onclick="return Reset(true);" />
                    <asp:HiddenField ID="hdfAssistantEmployIdValue" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="right">
                    外线电话：
                </td>
                <td class="data-field">
                    <asp:TextBox ID="txtOuterPhone" runat="server" CssClass="text"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="right">
                    内线电话：
                </td>
                <td class="data-field">
                    <asp:TextBox ID="txtInnerPhone" runat="server" CssClass="text"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="right">
                    备注:
                </td>
                <td>
                    <asp:TextBox ID="txtRemark" runat="server" CssClass="text" Width="99%" Height="75px"
                        TextMode="MultiLine"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    <input id="btnSave" type="button" value=" 保 存 " class="btn_77px" />
                    <input id="btnClose" type="button" value=" 返 回 " onclick="art.dialog.close();return false;"
                        class="btn_77px" />
                </td>
            </tr>
        </table>
    </div>
    <script type="text/javascript">        
        $(document).ready(function () {
            jQuery.validator.addMethod("FullNameIsExist", function (value, element) {
                return AjaxChecked("DepartmentEdit.aspx", "op=FullNameIsExist&name=" + value + "&Id=<%=Id %>&r=" + Math.random());
            }, "您输入的部门已经存在");
            rulesValue = {'<%=txtFullName.UniqueID %>': {required: true,FullNameIsExist: true}};
            messagesValue = {'<%=txtFullName.UniqueID %>': {required: "请输入部门名称"}}
            var form = jQuery.validator.ValidateForm($("#aspnetForm"), rulesValue, messagesValue);
            $("#btnSave").click(function () {
                if (form.form()) {
                    $("#aspnetForm").ajaxSubmit({
                        url: "/Department/DepartmentEdit.aspx?op=Save&Id=<%=Id %>",
                        success: function (result) {
                            if (result == "ok") {
                                alert("保存成功");
                                CloseReload();
                            } else {
                                alert(result);
                            } 
                        }
                    });
                }
                return false;
            })
        });
        function CallbackRadioFun(text, value) {
            $('#<%=txtEmployName.ClientID %>').val(text);
            $('#<%=hdfEmployIdValue.ClientID %>').val(value);
        }
        function CallbackCheckedFun(text, value) {
            if (value != null && value != "") {
                var val = $('#<%=hdfAssistantEmployIdValue.ClientID %>').val();
                if (val == "") {
                    $('#<%=txtAssistantEmployName.ClientID %>').val(text.join(","));
                    $('#<%=hdfAssistantEmployIdValue.ClientID %>').val(value.join(","));
                    return;
                }
                var vals = val.split(',');
                var txts = $('#<%=txtAssistantEmployName.ClientID %>').val().split(',');
                for (var i = 0; i < value.length; i++) {
                    if ($.inArray(value[i], vals) > -1) continue;
                    vals.push(value[i]);
                    txts.push(text[i]);
                }
                $('#<%=txtAssistantEmployName.ClientID %>').val(txts.join(","));
                $('#<%=hdfAssistantEmployIdValue.ClientID %>').val(vals.join(","));
            }
        }
        function Reset(Assistant) {
            if (Assistant) {
                $('#<%=txtAssistantEmployName.ClientID %>').val("");
                $('#<%=hdfAssistantEmployIdValue.ClientID %>').val("");
            }
            else {
                $('#<%=txtEmployName.ClientID %>').val("");
                $('#<%=hdfEmployIdValue.ClientID %>').val("");
            }
            return false;
        }
    </script>
</asp:Content>
