﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Main.Master" Theme="Default"
    CodeBehind="ResumeList.aspx.cs" Inherits="OAWeb.hrm.employ.ResumeList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        function OpenEditDialog(id) {
            if (id == "" || id == undefined)
                OpenDialog("/hrm/Employ/ResumeEdit.aspx", "新增简历");
            else
                OpenDialog("/hrm/Employ/ResumeEdit.aspx?EmployID=" + id, "编辑简历");
            return false;
        }

        function OpenRecordList(id) {
            OpenDialog("/hrm/Employ/InterviewRecordList.aspx?EmployID=" + id, "查看记录");
            return false;
        }

        function MoveResume() {
            var strId = getCheckedValueList();
            if (strId == "") {
                alert("请选择要移动的简历");
                return false;
            }

            OpenDialog("/hrm/Employ/ResumeMove.aspx?strId=" + strId, "移动简历");

            return false;
        }

        function ResumeDutieUpdate() {
            var strId = getCheckedValueList();
            if (strId == "") {
                alert("请选择要关联的简历");
                return false;
            }

            OpenDialog("/hrm/Employ/ResumeDutieUpdate.aspx?strId=" + strId, "职位关联");

            return false;
        }

        function AddRecord() {
            var strId = getCheckedValueList();
            if (strId == "") {
                alert("请选择简历");
                return false;
            }
//            if (strId.indexOf(",") >= 0) {
//                alert("一次只能选一份");
//                return false;
//            }

            OpenDialog("/hrm/Employ/InterviewRecordAdd.aspx?EmployID=" + strId, "安排面试");

            return false;
        }

        function AddEmployFile() {
            var strId = getCheckedValueList();
            if (strId == "") {
                alert("请选择简历");
                return false;
            }
            if (strId.indexOf(",") >= 0) {
                alert("一次只能选一份");
                return false;
            }

            OpenDialog("/hrm/Employ/EmployFileEdit.aspx?EmployID=" + strId, "入职");

            return false;
        }

        function Open_OKModal_Window(EmployID, EmployType) {
            OpenWindow('EmployStateOK.aspx?EmployID=' + EmployID + '&EmployType=' + EmployType, 565, 250);
        }

        function Open_ViewModal_Window(EmployID) {
            OpenDialog('/hrm/Employ/Employ_View.aspx?EmployID=' + EmployID, "查看职员人事档案");
        }
    </script>
    <style>
        .DivState a, .buttons-bar a
        {
            margin: 5px;
            margin-left: 10px;
            margin-right: 10px;
        }
        .data_field ul li
        {
            float: left;
            width: 220px;
        }
    </style>
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption" style="border-bottom: none;">
                        人才简历
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        <ul>
                            <li>职员姓名：<asp:TextBox ID="txtRealName" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>联系电话：<asp:TextBox ID="txtTelephone" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>手机：<asp:TextBox ID="txtMobile" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>通讯地址：<asp:TextBox ID="txtMailAddress" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>身 份 证：<asp:TextBox ID="txtIDcard" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>毕业学校：<asp:TextBox ID="txtSchool" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>Email：<asp:TextBox ID="txtEmail" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>户籍地址：<asp:TextBox ID="txtRegAddress" runat="server" CssClass="text_box">
                            </asp:TextBox><asp:Label ID="lblEmployState" runat="server" Text="招聘状态：" Visible="false"></asp:Label>
                            </li>
                            <li>性别：<asp:DropDownList ID="ddlSex" runat="server" Width="60px">
                                <asp:ListItem Value="0">-选择-</asp:ListItem>
                                <asp:ListItem>男</asp:ListItem>
                                <asp:ListItem>女</asp:ListItem>
                            </asp:DropDownList>
                            </li>
                            <li>学历：<asp:DropDownList ID="ddlDiplomaID" runat="server" Width="60px">
                            </asp:DropDownList>
                            </li>
                            <li>
                                &nbsp;<asp:DropDownList ID="ddlDutieID" runat="server">
                                </asp:DropDownList>
                            </li>
                            <li>
                                <asp:Button ID="btnSearch" CssClass="btn_77px" runat="server" Text="查  询" /></li>
                        </ul>
                    </td>
                </tr>
            </table>
            <div class="buttons-bar DivState" id="DivEmployState" runat="server" style="margin: 10px;">
            </div>
            <div class="page_op">
                <asp:Button ID="btnAdd" runat="server" Text="新增简历" CssClass="btn_77px" OnClientClick="return OpenEditDialog();" />
                <input id="btnClose" type="button" value="导入简历" onclick="window.location.href='iDesk://192.168.0.5';return false;"
                    class="btn_77px" />
                <asp:Button ID="Button1" runat="server" Text="面试安排" CssClass="btn_77px" OnClientClick="return AddRecord();" />
                <asp:Button ID="Button2" runat="server" Text="移动" CssClass="btn_77px" OnClientClick="return MoveResume();" />
                <asp:Button ID="Button3" runat="server" Text="入职" CssClass="btn_77px" OnClientClick="return AddEmployFile();" />
                <asp:Button ID="Button4" runat="server" Text="职位关联" CssClass="btn_77px" OnClientClick="return ResumeDutieUpdate();" />
                <asp:Button ID="Button5" runat="server" Text="批量删除" CssClass="btn_77px" />
            </div>
            <div class="list">
                <asp:GridView ID="gvEmployList" runat="server" AutoGenerateColumns="False" DataKeyNames="EmployID"
                    OnRowDataBound="gvEmployList_RowDataBound" Width="100%" PageSize="20" CellPadding="3"
                    CellSpacing="0" CssClass="table_list" GridLines="None">
                    <HeaderStyle CssClass="title" Wrap="False" />
                    <Columns>
                        <asp:TemplateField>
                            <HeaderTemplate>
                                <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <input id="chkItem" name="chkItem" type="checkbox" value="<%# Eval("EmployID") %>" />
                            </ItemTemplate>
                            <ItemStyle Width="20px" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="EmployID" HeaderText="#" Visible="false">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="真实姓名">
                            <ItemTemplate>
                                <asp:LinkButton ID="View" runat="server" CausesValidation="false" CommandName="lbtView"><%#DataBinder.Eval(Container.DataItem,"RealName").ToString()%></asp:LinkButton>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="Sex" HeaderText="性别">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="出生日期">
                            <ItemTemplate>
                                <asp:Label ID="lblBirthDate" runat="server"></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="DutieName" HeaderText="应聘职位">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="DiplomaName" HeaderText="学历">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="RecentEmployer" HeaderText="最近雇主">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="投递时间">
                            <ItemTemplate>
                                <asp:Label ID="lblDate" runat="server" Text='<%# Eval("CreateDate") %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="SourceChannel" HeaderText="来源">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="状态">
                            <ItemTemplate>
                                <asp:Label ID="lblEmployState" runat="server"></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="最近沟通">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbtnRecord" runat="server">查看历史</asp:LinkButton>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" Width="145px" />
                            <ItemTemplate>
                                <asp:LinkButton ID="Edit" runat="server" CausesValidation="false" CommandName="lbtEdit">编辑</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="plEmploy" runat="server" AlwaysShow="True" Direction="LeftToRight"
                        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                        PrevPageText="[上一页]" ShowCustomInfoSection="Left" Width="100%" PageSize="20"
                        UrlPaging="true">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
