﻿<%@ Page Language="C#" Theme="Default" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="HrmSiteList.aspx.cs" Inherits="OAWeb.hrm.employ.HrmSiteList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        function OpenEditDialog(id) {
            if (id == "" || id == undefined)
                OpenDialog("/hrm/employ/HrmSiteEdit.aspx", "新增渠道");
            else
                OpenDialog("/hrm/employ/HrmSiteEdit.aspx?Id=" + id, "编辑渠道");
            return false;
        }     	
    </script>
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption" style="border-bottom: none;">
                        招聘渠道
                    </td>
                </tr>
            </table>
            <div class="page_op">
                <asp:Button ID="btnAdd" runat="server" Text="新增招聘渠道" CssClass="btn_77px" />
            </div>
            <div class="list">
                <asp:GridView ID="gvDutieList" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    Width="100%" PageSize="20" OnRowDataBound="gvDutieList_RowDataBound" CellSpacing="0"
                    CellPadding="0" CssClass="table_list" GridLines="None">
                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                    <Columns>
                        <asp:BoundField DataField="SiteName" HeaderText="名称" ReadOnly="True" HtmlEncode="false">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="SiteUrl" HeaderText="网址" ReadOnly="True">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="UserName" HeaderText="账号" ReadOnly="True">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="状态">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:Label ID="lblState" runat="server" Text=""></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton ID="Edit" runat="server" CausesValidation="false" CommandName="lbtEdit"
                                    CommandArgument='<%#DataBinder.Eval(Container.DataItem,"ID").ToString()%>'>[编辑]</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="plDutie" runat="server" AlwaysShow="True" Direction="LeftToRight"
                        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                        UrlPaging="true" PageSize="10" PrevPageText="[上一页]" ShowCustomInfoSection="Left">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
