﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" Theme="Default" AutoEventWireup="true"
    CodeBehind="EmployFileList.aspx.cs" Inherits="OAWeb.hrm.employ.EmployFileList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        function OpenEditDialog(id) {
            if (id == "" || id == undefined)
                OpenDialog("/hrm/Employ/EmployFileEdit.aspx", "新增档案");
            else
                OpenDialog("/hrm/Employ/EmployFileEdit.aspx?ID=" + id, "编辑档案");
            return false;
        }

        function AddContract(id) {

            OpenDialog("/hrm/Employ/ContractEdit.aspx?ID=" + id, "添加合同");
            return false;
        }

        function Open_ViewModal_Window(EmployID) {
            OpenDialog('/hrm/Employ/EmployFileEdit.aspx?ID=' + EmployID, "编辑档案");
        }
    </script>
    <style>
        .DivState a, .buttons-bar a
        {
            margin: 5px;
            margin-left: 10px;
            margin-right: 10px;
        }
        .data_field ul li
        {
            float: left;
            width: 220px;
        }
    </style>
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption" style="border-bottom: none;">
                        <asp:Label ID="lblPageTitle" runat="server" Text="在职人员"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        <ul>
                            <li>职员姓名：<asp:TextBox ID="txtRealName" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>联系电话：<asp:TextBox ID="txtTelephone" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>手机：<asp:TextBox ID="txtMobile" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>通讯地址：<asp:TextBox ID="txtMailAddress" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>身份证：<asp:TextBox ID="txtIDcard" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>毕业学校：<asp:TextBox ID="txtSchool" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>Email：<asp:TextBox ID="txtEmail" runat="server" CssClass="text_box"></asp:TextBox></li>
                            <li>户籍地址：<asp:TextBox ID="txtRegAddress" runat="server" CssClass="text_box">
                            </asp:TextBox></li>
                            <li>性别：<asp:DropDownList ID="ddlSex" runat="server">
                                <asp:ListItem Value="0">-请选择-</asp:ListItem>
                                <asp:ListItem>男</asp:ListItem>
                                <asp:ListItem>女</asp:ListItem>
                            </asp:DropDownList>
                            </li>
                            <li>文凭学历：<asp:DropDownList ID="ddlDiplomaID" runat="server">
                            </asp:DropDownList>
                            </li>
                            <li>
                                <asp:DropDownList ID="ddlDeptID" runat="server" >
                                </asp:DropDownList>
                            </li>
                            <li>
                                <asp:Button ID="btnSearch" CssClass="btn_77px" runat="server" Text="查  询" /></li>
                        </ul>
                    </td>
                </tr>
            </table>
            <div class="buttons-bar DivState" id="DivEmployState" runat="server" style="margin-bottom: 10px;">
            </div>
            <div class="page_op">
                <asp:Button ID="btnAdd" runat="server" Text="新增档案" CssClass="btn_77px" OnClientClick="return OpenEditDialog();" />
                <asp:Button ID="btnDelete" runat="server" Text="批量删除" CssClass="btn_77px" />
                <asp:Button ID="BtnState" runat="server" Text="离职" CssClass="btn_77px" />
            </div>
            <div class="list">
                <asp:GridView ID="gvEmployList" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    OnRowDataBound="gvEmployList_RowDataBound" Width="100%" PageSize="20" CellSpacing="0"
                    CellPadding="0" CssClass="table_list" GridLines="None">
                    <Columns>
                        <asp:TemplateField>
                            <HeaderTemplate>
                                <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                            </HeaderTemplate>
                            <ItemTemplate>
                               <input id="chkItem" name="chkItem" type="checkbox" value="<%#Eval("Id") %>" <%#Eval("UserName").ToString().ToLower() == "administrator" ? "disabled='disabled'" : "" %> />
                               
                            </ItemTemplate>
                            <ItemStyle Width="20px" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="DeptName" HeaderText="部门">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="WorkNumber" HeaderText="工号">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="姓名">
                            <ItemTemplate><a href="javascript:void(0)" onclick="Open_ViewModal_Window('<%#Eval("Id") %>')">
                                <%# Eval("RealName") %></a>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="Sex" HeaderText="性别">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="出生日期">
                            <ItemTemplate>
                                <asp:Label ID="lblBirthDate" runat="server"></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                         <asp:TemplateField HeaderText="账号">
                            <ItemTemplate>
                                <asp:Label ID="lblUserName" runat="server" Text=""></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        
                        <asp:BoundField DataField="DutieName" HeaderText="职位">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="试用期限">
                            <ItemTemplate>
                                <asp:Label ID="lblProbationDate" runat="server" Text=""></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="合同期限">
                            <ItemTemplate>
                                <asp:Label ID="lblExpireDate" runat="server" Text=""></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                       
                        <asp:TemplateField HeaderText="状态">
                            <ItemTemplate>
                                <asp:Label ID="lblFileType" runat="server" Text=""></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" Width="145px" />
                            <ItemTemplate>
                                <asp:LinkButton ID="Edit" runat="server" CausesValidation="false" CommandName="lbtEdit">编辑</asp:LinkButton>
                                <asp:LinkButton ID="Change" runat="server" CausesValidation="false" CommandName="lbtChange">离职</asp:LinkButton>
                                <a href="javascript:void(0)" onclick='AddContract(<%# Eval("Id") %>)'>添加合同</a>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="plEmploy" runat="server" AlwaysShow="True" Direction="LeftToRight"
                        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                        UrlPaging="true" PrevPageText="[上一页]" ShowCustomInfoSection="Left" Width="100%"
                        PageSize="20">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
