﻿<%@ Page Language="C#" Theme="Default" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="DutieList.aspx.cs" Inherits="OAWeb.hrm.employ.DutieList" Title="职位管理" EnableViewState="true" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        function OpenEditDialog(id) {
            if (id == "" || id == undefined)
                OpenDialog("/hrm/employ/DutieEdit.aspx", "新增职位");
            else
                OpenDialog("/hrm/employ/DutieEdit.aspx?DutieID=" + id, "编辑职位");
            return false;
        }     	
    </script>
    <div class="page_main">
        <div class="page_content">
            <table class="data_title">
                <tr>
                    <td class="data_caption">
                        职位管理
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        职位名称
                        <asp:TextBox ID="txtSearchName" runat="server"></asp:TextBox>&nbsp;
                        <asp:Button ID="btnSearch" CssClass="btn_77px" runat="server" Text="搜 索" />&nbsp;&nbsp;
                    </td>
                </tr>
            </table>
            <div class="page_op">
                <asp:Button ID="btnAdd" runat="server" Text="新增职位" CssClass="btn_77px" />
            </div>
            <div class="list">
                <asp:GridView ID="gvDutieList" runat="server" AutoGenerateColumns="False" DataKeyNames="DutieID"
                    Width="100%" PageSize="20" OnRowDataBound="gvDutieList_RowDataBound" CellSpacing="0"
                    CellPadding="0" CssClass="table_list" GridLines="None" 
                    onrowcommand="gvDutieList_RowCommand">
                    <HeaderStyle Wrap="False"></HeaderStyle>
                    <Columns>
                        <asp:TemplateField>
                            <HeaderTemplate>
                                <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <input type="checkbox" name="cboId" value='<%# Eval("DutieID") %>' />
                            </ItemTemplate>
                            <ItemStyle Width="20px" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="DutieID" HeaderText="#" Visible="false">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="Name" HeaderText="职位名称" ReadOnly="True" HtmlEncode="false">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:BoundField DataField="DutieCode" HeaderText="职位代码" ReadOnly="True">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="部门">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:Label ID="lblDeptID" runat="server" Text=""></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="状态">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:Label ID="lblState" runat="server" Text=""></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="ModifyDate" HeaderText="更新时间" ReadOnly="True">
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle HorizontalAlign="Center" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="操作">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton ID="Edit" runat="server">[编辑]</asp:LinkButton>
                                <asp:LinkButton ID="Del" runat="server" CommandName="lbtDel" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"DutieID").ToString()%>'>[删除]</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="plDutie" runat="server" AlwaysShow="True" Direction="LeftToRight"
                        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                        UrlPaging="true" PageSize="20" PrevPageText="[上一页]" ShowCustomInfoSection="Left">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
