﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="SpecsList.aspx.cs" Inherits="OAWeb.crm.product.SpecsList" %>

<%@ Register Src="../../UserControls/ProductNav.ascx" TagName="ProductNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <style type="text/css">
        .list .table_list th, .list .table_list td
        {
            text-align: left;
        }
    </style>
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:ProductNav ID="ProductNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    <em style="float: left">
                                        <img src="/images/03.gif" />
                                    </em>
                                    '<asp:Literal ID="ltlPageTitle" runat="server"></asp:Literal>'的规格管理<br />
                                    <span class="tip01">商品类型是一系规格的组合</span>
                                </td>
                            </tr>
                        </table>
                        <div class="page_op">
                            <asp:Button ID="btnNew" runat="server" Text="新增规格" CssClass="btn_77px" /><input id="btnBackUrl"
                                type="button" value="返回规格" class="btn_77px" onclick="window.location.href='<%=Request["ref"] %>'" />
                        </div>
                        <div class="list">
                            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="SpecId"
                                GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                                OnRowDataBound="gvData_RowDataBound">
                                <RowStyle HorizontalAlign="Left" />
                                <Columns>
                                    <asp:TemplateField HeaderText="规格名称">
                                        <ItemTemplate>
                                            规格名[<%#Eval("UseAttributeImage").ToString() == "1" ? "图" :"文"%>]:<input name="txtSpecName"
                                                type="text" value='<%#Eval("SpecName") %>' class="text_box" style="width: 100px" />
                                            <a class="editSpec" href="javascript:void(0)" s_id="<%#Eval("SpecId") %>">修改</a>
                                        </ItemTemplate>
                                        <ItemStyle Width="250px" />
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="规格值">
                                        <ItemTemplate>
                                            <asp:Repeater ID="rptData" runat="server">
                                                <ItemTemplate>
                                                    <span class="span_pane"><span class="span1"><a href="javascript:void(0)">
                                                        <%#Eval("ValueStr")%></a></span> </span>
                                                </ItemTemplate>
                                            </asp:Repeater>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                            <asp:LinkButton ID="lbtnAddValue" runat="server">添加规格值</asp:LinkButton>
                                            <a href="SpecsValueList.aspx?SpecId=<%#Eval("SpecId") %>&ref=<%=Server.UrlEncode(Request.Url.PathAndQuery) %>">编辑</a>
                                            <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        $(document).ready(function () {
            $(".editSpec").click(function () {
                var txtSpecName = $(this).parent().find(".text_box").val();
                if (txtSpecName == "") {
                    alert("请输入规格名");
                    return;
                }
                $(this).attr("json", "id:'" + $(this).attr("s_id") + "',op:'EditSpecName',SName:'" + txtSpecName + "'");
                return opAjax(this, null);
            })
        });
    </script>
</asp:Content>
