﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="ProductList.aspx.cs" Inherits="OAWeb.crm.product.ProductList" %>

<%@ Register Src="../../UserControls/ProductNav.ascx" TagName="ProductNav" TagPrefix="uc1" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:ProductNav ID="ProductNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    <em style="float: left">
                                        <img src="/images/03.gif" />
                                    </em>商品管理<br />
                                    <span class="tip01">管理商品.您可以添加、编辑、删除商品</span>
                                </td>
                            </tr>
                        </table>
                        <div class="page_op">
                            <asp:Button ID="btnNew" runat="server" Text="新增商品" CssClass="btn_77px" OnClientClick="window.location.href='ProductEdit.aspx';return false;" />
                            <asp:Button ID="btnDelete" runat="server" Text="删除" CssClass="btn_77px" />
                            <asp:Button ID="btnUnActive" runat="server" Text="停售" CssClass="btn_77px" />
                            <asp:Button ID="btnActive" runat="server" Text="启用" CssClass="btn_77px" />
                            <asp:Button ID="btnTaoBao" runat="server" Text="下载商品" CssClass="btn_77px" />
                        </div>
                        <div class="list">
                            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                                GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                                OnRowDataBound="gvData_RowDataBound">
                                <RowStyle HorizontalAlign="Left" />
                                <Columns>
                                    <asp:TemplateField HeaderText="编号">
                                        <HeaderTemplate>
                                            <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                                        </HeaderTemplate>
                                        <ItemTemplate>
                                            <input id="chkItem" type="checkbox" value="<%#Eval("Id") %>" />
                                        </ItemTemplate>
                                        <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                                        <ItemStyle HorizontalAlign="Center" Width="10px"></ItemStyle>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="ProductCode" HeaderText="商品编码"></asp:BoundField>
                                    <asp:BoundField DataField="ProductName" HeaderText="商品名称"></asp:BoundField>
                                    <asp:BoundField DataField="SKUCount" HeaderText="品项数"></asp:BoundField>
                                    <asp:BoundField DataField="CategoryName" HeaderText="分类"></asp:BoundField>
                                    <asp:BoundField DataField="BrandName" HeaderText="品牌"></asp:BoundField>
                                    <asp:BoundField DataField="SalePrice" HeaderText="销售价"></asp:BoundField>
                                    <asp:BoundField DataField="Stock" HeaderText="库存"></asp:BoundField>
                                    <asp:TemplateField HeaderText="状态">
                                        <ItemTemplate>
                                            <img class='<%#Eval("Is_Active").ToString().Equals("1") ? "ico01" : "ico02"%>' src="/images/transparent.gif" />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="HasSN" HeaderText="序列号" Visible="False"></asp:BoundField>
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="hypView" runat="server" Visible="false">查看</asp:HyperLink>
                                            <asp:HyperLink ID="hypEdit" runat="server">编辑</asp:HyperLink>
                                            <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                            <div class="pager-bar">
                                <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                                    PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                                    ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                                </webdiyer:AspNetPager>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
