﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="PaymentList.aspx.cs" Inherits="OAWeb.crm.orders.PaymentList" %>

<%@ Register Src="../../UserControls/OrderNav.ascx" TagName="OrderNav" TagPrefix="uc1" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:OrderNav ID="OrderNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    <em style="float: left">
                                        <img src="/images/05.gif" />
                                    </em>销售款项<br />
                                    <span class="tip01">管理销售款项.您可以编辑、删除销售款项,只有确认的款项才算实际款项，在订单详细中创建销售款项。</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    <asp:HyperLink ID="hyplink1" runat="server">待收款(4)</asp:HyperLink>
                                    <asp:HyperLink ID="hyplink2" runat="server">已收款(20)</asp:HyperLink>
                                    <asp:HyperLink ID="hyplink3" runat="server">待收款(4)</asp:HyperLink>
                                    <asp:HyperLink ID="hyplink4" runat="server">已收款(20)</asp:HyperLink>
                                    <br />
                                    客户名称:
                                    <asp:TextBox ID="txtCustomerName" runat="server" CssClass="text_box" ReadOnly="True"></asp:TextBox>&nbsp;
                                    <input type="button" value="选择" onclick="OpenRadioDialog('/Dialog/CustomerDialog.aspx', '选择客户', CallbackFun);" />
                                    &nbsp;<input type="button" value="置空" onclick=" Reset();" />
                                    业务员:
                                    <asp:TextBox ID="txtTrackUserName" runat="server" CssClass="text_box width80"></asp:TextBox>&nbsp;
                                    类型:
                                    <asp:DropDownList ID="ddlPayType" runat="server">
                                        <asp:ListItem Value="">请选择</asp:ListItem>
                                        <asp:ListItem Value="0">在线支付</asp:ListItem>
                                        <asp:ListItem Value="1">线下支付</asp:ListItem>
                                        <asp:ListItem Value="2">预存款支付</asp:ListItem>
                                    </asp:DropDownList>
                                    时间：<asp:TextBox ID="txtPayDateStart" runat="server" CssClass="text_box width80" onclick="WdatePicker({dateFmt:'yyyy-MM-dd'})"></asp:TextBox>-<asp:TextBox
                                        ID="txtPayDateEnd" runat="server" CssClass="text_box width80" onclick="WdatePicker({dateFmt:'yyyy-MM-dd'})"></asp:TextBox>
                                    <asp:DropDownList ID="ddlOrderType" runat="server">
                                        <asp:ListItem Value="">订单类型</asp:ListItem>
                                        <asp:ListItem Value="0">新签单</asp:ListItem>
                                        <asp:ListItem Value="1">续费</asp:ListItem>
                                    </asp:DropDownList>
                                    
                                    <asp:HiddenField ID="hdfCustomerId" runat="server" />
                                    <asp:Button ID="btnSearch" runat="server" Text="查  询" class="btn_77px" />
                                </td>
                            </tr>
                        </table>
                        <div class="list">
                            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                                GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                                OnRowDataBound="gvData_RowDataBound">
                                <RowStyle HorizontalAlign="Left" />
                                <Columns>
                                    <asp:TemplateField HeaderText="发生时间">
                                        <ItemTemplate>
                                            <asp:LinkButton ID="lnkPaymentView" runat="server"><%# Eval("PayDate") %></asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="Amount" HeaderText="金额" DataFormatString="￥{0:F2}"></asp:BoundField>
                                    <asp:BoundField DataField="PayMothodName" HeaderText="方式"></asp:BoundField>
                                    <asp:HyperLinkField DataNavigateUrlFields="CustomerId" DataNavigateUrlFormatString="/crm/customer/CustomerView.aspx?CustomerID={0}"
                                        DataTextField="CustomerName" HeaderText="客户名称" Target="_blank" />
                                    <asp:TemplateField HeaderText="订单号">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="hypView" Target="_blank" runat="server" Text='<%# Eval("OrderSN") %>'></asp:HyperLink>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="IsRenewalText" HeaderText="订单类型" />
                                    <asp:TemplateField HeaderText="状态">
                                        <ItemTemplate>
                                            <img class='<%#Eval("IsPaid").ToString().Equals("1") ? "ico01" : "ico02"%>' src="/images/transparent.gif" />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="TrackUserName" HeaderText="业务员"></asp:BoundField>
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                            <asp:LinkButton ID="lnkbtnPayState" runat="server">确认</asp:LinkButton>
                                            <asp:LinkButton ID="lnkbtnEdit" runat="server">编辑</asp:LinkButton>
                                            <asp:LinkButton ID="lnkbtnDelete" runat="server">删除</asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                            <div class="pager-bar">
                                <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                                    PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                                    ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                                </webdiyer:AspNetPager>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        function CallbackFun(text, value) {
            $('#<%=txtCustomerName.ClientID %>').val(text);
            $('#<%=hdfCustomerId.ClientID %>').val(value);
        }
        function Reset() {
            $('#<%=txtCustomerName.ClientID %>').val("");
            $('#<%=hdfCustomerId.ClientID %>').val("");
        }
    </script>
</asp:Content>
