﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Main.Master" CodeBehind="OrderView.aspx.cs"
    Inherits="OAWeb.crm.orders.OrderView2" %>

<%@ Register Src="../../UserControls/OrderNav.ascx" TagName="OrderNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <style type="text/css">
        .right
        {
            color: #000000;
        }
        .table_list th
        {
            padding: 0px;
        }
        .order_State .table_list td
        {
            line-height: normal;
        }
        .order_product td
        {
            background-color: #fff;
            padding: 4px;
        }
        .TopText
        {
            margin-right: 10px;
            font-weight: normal;
        }
        .CenterText
        {
            margin-left: 10px;
            height: 35px;
            line-height: 35px;
        }
        .OrderTotal span
        {
            height: 30px;
            line-height: 30px;
        }
        .tabs .tab_contents .TrOrderItem td
        {
        	vertical-align:middle;
        }
    </style>
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:OrderNav ID="OrderNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title line_height32px" cellspacing="3">
                            <tr>
                                <td class="data_caption" style="border-bottom: none">
                                    <span class="left_title"><strong>订单</strong>:
                                        <asp:Literal ID="ltlOrderSN" runat="server"></asp:Literal>
                                        <strong class="fonts colorE">状态：<asp:Literal ID="ltlOrderState" runat="server" Text=""></asp:Literal>
                                        </strong>&nbsp;&nbsp;&nbsp;&nbsp;<asp:HyperLink ID="hypEdit" runat="server">编辑</asp:HyperLink><a
                                            href="javascript:void(0)" onclick="window.location.href='<%=Request["ref"] %>'">返回</a></span>
                                    <span class="op">
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" ID="hypAudit" runat="server">审批</asp:HyperLink>
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" Enabled="false" ID="hypPay" runat="server">收款</asp:HyperLink>
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" Enabled="false" ID="hypBackPay" runat="server">退款</asp:HyperLink>
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" Enabled="false" ID="hypDelivery"
                                            runat="server">发货</asp:HyperLink>
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" Enabled="false" ID="hypBack" runat="server">退货</asp:HyperLink>
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" Enabled="false" ID="hypBlankOut"
                                            runat="server">作废</asp:HyperLink>
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" Enabled="false" ID="hypComplete"
                                            runat="server">结束</asp:HyperLink>
                                        <asp:HyperLink NavigateUrl="javascript:void(0)" ID="hypBegin" runat="server" Visible="false">开启</asp:HyperLink>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight: bolder; padding-left: 15px;">
                                    <span style="">客户：</span> <span class="TopText">
                                        <asp:HyperLink ID="hypCustomerName" Target="_blank" runat="server"></asp:HyperLink></span>
                                    <span style="">下单时间：</span> <span class="TopText">
                                        <asp:Label ID="lblCreateDate" runat="server" Text=""></asp:Label></span> <span>业务员：</span>
                                    <span class="TopText">
                                        <asp:Label ID="lblTrackUserName" runat="server" Text=""></asp:Label></span>
                                </td>
                            </tr>
                        </table>
                        <div class="tabs">
                            <div class="tab_handles">
                                <span class="current">基本信息</span> <span>收退款记录</span> <span>发退货记录</span> <span>订单日志</span>
                            </div>
                            <div class="tab_contents">
                                <div class="tab_content">
                                    <div class="order_widget">
                                        <div class="order_State">
                                            <strong class="fonts ">收货地址</strong>
                                            <table border="0" cellspacing="0" cellpadding="0" style="margin: 10px;">
                                                <tr>
                                                    <td>
                                                        <asp:Literal ID="ltlArea" runat="server"></asp:Literal>
                                                        <asp:Literal ID="ltlAddress" runat="server"></asp:Literal>(收货人：<asp:Literal ID="ltlShipTo"
                                                            runat="server"></asp:Literal>
                                                        电话：<asp:Literal ID="ltlTelPhone" runat="server"></asp:Literal>
                                                        手机：<asp:Literal ID="ltlMobile" runat="server"></asp:Literal>
                                                        邮编：<asp:Literal ID="ltlPostCode" runat="server"></asp:Literal>)
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        配送方式：<asp:Literal ID="ltlShippingName" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="order_widget">
                                        <div class="order_State">
                                            <strong class="fonts ">支付相关</strong>
                                            <table border="0" cellspacing="0" cellpadding="0" style="margin: 10px;">
                                                <tr>
                                                    <td>
                                                        支付方式：
                                                        <asp:Literal ID="ltlPayMothodName" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        是否开票：<asp:Literal ID="ltlBInvoice" runat="server"></asp:Literal><asp:LinkButton ID="hypCreateInvoice"
                                                            runat="server" CssClass="red">[申请开票]</asp:LinkButton>
                                                        <span style="margin: 15px;">发票抬头：<asp:Literal ID="ltlInvPayee" runat="server"></asp:Literal></span>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="order_widget">
                                        <div class="order_State">
                                            <strong class="fonts ">其他信息</strong>
                                            <table border="0" cellspacing="0" cellpadding="0" style="margin: 10px;">
                                                <tr>
                                                    <td class="right ">
                                                        是否续费单：
                                                    </td>
                                                    <td>
                                                        <asp:Literal ID="ltlIsRenewalText" runat="server"></asp:Literal>
                                                    </td>
                                                    <td class="right ">
                                                        &nbsp;&nbsp;&nbsp;商机来源：
                                                    </td>
                                                    <td colspan="3">
                                                        <asp:Literal ID="ltlOpptunityID" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="right ">
                                                        物流公司：
                                                    </td>
                                                    <td>
                                                        <asp:Literal ID="ltlLogistic" runat="server"></asp:Literal>
                                                    </td>
                                                    <td class="right ">
                                                        买家留言：
                                                    </td>
                                                    <td colspan="3">
                                                        <asp:Literal ID="ltlPostscript" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="right ">
                                                        备注：
                                                    </td>
                                                    <td colspan="3">
                                                        <asp:Literal ID="ltlRemark" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="order_widget">
                                        <div class="order_State">
                                            <strong class="fonts ">商品清单</strong>
                                            <table class="table_list" cellspacing="0" cellpadding="0" border="0" id="ctl00_ContentPlace_gvData"
                                                style="border-collapse: collapse; margin-top: 10px;">
                                                <tr>
                                                    <th scope="col">
                                                        商品货号
                                                    </th>
                                                    <th scope="col">
                                                        商品名称
                                                    </th>
                                                    <th scope="col">
                                                        成本价
                                                    </th>
                                                    <th scope="col">
                                                        市场价
                                                    </th>
                                                    <th scope="col">
                                                        成交价
                                                    </th>
                                                    <th scope="col">
                                                        购买数量
                                                    </th>
                                                    <th scope="col">
                                                        优惠
                                                    </th>
                                                    <th scope="col">
                                                        发货数量
                                                    </th>
                                                    <th scope="col">
                                                        总价
                                                    </th>
                                                </tr>
                                                <asp:Repeater ID="rptData" runat="server" OnItemDataBound="rptData_ItemDataBound">
                                                    <ItemTemplate>
                                                        <tr align="left"  class="TrOrderItem">
                                                            <td>
                                                                <%#Eval("ProductSN")%>
                                                            </td>
                                                            <td>
                                                                <%#Eval("ProductName")%>
                                                                <span class="red">
                                                                    <%# Eval("TypeText").ToString() == "续单" ? "(续单)" : ""%></span><br />
                                                                <%# Eval("SN").ToString() == "" ? "" : ("(序列号：" + Eval("SN").ToString() + ")")%>
                                                            </td>
                                                            <td class="product_price">
                                                                <%#Eval("CostPrice", "￥{0:F2}")%>
                                                            </td>
                                                            <td class="product_price">
                                                                <%#Eval("MarketPrice", "￥{0:F2}")%>
                                                            </td>
                                                            <td class="product_price">
                                                                <%#Eval("RealPrice", "￥{0:F2}")%>
                                                            </td>
                                                            <td>
                                                                <%#Eval("PayNum")%>
                                                                <%# Eval("Unit") %>
                                                            </td>
                                                            <td>
                                                                <%#Eval("DiscountFee")%><br />
                                                                <asp:Label ID="lblAdjustFee" runat="server" Text=""></asp:Label>
                                                            </td>
                                                            <td>
                                                                <%#Eval("SendNum")%>
                                                                <%# Eval("Unit") %>
                                                            </td>
                                                            <td>
                                                                <%#Eval("Amount","￥{0:F2}")%>
                                                            </td>
                                                        </tr>
                                                    </ItemTemplate>
                                                </asp:Repeater>
                                                <tr>
                                                    <td colspan="9" style="text-align: right; padding-right: 20px; background-color: #FAFAF8">
                                                        产品总价：￥<asp:Label ID="lblPAmount" runat="server" CssClass="red" Text="0.00"></asp:Label>
                                                    </td>
                                                </tr>
                                            </table>
                                            <table border="0" cellspacing="1" cellpadding="0" class="order_product" style="margin-top: 10px;
                                                width: 100%; background-color: #E4E4E4">
                                                <tr>
                                                    <td class="right ">
                                                        运费：
                                                    </td>
                                                    <td style="width: 100px">
                                                        ￥<asp:Literal ID="ltlFreight" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="right ">
                                                        保险费：
                                                    </td>
                                                    <td style="width: 100px">
                                                        ￥<asp:Literal ID="ltlInsurance" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="right ">
                                                        发票税：
                                                    </td>
                                                    <td style="width: 100px">
                                                        ￥<asp:Literal ID="ltlTax" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="right ">
                                                        支付手续费：
                                                    </td>
                                                    <td style="width: 100px">
                                                        ￥<asp:Literal ID="ltlPayFee" runat="server"></asp:Literal>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="right ">
                                                        <span class="red">订单总金额：</span>
                                                    </td>
                                                    <td style="width: 100px">
                                                        <span class="red">￥<asp:Literal ID="ltlOrderTotal" runat="server"></asp:Literal></span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="right ">
                                                        <span class="green">已支付金额：</span>
                                                    </td>
                                                    <td style="width: 100px">
                                                        <span class="green">￥<asp:Literal ID="ltlPayedAmount" runat="server"></asp:Literal></span>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab_content hide">
                                    <div class="order_widget">
                                        <div class="order_State">
                                            <div class="order_table">
                                                <h4>
                                                    收/退款单据</h4>
                                                <table class="table_list" cellspacing="0" cellpadding="0" border="0">
                                                    <tr>
                                                        <th scope="col">
                                                            收/退款日期
                                                        </th>
                                                        <th scope="col">
                                                            收/退款金额
                                                        </th>
                                                        <th scope="col">
                                                            收/退款方式
                                                        </th>
                                                        <th scope="col">
                                                            状态
                                                        </th>
                                                    </tr>
                                                    <asp:Repeater ID="rptPayData" runat="server">
                                                        <ItemTemplate>
                                                            <tr align="left">
                                                                <td align="center">
                                                                    <%#Eval("PayDate")%>
                                                                </td>
                                                                <td align="center ">
                                                                    <%#Eval("Amount")%>
                                                                </td>
                                                                <td align="center">
                                                                    <%#Eval("PayMothodName")%>
                                                                </td>
                                                                <td align="center">
                                                                    <img class='<%#Eval("IsPaid").ToString().Equals("1") ? "ico01" : "ico02"%>' src="/images/transparent.gif" />
                                                                </td>
                                                            </tr>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </table>
                                            </div>
                                            <div class="order_table" style="margin: 10px">
                                                <h4>
                                                    发票</h4>
                                                <table class="table_list" cellspacing="0" cellpadding="0" border="0">
                                                    <tr>
                                                        <th scope="col">
                                                            发票类型
                                                        </th>
                                                        <th scope="col">
                                                            发票号码
                                                        </th>
                                                        <th scope="col">
                                                            开票金额
                                                        </th>
                                                        <th scope="col">
                                                            状态
                                                        </th>
                                                    </tr>
                                                    <asp:Repeater ID="rptInvoiceData" runat="server">
                                                        <ItemTemplate>
                                                            <tr align="left">
                                                                <td align="center">
                                                                    <%#Eval("InvoiceTypeText")%>
                                                                </td>
                                                                <td align="center ">
                                                                    <%#Eval("InvoiceNo")%>
                                                                </td>
                                                                <td align="center">
                                                                    <%#Eval("InvoiceTax", "￥{0:F2}")%>
                                                                </td>
                                                                <td align="center">
                                                                    <%#Eval("StateText")%>
                                                                </td>
                                                            </tr>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab_content hide">
                                    <div class="order_widget">
                                        <div class="order_State">
                                            <table style="width: 99%; margin-top: 10px" border="0" cellspacing="3" cellpadding="8">
                                                <tr>
                                                    <td style="vertical-align: top">
                                                        <div class="order_table">
                                                            <h4>
                                                                发货单</h4>
                                                            <table class="table_list" cellspacing="0" cellpadding="0" border="0">
                                                                <tr>
                                                                    <th scope="col">
                                                                        发货日期
                                                                    </th>
                                                                    <th scope="col">
                                                                        发货单号
                                                                    </th>
                                                                    <th scope="col">
                                                                        物流单号
                                                                    </th>
                                                                    <th scope="col">
                                                                        收件人
                                                                    </th>
                                                                    <th scope="col">
                                                                        配送方式
                                                                    </th>
                                                                </tr>
                                                                <asp:Repeater ID="rptShipData" runat="server">
                                                                    <ItemTemplate>
                                                                        <tr align="left">
                                                                            <td align="center">
                                                                                <%#Eval("ShipDate")%>
                                                                            </td>
                                                                            <td align="center ">
                                                                                <%#Eval("DeliveryCode")%>
                                                                            </td>
                                                                            <td align="center">
                                                                                <%#Eval("LogiNo")%>
                                                                            </td>
                                                                            <td align="center">
                                                                                <%#Eval("ShipName")%>
                                                                            </td>
                                                                            <td align="center">
                                                                                <%#Eval("ShippingMothod")%>
                                                                            </td>
                                                                        </tr>
                                                                    </ItemTemplate>
                                                                </asp:Repeater>
                                                            </table>
                                                        </div>
                                                    </td>
                                                    <td style="vertical-align: top">
                                                        <div class="order_table">
                                                            <h4>
                                                                退货单</h4>
                                                            <table class="table_list" cellspacing="0" cellpadding="0" border="0">
                                                                <tr>
                                                                    <th scope="col">
                                                                        退货日期
                                                                    </th>
                                                                    <th scope="col">
                                                                        退货单号
                                                                    </th>
                                                                    <th scope="col">
                                                                        物流单号
                                                                    </th>
                                                                    <th scope="col">
                                                                        退件人
                                                                    </th>
                                                                    <th scope="col">
                                                                        退货方式
                                                                    </th>
                                                                </tr>
                                                                <asp:Repeater ID="rptReturnShipData" runat="server">
                                                                    <ItemTemplate>
                                                                        <tr align="left">
                                                                            <td align="center">
                                                                                <%#Eval("ShipDate")%>
                                                                            </td>
                                                                            <td align="center ">
                                                                                <%#Eval("DeliveryCode")%>
                                                                            </td>
                                                                            <td align="center">
                                                                                <%#Eval("LogiNo")%>
                                                                            </td>
                                                                            <td align="center">
                                                                                <%#Eval("ShipName")%>
                                                                            </td>
                                                                            <td align="center">
                                                                                <%#Eval("ShippingMothod")%>
                                                                            </td>
                                                                        </tr>
                                                                    </ItemTemplate>
                                                                </asp:Repeater>
                                                            </table>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab_content hide">
                                    <div class="order_widget">
                                        <div class="order_State">
                                            <div class="order_table">
                                                <table class="table_list" cellspacing="0" cellpadding="0" border="0">
                                                    <tr>
                                                        <th scope="col">
                                                            操作日期
                                                        </th>
                                                        <th scope="col">
                                                            动作
                                                        </th>
                                                        <th scope="col">
                                                            操作人
                                                        </th>
                                                    </tr>
                                                    <asp:Repeater ID="rptLogData" runat="server">
                                                        <ItemTemplate>
                                                            <tr align="left">
                                                                <td align="center">
                                                                    <%#Eval("LogDateTime")%>
                                                                </td>
                                                                <td align="center ">
                                                                    <%#Eval("LogContent")%>
                                                                </td>
                                                                <td align="center">
                                                                    <%#Eval("CreateUserName")%>
                                                                </td>
                                                            </tr>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        $(document).ready(function () {
            $(".tab_handles span").click(function () {
                var hideIndex = $(".tab_handles .current").index();
                $(".tab_handles span").removeClass("current");
                $(this).addClass("current");
                $(".tab_contents .tab_content:eq(" + hideIndex + ")").hide();
                $(".tab_contents .tab_content:eq(" + $(this).index() + ")").show();
            })
        })
    </script>
</asp:Content>
