﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" Theme="Default" EnableViewState="true"
    AutoEventWireup="true" CodeBehind="CustomerServiceList.aspx.cs" Inherits="OAWeb.crm.customer.CustomerServiceList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/OrderNav.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        function SelectUser() {
            OpenRadioDialog('/Dialog/EmploySelectDialog.aspx?user=0', '选择负责人', function (text, value) {
                $("#<%=hdfUerId.ClientID %>").val(value);
                $("#<%=txtUserName.ClientID %>").val(text);
            });
        }

    </script>
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:TaskNav ID="TaskNav1" runat="server" />
            </td>
            <td class="main_center">
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title">
                            <tr>
                                <td class="data_caption" colspan="4">
                                    <asp:Label ID="lblCaption" runat="server" Text="服务工单"></asp:Label>
                                </td>
                            </tr>
                            <tr>
                                <td class="tb-label" colspan="4">
                                    客户名称：
                                
                             
                                    <asp:TextBox ID="txtCustomerName" runat="server" Width="180px"></asp:TextBox>
                                    负责人：
                                    <asp:TextBox ID="txtUserName" runat="server" Width="180px" onclick="SelectUser()" ReadOnly="true"></asp:TextBox>
                                    <asp:HiddenField ID="hdfUerId" runat="server" />
                                    <asp:Button ID="btnSearch" runat="server" Text="查  询" OnClick="btnSearch_Click" CssClass="btn_77px" />
                                    
                              </td>
                             
                            </tr>
                        </table>
                        <div class="buttons-bar" style="margin-bottom: 10px;">
                            <asp:Button ID="btnDel" runat="server" Text="删除"  OnClientClick="return confirm('确定要删除?')" OnClick="btnDel_Click" CssClass="btn_77px" />
                        </div>
                        <asp:GridView ID="gvOpportunity" runat="server" AutoGenerateColumns="False" DataKeyNames="IssueId"
                            OnRowDataBound="gvOpportunity_RowDataBound" OnRowCommand="gvOpportunity_RowCommand"
                            PageSize="20">
                            <HeaderStyle Wrap="False" />
                            <Columns>
                                <asp:TemplateField>
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <input runat="server" id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("IssueId")%>' />
                                    </ItemTemplate>
                                    <ItemStyle Width="20px" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="标题">
                                    <ItemTemplate>
                                        <a href="" id="LinkView" runat="server"><%# Eval("title") %></a>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:TemplateField>
                                
                                <asp:TemplateField HeaderText="时间期限">
                                    <ItemTemplate>
                                        
                                        <%# ObjToStr(Eval("TimePlanEnd")).Contains("0001") ? "" : Eval("TimePlanEnd")%>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:TemplateField>

                                <asp:TemplateField HeaderText="执行人">
                                    <ItemTemplate>
                                       
                                        <%# OACore.Caches.UsersCache.Instance.GetNickName(ObjToInt(Eval("AssigneeId")))%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="状态">
                                    <ItemTemplate>
                                        <asp:Label ID="Label1" runat="server" Text='<%# GetIssueStatusText(DataBinder.Eval(Container.DataItem,"IssueStatus").ToString()) %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="创建人">
                                    <ItemTemplate>
                                   
                                       <span id="spCreateName" runat="server"><%# OACore.Caches.UsersCache.Instance.GetNickName(ObjToInt(Eval("CreateById")))%></span> 
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="编辑">
                                    <ItemTemplate>
                                        <a id="LinkEdit" runat="server" href="javascript:void(0)">编辑</a>
                                        <asp:LinkButton ID="lnkbtnDelete" runat="server" OnClientClick="return confirm('确定要删除?')" CommandName="Del" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"IssueID").ToString()%>'>删除</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                        <div class="pager-bar">
                            <webdiyer:AspNetPager ID="plOpportunity" runat="server" AlwaysShow="True" Direction="LeftToRight"
                                FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
                                OnPageChanged="plOpportunity_PageChanged" PrevPageText="[上一页]" ShowCustomInfoSection="Left"
                                Width="100%" PageSize="20">
                            </webdiyer:AspNetPager>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
