﻿<%@ Page Language="C#" AutoEventWireup="true" Theme="Default" MasterPageFile="~/Main.Master"
    CodeBehind="CustomerList.aspx.cs" Inherits="OAWeb.crm.CustomerList" EnableViewState="true" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/CustomerLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script language="javascript" type="text/javascript">
        //打开分配窗口
        function OpenAssignDialog() {
            if (document.getElementById('<% =hdfOwnerId.ClientID %>').value != "") {
                return true;
            }
            if (getCheckedValueList() == "") {
                alert("请选择要分配的数据！");
                return false;
            }
            var Url = "/Dialog/EmploySelectDialog.aspx?user=0";

            OpenRadioDialog(Url, "选择员工", function (text, value) {
                document.getElementById('<% =hdfOwnerId.ClientID %>').value = value;
                document.getElementById('<% =btnAllot.ClientID %>').click();

            });
            return false;
        }
        //打开归还窗口
        function OpenBackCustomerDialog() {
            var values = getCheckedValueList();
            if (values == "") {
                alert("请选择要归还的数据！");
                return false;
            }


            var Url = "/Dialog/BackCustomer.aspx?IdArray=" + values;

            OpenDialog(Url, "");
            return false;


        }

        function MoveCustomer() {
            var values = getCheckedValueList();
            if (values == "") {
                alert("请选择要移动的客户！");
                return false;
            }

            var Url = "/Dialog/MoveCustomer.aspx?IdArray=" + values;

            OpenDialog(Url, "移动客户");
            return false;


        }

        function AddNewCustomer() {
            var values = getCheckedValueList();

            if (values == "") {
                alert("请选择需要合并的2条数据");
            }
            else {
                var v = values.split(",");
                if (v.length != 2) {
                    alert("目前只支持2条合并");
                }
                else {
                    var str = "";
                    for (var i = 0; i < v.length; i++) {
                        str += "'" + v[i] + "',";
                    }
                    str = str.substr(0, str.length - 1);

                    var Url = "CustomerNew.aspx?strIds=" + str;

                    OpenWindow(Url, "1000", "600");
                }
            }
        }

        function SendMessage() {
            var values = getCheckedValueList();
            if (values == "") {
                alert("请选择要操作的客户");
                return;
            }
            var url = "/Dialog/SendMessage.aspx?IdList=" + values;
            OpenDialog(url, "群发信息");
        }
    </script>
    <script type="text/javascript" language="javascript">
        //CallCity("ctl00_ContentPlaceHolder1_ddlProvince");
    </script>
    <!--搜索区域 开始-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:TaskNav ID="TaskNav1" runat="server" />
            </td>
            <td class="main_center">
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    <span style="float: left;"><em style="float: left">
                                        <img src="/images/03.gif" />
                                    </em>
                                        <asp:Label ID="lblCaption" runat="server"></asp:Label><br />
                                        <span class="tip01">管理客户信息.您可以添加、编辑、删除客户</span> </span><span style="float: right;">
                                            <asp:DropDownList ID="ddlField" runat="server">
                                                <asp:ListItem Value="0">客户名称</asp:ListItem>
                                                <asp:ListItem Value="1">联系人</asp:ListItem>
                                                <asp:ListItem Value="2">联系电话</asp:ListItem>
                                                <asp:ListItem Value="3">联系手机</asp:ListItem>
                                                <asp:ListItem Value="4">联系QQ</asp:ListItem>
                                                <asp:ListItem Value="5">业务归属</asp:ListItem>
                                            </asp:DropDownList>
                                            <asp:TextBox ID="txtKeyword" runat="server" CssClass="text_box width120"></asp:TextBox><asp:Button
                                                ID="btnSearch" runat="server" OnClick="btnSearch_Click" TabIndex="1" Text=" 查 询 "
                                                CssClass="btn_77px" /><asp:Button ID="btnAdvanceSearch" runat="server" Text="高级查询"
                                                    CssClass="btn_77px" OnClientClick="return SearchSQL();" />
                                            <asp:HiddenField ID="hdfTrackUserID" runat="server" />
                                        </span>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    群组：
                                    <asp:Repeater ID="rpView" runat="server">
                                        <ItemTemplate>
                                            <a id="View<%# Eval("Id") %>" href='/crm/customer/customerList.aspx?ViewId=<%# Eval("Id") %>'>
                                                <%# Eval("Title") %></a>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                    <a href="javascript:void(0)" onclick="OpenDialog('/SearchView/SavedSearchList.aspx?ModuleName=Customer', '查询视图配置');return false;"
                                        style="color: Blue" id="LinkGroup" runat="server">[群组管理]</a>
                                </td>
                            </tr>
                        </table>
                        <script>
                            var TypeId = "<%= TypeId %>";
                            var ViewId = "<%= ViewId %>";
                            
                           
                            if (ViewId == "00000000-0000-0000-0000-000000000000")
                                $("#LinkType" + TypeId + " span:first-child").css("color", "red");
                            else {
                                
                                $("#View" + ViewId).css("color", "red");
                                
                            }
                            
                        </script>
                        <div class="buttons-bar" style="margin-bottom: 10px;">
                            <table class="w100p" style="width: 100%">
                                <tr>
                                    <td align="left">
                                        <asp:Button ID="btnAddCustomer" runat="server" Text="新建客户" CssClass="btn_77px" />
                                        <asp:Button ID="btnAddAction" runat="server" Text="新建活动" CssClass="btn_77px" Visible="false" />
                                        <asp:Button ID="btnAllot" runat="server" Text="分 配" OnClick="btnAllot_Click" CssClass="btn_77px" />
                                        <asp:Button ID="btnBack" runat="server" OnClick="btnBack_Click" Text="归 还" CssClass="btn_77px" />
                                        <input type="button" value="移动到" class="btn_77px" onclick="MoveCustomer()" />
                                        <asp:Button ID="btnDelCustomer" runat="server" OnClick="btnDelCustomer_Click" Text="删 除"
                                            CssClass="btn_77px" />
                                        <asp:Button ID="btnAddFavorite" runat="server" Text="加入收藏" CssClass="btn_77px" OnClick="btnAddFavorite_Click"
                                            Visible="false" />
                                        <asp:Button ID="btnDelFavorite" runat="server" Text="删除收藏" CssClass="btn_77px" OnClick="btnDelFavorite_Click"
                                            Visible="false" />
                                        <asp:Button ID="btnLock" runat="server" Text="锁 住" CssClass="btn_77px" OnClick="btnLock_Click" />
                                        <asp:Button ID="btnUnLock" runat="server" Text="解 锁" CssClass="btn_77px" OnClick="btnUnLock_Click" />
                                        <asp:Button ID="btnSend" runat="server" Text="群发推广" CssClass="btn_77px" OnClientClick="return AddPromote();" />
                                        <input runat="server" id="btnAddNewCustomer" type="button" value="合并客户" class="btn_77px"
                                            onclick="AddNewCustomer()" />
                                    </td>
                                    <td align="right">
                                        <asp:DropDownList ID="ddlSort" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlSort_SelectedIndexChanged">
                                            <asp:ListItem Value="Customer.CreateDate desc">创建时间</asp:ListItem>
                                            <asp:ListItem Value="Customer.last_login desc">活跃时间</asp:ListItem>
                                            <asp:ListItem Value="Customer.ModifyDate desc">修改时间</asp:ListItem>
                                            <asp:ListItem Value="Customer.NextContactTime desc">下次联系</asp:ListItem>
                                            <asp:ListItem Value="Customer.LastTradeDate desc">交易时间</asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <asp:GridView ID="gvCustomerList" runat="server" AutoGenerateColumns="False" DataKeyNames="CustomerID"
                            OnRowCommand="gvCustomerList_RowCommand" OnRowDataBound="gvCustomerList_RowDataBound"
                            PageSize="20">
                            <HeaderStyle Wrap="False" />
                            <Columns>
                                <asp:TemplateField>
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <input runat="server" id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("CustomerID")%>' />
                                    </ItemTemplate>
                                    <ItemStyle Width="20px" />
                                </asp:TemplateField>
                                <asp:BoundField DataField="CustomerID" HeaderText="编号" Visible="false">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="">
                                    <ItemStyle HorizontalAlign="Left" Width="30px" />
                                    <ItemTemplate>
                                        <span id="spLock" runat="server"></span><span id="spImg" runat="server"></span>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="客户相关信息">
                                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                                    <ItemStyle HorizontalAlign="Left" />
                                    <ItemTemplate>
                                        <div style="margin-top: 0px; float: left; width: 100%; color: #666666; font-size: 14px;
                                            text-align: left; line-height: 20px;">
                                            <asp:Image ID="Image1" runat="server" Width="16" Height="16" />
                                            <asp:LinkButton ID="lnkbtnView" runat="server" CausesValidation="false" CommandName="lbtView"
                                                CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'><strong><%# Eval("CustomerName").ToString()%></strong></asp:LinkButton>
                                            <span style="font-size: 12px">(<strong>种类:</strong><asp:Label ID="lblBizTypeName"
                                                runat="server"></asp:Label>)
                                                <br />
                                                <strong>联系人：</strong><asp:Label ID="lblContactMan" runat="server" Text='<%# Eval("MainContactName") %>'></asp:Label>&nbsp;
                                                <strong>电话：</strong><asp:Label ID="lblTelephone" runat="server" ForeColor="blue"
                                                    Text='<%# DataBinder.Eval(Container.DataItem, "Telephone")%>'></asp:Label>&nbsp;
                                                <strong>来源：</strong><asp:Label ID="lblSource" runat="server" Text=''></asp:Label>&nbsp;
                                                <asp:Label ID="lbllLayAside" runat="server"></asp:Label><br />
                                                <%# ObjToStr(Eval("NextContactTime")).Contains("0001") ? "" : "下次联系时间：" + Eval("NextContactTime")%>
                                            </span>
                                        </div>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="CityName" HeaderText="城市">
                                    <ItemStyle Width="60px" />
                                </asp:BoundField>
                                <asp:BoundField DataField="StageName" HeaderText="阶段" Visible="False">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="状态">
                                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                                    <ItemTemplate>
                                        <asp:Label ID="lblState" runat="server" Text="Label"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="级别">
                                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                                    <ItemTemplate>
                                        <%# OACore.Caches.CustomerGradeCache.Instance.GetName(ObjToInt( Eval("CustomerGradeId"))) %>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="交易数">
                                    <ItemStyle HorizontalAlign="Center" Width="40px" />
                                    <ItemTemplate>
                                        <%# ObjToStr(Eval("OrderCount")) == "0" ? "" : Eval("OrderCount")%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="最近交易">
                                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                                    <ItemTemplate>
                                        <%# ObjToStr(Eval("LastTradeDate")).Contains("0001") ? "" :Convert.ToDateTime(Eval("LastTradeDate")).ToShortDateString()%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="业务负责">
                                    <HeaderStyle HorizontalAlign="Center" Width="60px"></HeaderStyle>
                                    <ItemTemplate>
                                        <asp:Label ID="lblOwnerName" runat="server" Text='<%#Eval("OwnerName") %>'></asp:Label>
                                        <asp:Label ID="lblOwnerID" runat="server" Text='<%#Eval("OwnerID") %>' Visible="false"></asp:Label>
                                        <asp:LinkButton ID="lnkbtnTrack" runat="server" CausesValidation="false" CommandName="cmdTrack"
                                            CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'>领用</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="CreateDate" HeaderText="创建日期" SortExpression="Customer.CreateDate"
                                    DataFormatString="{0:g}" HtmlEncode="false">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" Width="100px" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="最后活动">
                                    <ItemStyle Width="100px" />
                                    <ItemTemplate>
                                        <%# getStr1(ObjToStr(Eval("LastAction")),30) %>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="操作">
                                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                                    <ItemTemplate>
                                        <asp:LinkButton ID="lnkbtnEdit" runat="server" CausesValidation="false" CommandName="cmdEdit"
                                            CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'>编辑</asp:LinkButton>
                                        <asp:LinkButton ID="lnkbtnDelete" runat="server" CausesValidation="false" CommandName="cmdDelete"
                                            CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'>删除</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                        <div class="pager-bar">
                            <webdiyer:AspNetPager ID="plCustomer" runat="server" OnPageChanged="plCustomer_PageChanged"
                                PageSize="20">
                            </webdiyer:AspNetPager>
                        </div>
                        <asp:HiddenField ID="hdfSql" runat="server" />
                        <asp:HiddenField ID="hidFilter" runat="server" />
                        <asp:HiddenField ID="hdfOwnerId" runat="server" />
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        function AddPromote() {
            var url = "/crm/promote/SelectData.aspx?datatype=customer";
            var ids = GetCustomerCheckedValues();
            var filter = $("#<%=hidFilter.ClientID %>").val();
            return OpenDialog(url + "&Ids=" + escape(ids) + "&Filter=" + filter, '群发推广');
        }
        function GetCustomerCheckedValues() {
            var chk = $(document.body).find('input[type="checkbox"]:checked');
            var chk_value = [];
            $.each(chk, function (i, o) {
                if ($(this).attr("name").indexOf("chkItem") > -1)
                    chk_value.push($(o).val());
            });
            return chk_value.join(",");
        }
        function SearchSQL() {
            if (art.dialog != "") art.dialog.data('departValue', ""); //清空防止上一次的缓存
            return OpenDialog2('/SearchView/SavedSearchEdit.aspx?modulename=Customer&op_type=search&r=' + Math.random(), '高级搜索', function () {
                var bValue = art.dialog.data('departValue');
                if (bValue != null && bValue != "") {
                    $("#<%=hdfSql.ClientID %>").val(bValue);
                    $("#<%=btnSearch.ClientID %>").click();
                }
            });
        }
        $(document).ready(function () {
            //负责人选择
            $("#<%=ddlField.ClientID %>").change(function () {
                if (this.value == "5") $("#<%=txtKeyword.ClientID %>").attr("readOnly", "readOnly");
                else $("#<%=txtKeyword.ClientID %>").removeAttr("readOnly");
                $("#<%=hdfTrackUserID.ClientID %>").val("");
                $("#<%=txtKeyword.ClientID %>").val("");
            })
            $("#<%=txtKeyword.ClientID %>").click(function () {
                $(this).removeAttr("readOnly");
                var ddl = $("#<%=ddlField.ClientID %>");
                if (ddl.val() != "5") return;
                $(this).attr("readOnly", "readOnly");
                OpenRadioDialog('/Dialog/EmploySelectDialog.aspx?user=0', '选择负责人', function (text, value) {
                    $("#<%=hdfTrackUserID.ClientID %>").val(value);
                    $("#<%=txtKeyword.ClientID %>").val(text);
                });
            })
        })

    </script>
</asp:Content>
