﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="ClueList.aspx.cs"
    Inherits="OAWeb.crm.clues.ClueList" Title="线索列表" EnableEventValidation="false" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/ClueLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:TaskNav ID="TaskNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <table class="data_title" cellspacing="3">
                            <tr>
                                <td class="data_caption">
                                    <em style="float: left">
                                        <img src="/images/03.gif" />
                                    </em>线索列表<br />
                                    <span class="tip01">管理线索.您可以添加、编辑、删除线索</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_field">
                                    <%=LoadLinkOP()%>
                                    <br />
                                    <asp:DropDownList ID="ddlField" runat="server" Width="100px">
                                        <asp:ListItem Value="0">姓名</asp:ListItem>
                                        <asp:ListItem Value="1">公司名</asp:ListItem>
                                        <asp:ListItem Value="2">电话</asp:ListItem>
                                        <asp:ListItem Value="3">手机</asp:ListItem>
                                        <asp:ListItem Value="4">QQ</asp:ListItem>
                                    </asp:DropDownList>
                                    &nbsp;<asp:TextBox ID="txtKeyword" runat="server" CssClass="text_box"></asp:TextBox>
                                    <asp:Button ID="btnSearch" runat="server" Text=" 查 询 " CssClass="btn_77px" />
                                </td>
                            </tr>
                        </table>
                        <div class="page_op">
                            <asp:Button ID="btnNew" runat="server" Text="新增" CssClass="btn_77px" OnClientClick="return OpenDialog('/crm/clues/ClueEdit.aspx','新增线索');" />
                            <asp:Button ID="btnDelete" runat="server" Text="删除" CssClass="btn_77px" />
                            <asp:Button ID="btnMove" runat="server" Text="移动" CssClass="btn_77px" OnClientClick="return MoveClue();" />
                            <asp:Button ID="btnImport" runat="server" Text="导入" CssClass="btn_77px" OnClientClick="return OpenDialog('/crm/clues/ClueImportFileUpload.aspx','导入线索');"/>
                            <asp:Button ID="btnSend" runat="server" Text="群发推广" CssClass="btn_77px" OnClientClick="return AddPromote();" />
                        </div>
                        <div class="list">
                            <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                                GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                                OnRowDataBound="gvData_RowDataBound">
                                <RowStyle HorizontalAlign="Left" />
                                <Columns>
                                    <asp:TemplateField HeaderText="编号">
                                        <HeaderTemplate>
                                            <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                                        </HeaderTemplate>
                                        <ItemTemplate>
                                            <input id="chkItem" type="checkbox" value="<%#Eval("Id") %>" />
                                        </ItemTemplate>
                                        <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                                        <ItemStyle HorizontalAlign="Center" Width="10px"></ItemStyle>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="姓名">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="hypView" NavigateUrl="javascript:void(0);" runat="server"><%# Eval("ContactMan") %></asp:HyperLink>
                                        </ItemTemplate>
                                        <ItemStyle Width="100px" />
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="公司名称">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="hyplnkCustomerName" Target="_blank" NavigateUrl="javascript:void(0);" runat="server"><%# Eval("CustomerName")%></asp:HyperLink>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="ClueClassId" HeaderText="类别">
                                        <ItemStyle Width="80px" />
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Telephone" HeaderText="电话">
                                        <ItemStyle Width="100px" />
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Mobile" HeaderText="手机">
                                        <ItemStyle Width="80px" />
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Fax" HeaderText="传真" />
                                    <asp:BoundField DataField="Email" HeaderText="Email" />
                                    <asp:BoundField DataField="CreateDate" HeaderText="创建时间" />
                                    <asp:BoundField DataField="TransformStateText" HeaderText="状态" />
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                            <asp:LinkButton ID="lnkbtnTranslate" runat="server">转化</asp:LinkButton>
                                            <asp:LinkButton ID="lnkbtnEdit" runat="server">编辑</asp:LinkButton>
                                            <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                            <div class="pager-bar">
                                <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                                    PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                                    ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                                </webdiyer:AspNetPager>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        function MoveClue() {
            var ids = GetCheckedValues();
            if (ids == null || ids.length == 0) {
                alert("请选择要移动的数据");
                return false;
            }
            return OpenDialog('/crm/clues/ClueMove.aspx?Ids=' + ids, '移动线索');
        }
        function AddPromote() {
            var url = "/crm/promote/SelectData.aspx?datatype=clues";
            var ids = GetCheckedValues();
            return OpenDialog(url + "&Ids=" + escape(ids) + "&Filter=<%=Server.UrlEncode(Filter) %>", '群发推广');
            return false;
        }
    </script>
</asp:Content>
