﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="UserList.aspx.cs" Inherits="OAWeb.Users.UserList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体-->
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption">
                        账号管理
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        账号名：<asp:TextBox ID="txtUserName" runat="server" CssClass="text_box"></asp:TextBox>
                        <asp:DropDownList ID="ddlEnabled" runat="server">
                            <asp:ListItem>所有状态</asp:ListItem>
                            <asp:ListItem Value="1">启用</asp:ListItem>
                            <asp:ListItem Value="0">禁用</asp:ListItem>
                        </asp:DropDownList>
                        <asp:DropDownList ID="ddlDepartment" runat="server">
                        </asp:DropDownList>
                        <asp:CheckBox ID="chkNotUserName" runat="server" Text="未创建职员" />
                        <asp:Button ID="btnSearch" runat="server" Text="搜 索" CssClass="btn_77px" />
                    </td>
                </tr>
            </table>
            <div class="page_op">
                <asp:Button ID="btnNewUser" runat="server" Text="新增账号" CssClass="btn_77px" OnClientClick="return OpenDialog('/hrm/Employ/EmployFileEdit.aspx','新增账号');" />
                <asp:Button ID="BtnAudit" runat="server" Text="启用账号" CssClass="btn_77px" />
                <asp:Button ID="btnFreeze" runat="server" Text="禁用账号" CssClass="btn_77px" />
                <asp:Button ID="btnPassword" runat="server" Text="初始化密码" CssClass="btn_77px" />
                <asp:Button ID="btnRecycle" runat="server" Text="回收站" CssClass="btn_77px" OnClientClick="window.location.href='RecycleList.aspx';return false;" />
            </div>
            <div class="list">
                <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    GridLines="None" OnRowDataBound="gvData_RowDataBound" CellSpacing="0" CellPadding="0"
                    CssClass="table_list" EnableModelValidation="True">
                    <RowStyle HorizontalAlign="Left" />
                    <Columns>
                        <asp:TemplateField HeaderText="编号">
                            <HeaderTemplate>
                                <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <input id="chkItem" type="checkbox" value="<%#Eval("Id") %>" <%#Eval("UserName").ToString().ToLower() == "administrator" ? "disabled='disabled'" : "" %> />
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="10px"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField DataField="UserName" HeaderText="账号名"></asp:BoundField>
                        <asp:TemplateField HeaderText="启用状态">
                            <ItemTemplate>
                                <img class='<%#Eval("Enabled").ToString() == "0" ? "ico02" : "ico01"%>' src="/images/transparent.gif" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="RealName" HeaderText="职员名称"></asp:BoundField>
                        <asp:BoundField DataField="LastLoginDate" HeaderText="最后登录"></asp:BoundField>
                        <asp:BoundField DataField="LastLoginIP" HeaderText="最后登录IP"></asp:BoundField>
                        <asp:BoundField DataField="LogOnCount" HeaderText="登录次数" />
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbtnEdit" runat="server">编辑</asp:LinkButton>
                                <asp:LinkButton ID="lbtnSetRole" runat="server">角色</asp:LinkButton>
                                <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                        PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                        ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
