﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Dialog/DialogMaster.Master" AutoEventWireup="true"
    CodeBehind="UserAdd.aspx.cs" Inherits="OAWeb.Users.UserAdd" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="form" style="width: 600px; padding: 10px;">
        <table cellpadding="0" cellspacing="0" border="0" class="table_form">
            <tr>
                <td class="right">
                    <span class="red">*</span> 账号名称:
                </td>
                <td>
                    <asp:TextBox ID="txtUserName" runat="server" CssClass="text width200"></asp:TextBox><span
                        class="form_tip">账号名只能是数字和字母,5-20个字符</span>
                    <asp:CheckBox ID="chkEnabled" runat="server" Checked="True" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="right">
                    <span class="red">*</span> 登录密码:
                </td>
                <td>
                    <asp:TextBox ID="txtPassword" TextMode="Password" CssClass="text width200" runat="server"></asp:TextBox><span
                        class="form_tip">介于6-12个字符之间</span>
                </td>
            </tr>
            <tr>
                <td class="right">
                    职员名称:
                </td>
                <td>
                    <asp:TextBox ID="txtRealName" runat="server" CssClass="text width200"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="right">
                    备注:
                </td>
                <td>
                    <asp:TextBox ID="txtRemark" runat="server" CssClass="text" Width="99%" Height="75px"
                        TextMode="MultiLine"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    <input id="btnSave" type="button" value=" 保 存 " class="btn_77px" />
                    <input id="btnClose" type="button" value=" 返 回 " onclick="art.dialog.close();return false;"
                        class="btn_77px" />
                </td>
            </tr>
        </table>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            jQuery.validator.addMethod("UserIsExist", function (value, element) {
                return AjaxChecked("UserAdd.aspx", "op=UserNameExist&UserName=" + value + "&r=" + Math.random());
            }, "您输入的账号名称已经存在");
            rulesValue = { '<%=txtUserName.UniqueID %>': { required: true, UserIsExist: true, rangelength: [5, 20], UserName: true }, '<%=txtPassword.UniqueID %>': { required: true, rangelength: [6, 12]} };
            messagesValue = { '<%=txtUserName.UniqueID %>': { required: "请输入账号名称", rangelength: "账号长度必须介于5和20之间" }, '<%=txtPassword.UniqueID %>': { required: "请输入密码", rangelength: "密码长度必须介于6和12之间"} }
            var form = jQuery.validator.ValidateForm($("#aspnetForm"), rulesValue, messagesValue);
            $("#btnSave").click(function () {
                if (form.form()) {
                    $("#aspnetForm").ajaxSubmit({
                        url: "/Users/UserAdd.aspx?op=Save",
                        success: function (result) {
                            if (result == "ok") {
                                alert("保存成功");
                                CloseReload();
                            } else {
                                alert(result);
                            }
                        }
                    });
                }
                return false;
            })
        });
    </script>
</asp:Content>
