﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="RecycleList.aspx.cs" Inherits="OAWeb.Users.RecycleList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体-->
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption">
                        账号回收站
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        账号名：<asp:TextBox ID="txtUserName" runat="server" CssClass="text_box"></asp:TextBox>
                        <asp:Button ID="btnSearch" runat="server" Text="搜 索" CssClass="btn_77px" />
                    </td>
                </tr>
            </table>
            <div class="list">
                <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    GridLines="None" OnRowDataBound="gvData_RowDataBound" CellSpacing="0" CellPadding="0"
                    CssClass="table_list" EnableModelValidation="True">
                    <RowStyle HorizontalAlign="Left" />
                    <Columns>
                        <asp:BoundField DataField="UserName" HeaderText="账号名"></asp:BoundField>
                        <asp:TemplateField HeaderText="启用状态">
                            <ItemTemplate>
                                <img class='<%#Eval("Enabled").ToString() == "0" ? "ico02" : "ico01"%>' src="/images/transparent.gif" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="RealName" HeaderText="职员名称"></asp:BoundField>
                        <asp:BoundField DataField="LastLoginDate" HeaderText="最后登录"></asp:BoundField>
                        <asp:BoundField DataField="LastLoginIP" HeaderText="最后登录IP"></asp:BoundField>
                        <asp:BoundField DataField="LogOnCount" HeaderText="登录次数" />
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbtnUser" runat="server">还原</asp:LinkButton>
                                <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                        PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                        ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="true">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
