﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="OpportunityList.ascx.cs"
    Inherits="OAWeb.UserControls.OpportunityList" EnableViewState="true" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<script language="javascript" type="text/javascript">
    //打开分配窗口
    function OpenAssignDialog(AssetIdList, TrackUserIdList) {
        if (AssetIdList == undefined || AssetIdList == null) {
            AssetIdList = getCheckedValueList();
        }
        if (AssetIdList == "") {
            alert("请选择要分配的数据！");
            return false;
        }
        var Url = "/Dialog/EmploySelectDialog.aspx";
        var ReturnUrl = location.href;

        OpenRadioDialog(Url, "选择员工", function (text, value) {

            AjaxRequest("/UserControls/OpportunityList.ascx?op=UpdateTrackUser&AssetIdList=" + escape(AssetIdList) + "&TrackUserIdList=" + escape(TrackUserIdList) + "&UserId=" + escape(value), function (status, text) {
                if (text.indexOf("ok") != -1) {
                    alert(text.split(',')[1] + "条分配成功");

                    var ReloadUrl = getRestoreUrl(location.href);
                    location.href = ReloadUrl;
                }
                else {
                    alert("分配失败");
                }
            });
        });
        return false;
    }
    function OpenViewWindow(Id) {
        OpenWindow("/crm/Opportunity/OpportunityView.aspx?OpportunityID=" + Id, 1200, 660);

        return false;
    }

    function createXMLRequest() {
        var xmlHttp = false;
        try {
            xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch (e) {
            try {
                xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
            }
            catch (E) {
                xmlHttp = false;
            }
        }
        if (!xmlHttp && typeof XMLHttpRequest != 'undefined') {
            xmlHttp = new XMLHttpRequest();
        }
        return xmlHttp;
    }

    //ajax请求数据，url：请求地址；CallbackFunc(status, responseText)：请求后回调函数
    function AjaxRequest(url, CallbackFunc) {
        var xmlHttp = createXMLRequest();
        xmlHttp.onreadystatechange = function () {
            if (xmlHttp.readyState == 4) {
                if (CallbackFunc != null && CallbackFunc != undefined) {
                    if (xmlHttp.status == 200) {
                        var rel = xmlHttp.responseText;
                        CallbackFunc(200, rel);
                    }
                    else {
                        CallbackFunc(xmlHttp.status, "");
                    }
                }
                delete xmlHttp;
                xmlHttp = null;
            }
        }
        xmlHttp.open("GET", url, true);
        xmlHttp.send(null);
    }

    //获取返回原始页面视图状态的URL
    function getRestoreUrl(url) {
        var RestoreUrl = url;
        if (RestoreUrl.indexOf("restore=1") == -1) {
            if (RestoreUrl.indexOf("?") == -1)
                RestoreUrl = url + "?restore=1";
            else
                RestoreUrl = url + "&restore=1";
        }
        return RestoreUrl;
    }

    function AddOpp() {
        OpenDialog("/crm/opportunity/opportunityEdit.aspx?CustomerId=" + "<%=CustomerId %>", "新增商机");
        return false;
    }

</script>
<div class="buttons-bar" style="margin-bottom: 10px;">
    <asp:Button ID="btnAdd" runat="server" Text="新增" CssClass="btn_77px" />
    <asp:Button ID="btnAllot" runat="server" Text="分配" OnClick="btnAllot_Click" CssClass="btn_77px" />
    <asp:Button ID="btnDel" runat="server" Text="删除" OnClick="btnDel_Click" CssClass="btn_77px" />
</div>
<asp:GridView ID="gvOpportunity" runat="server" AutoGenerateColumns="False" DataKeyNames="OpportunityID,TrackUserID,CustomerID"
    OnRowDataBound="gvOpportunity_RowDataBound" OnRowCommand="gvOpportunity_RowCommand"
    PageSize="20">
    <HeaderStyle Wrap="False" />
    <Columns>
        <asp:TemplateField>
            <HeaderTemplate>
                <asp:CheckBox ID="chkAll" runat="server" onclick="selectAll(this);" />
            </HeaderTemplate>
            <ItemTemplate>
                <asp:CheckBox ID="CB_SelectID" runat="server" />
            </ItemTemplate>
            <ItemStyle Width="20px" />
        </asp:TemplateField>
        <asp:BoundField DataField="OpportunityID" HeaderText="编号" Visible="false">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:TemplateField HeaderImageUrl="~/images/mark15.gif">
            <ItemTemplate>
                <asp:Image ID="imgHotLevel" runat="server" />
            </ItemTemplate>
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
        </asp:TemplateField>
        <asp:TemplateField HeaderText="商机名称">
            <ItemTemplate>
                <span title='<%#DataBinder.Eval(Container.DataItem,"Topic")%>'>
                    <asp:LinkButton ID="lbtnView" runat="server">
                        <asp:Label ID="lblTopic" runat="server"></asp:Label>
                    </asp:LinkButton>
                </span>
            </ItemTemplate>
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Left" />
        </asp:TemplateField>
        <asp:TemplateField HeaderText="客户名称" Visible="false">
            <ItemTemplate>
                <asp:Image ID="Image1" runat="server" Width="16" Height="16" />
                <span title='<%#DataBinder.Eval(Container.DataItem,"CustomerName")%>'>
                    <asp:LinkButton ID="lnkbtnView" runat="server"></asp:LinkButton>
                </span>
            </ItemTemplate>
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Left" />
        </asp:TemplateField>
        <asp:BoundField DataField="Probability" HeaderText="金额">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:BoundField DataField="Probability" HeaderText="可能性" DataFormatString="{0}%"
            HtmlEncode="False">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:BoundField DataField="PhaseName" HeaderText="销售进程">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:TemplateField HeaderText="负责人">
            <ItemTemplate>
                <asp:Label ID="lblTrackUserID" runat="server" Text=''></asp:Label>
            </ItemTemplate>
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
        </asp:TemplateField>
        <asp:TemplateField HeaderText="状态">
            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
            <ItemStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="lblState" runat="server"></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:BoundField DataField="CreateDate" HeaderText="创建日期" DataFormatString="{0:yyyy-MM-dd}"
            HtmlEncode="False">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:TemplateField HeaderText="操作">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:LinkButton ID="lbtnEdit" runat="server" CausesValidation="false">[编辑]</asp:LinkButton>
                <asp:LinkButton ID="lbtnManage" runat="server" CommandName="Track2" CausesValidation="false">[浏览]</asp:LinkButton>
                <asp:LinkButton ID="lbtnTrack" runat="server" CommandName="Track" CausesValidation="false"
                    Visible="false">[跟踪]</asp:LinkButton>
            </ItemTemplate>
        </asp:TemplateField>
    </Columns>
</asp:GridView>
<div class="pager-bar">
    <webdiyer:AspNetPager ID="plOpportunity" runat="server" AlwaysShow="True" Direction="LeftToRight"
        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
        OnPageChanged="plOpportunity_PageChanged" PrevPageText="[上一页]" ShowCustomInfoSection="Left"
        Width="100%" PageSize="20">
    </webdiyer:AspNetPager>
</div>
<div class="buttons-bar">
    <font style="color: Red;">&nbsp;&nbsp;图片旗子意思：</font><img src="/images/mark1.gif"
        alt="很重要" />很重要&nbsp;&nbsp;<img src="/images/mark3.gif" alt="重要" />重要
</div>
