﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="CustomerServiceList.ascx.cs"
    Inherits="OAWeb.UserControls.CustomerServiceList" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>

    <asp:GridView ID="gvOpportunity" runat="server" AutoGenerateColumns="False" DataKeyNames="IssueId"
        OnRowDataBound="gvOpportunity_RowDataBound" OnRowCommand="gvOpportunity_RowCommand"
        PageSize="20">
        <HeaderStyle Wrap="False" />
        <Columns>
            <asp:TemplateField>
                <HeaderTemplate>
                    <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                </HeaderTemplate>
                <ItemTemplate>
                    <input runat="server" id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("IssueId")%>' />
                </ItemTemplate>
                <ItemStyle Width="20px" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="标题">
                <ItemTemplate>
                    <a href="" id="LinkView" runat="server">
                        <%# Eval("title") %></a>
                </ItemTemplate>
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="时间期限">
                <ItemTemplate>
                    <%# Eval("TimePlanEnd")%>
                </ItemTemplate>
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="执行人">
                <ItemTemplate>
                    <%# OACore.Caches.UsersCache.Instance.GetNickName(ParentPage.ObjToInt(Eval("AssigneeId")))%>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="状态">
                <ItemTemplate>
                    <asp:Label ID="Label1" runat="server" Text='<%# GetIssueStatusText(DataBinder.Eval(Container.DataItem,"IssueStatus").ToString()) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="创建人">
                <ItemTemplate>
                    <%# OACore.Caches.UsersCache.Instance.GetNickName(ParentPage. ObjToInt(Eval("CreateById")))%>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="编辑">
                <ItemTemplate>
                    <a id="LinkEdit" runat="server" href="javascript:void(0)">编辑</a>
                    <asp:LinkButton ID="lnkbtnDelete" runat="server" OnClientClick="return confirm('确定要删除?')"
                        CommandName="Del" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"IssueID").ToString()%>'>删除</asp:LinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    <div class="pager-bar">
        <webdiyer:AspNetPager ID="plOpportunity" runat="server" AlwaysShow="True" Direction="LeftToRight"
            FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
            OnPageChanged="plOpportunity_PageChanged" PrevPageText="[上一页]" ShowCustomInfoSection="Left"
            Width="100%" PageSize="20">
        </webdiyer:AspNetPager>
    </div>
