﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ActionList.ascx.cs"
    Inherits="OAWeb.UserControls.ActionList" EnableViewState="true" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<script language="javascript" type="text/javascript">
    /*编辑*/
    function OpenWin(ActionID) {
        var Url = "/crm/action/ActionEdit.aspx?ActionID=" + ActionID;
        return OpenDialog(Url, "");
    }
</script>

<asp:GridView ID="gvAction" runat="server" AutoGenerateColumns="False" DataKeyNames="ActionID"
    OnRowCommand="gvAction_RowCommand" OnRowDataBound="gvAction_RowDataBound">
    <HeaderStyle CssClass="title" Wrap="False" />
     <Columns>
                                <asp:TemplateField>
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <input type="checkbox" id="chkItem" value="<%# Eval("ActionId") %>" />
                                    </ItemTemplate>
                                    <ItemStyle Width="20px" />
                                </asp:TemplateField>
                                <asp:BoundField DataField="ActionID" HeaderText="编号" Visible="false">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                </asp:BoundField>
                                
                               
                                <asp:TemplateField HeaderText="主题">
                                    <ItemTemplate>
                                        <span title='<%#DataBinder.Eval(Container.DataItem,"Topic").ToString()%>'>
                                            <asp:LinkButton ID="View" runat="server" CausesValidation="false" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"ActionID").ToString()%>'
                                                CommandName="lbtView"><%# Eval("Topic").ToString().Length > 10 ? Eval("Topic").ToString().Substring(0, 10) + "..." : Eval("Topic").ToString()%></asp:LinkButton>
                                        </span>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:TemplateField>
                              

                                <asp:TemplateField HeaderText="对方号码">
                                    <ItemStyle HorizontalAlign="Center" />
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <span id="spNumber" runat="server"><%# Eval("ActionTypeInfo") %></span>
                                        <span id="spInfo" runat="server"></span>
                                        
                                    </ItemTemplate>
                                </asp:TemplateField>

                                <asp:TemplateField HeaderText="类型">
                                    <ItemStyle HorizontalAlign="Center" />
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:Label ID="lblIsIn" runat="server" Text=''></asp:Label> ( <%# Eval("ActionTypeName")%> )
                                    </ItemTemplate>
                                </asp:TemplateField>

                                <asp:TemplateField HeaderText="开始时间">
                                    <ItemStyle HorizontalAlign="Center" />
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:Label ID="lblTime" runat="server" Text=''></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                
                                <asp:BoundField DataField="SpendTime" HeaderText="时长(分)">
                                    <ItemStyle HorizontalAlign="Left" />
                                </asp:BoundField>
                                <asp:BoundField DataField="RealName" HeaderText="员工" />
                                
                                <asp:TemplateField HeaderText="操作">
                                    <HeaderStyle HorizontalAlign="Center" />
                                    <ItemStyle HorizontalAlign="Center" />
                                    <ItemTemplate>
                                        <asp:LinkButton ID="LinkPlay" runat="server" Visible="false">播放</asp:LinkButton>
                                        <asp:LinkButton ID="Edit" runat="server" CausesValidation="false" CommandArgument='<%#DataBinder.Eval(Container.DataItem,"ActionID").ToString()%>'
                                            CommandName="lbtEdit">编辑</asp:LinkButton>
                                        <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
</asp:GridView>
<div class="pager-bar">
    <webdiyer:AspNetPager ID="plAction" runat="server" AlwaysShow="True" Direction="LeftToRight"
        FirstPageText="[首页]" HorizontalAlign="Right" LastPageText="[末页]" NextPageText="[下一页]"
        PrevPageText="[上一页]" ShowCustomInfoSection="Left" Width="100%" PageSize="20"
        OnPageChanged="plAction_PageChanged">
    </webdiyer:AspNetPager>
</div>
<asp:HiddenField ID="hdfSql" runat="server" />
