﻿<%@ Page Language="C#" MasterPageFile="~/User/Main.Master" AutoEventWireup="true"
    CodeBehind="OrderView.aspx.cs" Inherits="OAWeb.User.OrderView" %>

<%@ Register Src="/UserControls/UserLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <style type="text/css">
        .right
        {
            color: #000000;
        }
        .table_list th
        {
            padding: 0px;
        }
        .order_State .table_list td
        {
            line-height: normal;
        }
        .order_product td
        {
            background-color: #fff;
            padding: 4px;
        }
        .tbInfo td
        {
            padding: 5px;
            text-align: left;
        }
        .order_widget
        {
        	padding:20px;
        }
        
        .order_widget table
        {
        	 margin-left:30px;
        	 width:80%;
        }
        .rightOrder
        {
        	text-align:right;
        }
        .table_list th 
        {
        	padding:5px;
        }

    </style>
    <div class="w main">
        <div class="right">
            <div class="tabs">
                <div class="tab_content">
                    <div class="order_widget" style="margin: 0px;">
                        <div class="order_State">
                            <strong class="fonts ">订单号：<asp:Literal ID="ltlOrderSN" runat="server"></asp:Literal></strong> 
                            <strong class="fonts " style=" margin-left:30px;">订单状态：<asp:Label  ID="lblOrderState" runat="server" Text=""></asp:Label></strong>
                            <br /><br />
                            <img alt="立即支付" src="/user/images/v5_icon_pay.jpg" />
                        </div>
                    </div>
                    <div class="order_widget">
                        <div class="order_State">
                            <strong class="fonts ">收货地址</strong>
                            <table border="0" cellspacing="1" cellpadding="0" class="order_product" style="margin-top: 10px;
                                 background-color: #E4E4E4">
                                <tr>
                                    <td>
                                        收货人：<asp:Literal ID="ltlShipTo" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        手机：<asp:Literal ID="ltlMobile" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        电话：<asp:Literal ID="ltlTelPhone" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        邮编：<asp:Literal ID="ltlPostCode" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        收货地址：<asp:Literal ID="ltlArea" runat="server"></asp:Literal>
                                        <asp:Literal ID="ltlAddress" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="order_widget">
                        <div class="order_State">
                            <strong class="fonts ">送货方式</strong>
                            <table border="0" cellspacing="1" cellpadding="0" class="order_product" style="margin-top: 10px;
                                 background-color: #E4E4E4">
                                <tr>
                                    <td>
                                        配送方式：<asp:Literal ID="ltlShippingName" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        买家留言：<asp:Literal ID="ltlPostscript" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="order_widget">
                        <div class="order_State">
                            <strong class="fonts ">支付相关</strong>
                            <table border="0" cellspacing="0" cellpadding="0" style="margin: 10px;">
                                <tr>
                                    <td>
                                        支付方式：
                                        <asp:Literal ID="ltlPayMothodName" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="order_widget">
                        <div class="order_State">
                            <strong class="fonts ">商品清单</strong>
                            <table class="table_list" cellspacing="0" cellpadding="0" border="0" id="ctl00_ContentPlace_gvData"
                                style="border-collapse: collapse; margin-top: 10px; width:100%; margin-left:10px;">
                                <tr>
                                    <th scope="col" style=" width:150px;">
                                        商品货号
                                    </th>
                                    <th scope="col" style=" width:150px;">
                                        商品名称
                                    </th>
                                    <th scope="col">
                                        成交价
                                    </th>
                                    <th scope="col">
                                        购买数量
                                    </th>
                                    <th scope="col">
                                        优惠
                                    </th>
                                    <th scope="col">
                                        发货数量
                                    </th>
                                    <th scope="col">
                                        总价
                                    </th>
                                </tr>
                                <asp:Repeater ID="rptData" runat="server" OnItemDataBound="rptData_ItemDataBound">
                                    <ItemTemplate>
                                        <tr align="left" class="TrOrderItem">
                                            <td>
                                                <%#Eval("ProductSN")%>
                                            </td>
                                            <td>
                                                <%#Eval("ProductName")%>
                                                <span class="red">
                                                    <%# Eval("TypeText").ToString() == "续单" ? "(续单)" : ""%></span><br />
                                                <%# Eval("SN").ToString() == "" ? "" : ("(序列号：" + Eval("SN").ToString() + ")")%>
                                            </td>
                                            <td class="product_price">
                                                <%#Eval("RealPrice", "￥{0:F2}")%>
                                            </td>
                                            <td>
                                                <%#Eval("PayNum")%>
                                                <%# Eval("Unit") %>
                                            </td>
                                            <td>
                                                <%#Eval("DiscountFee")%><br />
                                                <asp:Label ID="lblAdjustFee" runat="server" Text=""></asp:Label>
                                            </td>
                                            <td>
                                                <%#Eval("SendNum")%>
                                                <%# Eval("Unit") %>
                                            </td>
                                            <td>
                                                <%#Eval("Amount","￥{0:F2}")%>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                                <tr>
                                    <td colspan="7" style="text-align: right; padding-right: 20px; background-color: #FAFAF8">
                                        产品总价：￥<asp:Label ID="lblPAmount" runat="server" CssClass="red" Text="0.00"></asp:Label>
                                    </td>
                                </tr>
                            </table>
                            <table border="0" cellspacing="1" cellpadding="0" class="order_product" style="margin-top: 10px;
                               width:100%; margin-left:10px;   background-color: #E4E4E4">
                                <tr>
                                    <td class="rightOrder ">
                                        运费：
                                    </td>
                                    <td style="width: 100px">
                                        ￥<asp:Literal ID="ltlFreight" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="rightOrder ">
                                        保险费：
                                    </td>
                                    <td style="width: 100px">
                                        ￥<asp:Literal ID="ltlInsurance" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="rightOrder ">
                                        发票税：
                                    </td>
                                    <td style="width: 100px">
                                        ￥<asp:Literal ID="ltlTax" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="rightOrder ">
                                        支付手续费：
                                    </td>
                                    <td style="width: 100px">
                                        ￥<asp:Literal ID="ltlPayFee" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="rightOrder ">
                                        <span class="red">订单总金额：</span>
                                    </td>
                                    <td style="width: 100px">
                                        <span class="red">￥<asp:Literal ID="ltlOrderTotal" runat="server"></asp:Literal></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="rightOrder ">
                                        <span class="green">已支付金额：</span>
                                    </td>
                                    <td style="width: 100px">
                                        <span class="green">￥<asp:Literal ID="ltlPayedAmount" runat="server"></asp:Literal></span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="left">
            <uc1:TaskNav ID="TaskNav1" runat="server" />
        </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $(".tab_handles span").click(function () {
                var hideIndex = $(".tab_handles .current").index();
                $(".tab_handles span").removeClass("current");
                $(this).addClass("current");
                $(".tab_contents .tab_content:eq(" + hideIndex + ")").hide();
                $(".tab_contents .tab_content:eq(" + $(this).index() + ")").show();
            })
        })
    </script>
</asp:Content>
