﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/User/Main.Master"
    EnableViewState="true" CodeBehind="CustomerList.aspx.cs" Inherits="OAWeb.User.CustomerList" Theme="Default" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/UserLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <div class="w main">
        <div class="right">
            <table class="data_title"  style=" border:none">
                <tr>
                    <td class="data_caption">
                        <asp:Label ID="lblCaption" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td class="data-field">
                        <table width="60%">
                            <tr>
                                <td class="tb-label">
                                    &nbsp;<asp:DropDownList ID="ddlField" runat="server">
                                        <asp:ListItem>客户名称</asp:ListItem>
                                        <asp:ListItem>客户电话</asp:ListItem>
                                        <asp:ListItem>联系人姓名</asp:ListItem>
                                        <asp:ListItem>联系人电话</asp:ListItem>
                                        <asp:ListItem>联系人手机</asp:ListItem>
                                        <asp:ListItem>联系人QQ</asp:ListItem>
                                    </asp:DropDownList>
                                </td>
                                <td class="tb-editor" nowrap="nowrap">
                                    <asp:TextBox ID="txtCustomer" runat="server" Width="200px"></asp:TextBox>
                                    <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" TabIndex="1"
                                        Text=" 查 询 " CssClass="btn_77px" />
                                    <asp:Button ID="btnAdvanceSearch" Visible="false" runat="server" Text="高级查询" CssClass="btn_77px" />
                                </td>
                                <td class="tb-label">
                                </td>
                                <td class="tb-editor" nowrap="nowrap">
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <div class="buttons-bar" style="margin-bottom: 10px;  display:none; ">
                <table class="w100p" style="width: 100%">
                    <tr>
                        <td align="left">
                            <asp:Button ID="btnAddCustomer" runat="server" Text="新建客户" CssClass="btn_77px" />
                            <asp:Button ID="btnAddAction" runat="server" Text="新建活动" CssClass="btn_77px" Visible="false" />
                            <asp:Button ID="btnAllot" runat="server" Text="分 配" OnClick="btnAllot_Click" CssClass="btn_77px" />
                            <asp:Button ID="btnBack" runat="server" OnClick="btnBack_Click" Text="归 还" CssClass="btn_77px" />
                            <input type="button" value="移动到" class="btn_77px" onclick="MoveCustomer()" />
                            <asp:Button ID="btnDelCustomer" runat="server" OnClick="btnDelCustomer_Click" Text="删 除"
                                CssClass="btn_77px" />
                            <asp:Button ID="btnAddFavorite" runat="server" Text="加入收藏" CssClass="btn_77px" OnClick="btnAddFavorite_Click"
                                Visible="false" />
                            <asp:Button ID="btnDelFavorite" runat="server" Text="删除收藏" CssClass="btn_77px" OnClick="btnDelFavorite_Click"
                                Visible="false" />
                            <asp:Button ID="btnLock" runat="server" Text="锁 住" CssClass="btn_77px" OnClick="btnLock_Click" />
                            <asp:Button ID="btnUnLock" runat="server" Text="解 锁" CssClass="btn_77px" OnClick="btnUnLock_Click" />
                            <asp:Button ID="btnSendMsg" runat="server" Text="群发信息" CssClass="btn_77px" OnClientClick="SendMessage();return false;" />
                            <input runat="server" id="btnAddNewCustomer" type="button" value="合并客户" class="btn_77px"
                                onclick="AddNewCustomer()" />
                        </td>
                        <td align="right">
                            <asp:DropDownList ID="ddlSort" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlSort_SelectedIndexChanged">
                                <asp:ListItem Value="Customer.CreateDate desc">创建时间</asp:ListItem>
                                <asp:ListItem Value="Customer.last_login desc">活跃时间</asp:ListItem>
                                <asp:ListItem Value="Customer.ModifyDate desc">修改时间</asp:ListItem>
                                <asp:ListItem Value="Customer.NextContactTime desc">下次联系</asp:ListItem>
                                <asp:ListItem Value="Customer.LastTradeDate desc">交易时间</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                </table>
            </div>
            <asp:GridView ID="gvCustomerList" runat="server" AutoGenerateColumns="False" DataKeyNames="CustomerID"
                OnRowCommand="gvCustomerList_RowCommand" OnRowDataBound="gvCustomerList_RowDataBound"
                PageSize="20">
                <HeaderStyle Wrap="False" />
                <Columns>
                    <asp:TemplateField Visible="false">
                        <HeaderTemplate>
                            <asp:CheckBox ID="chkAll" runat="server" onclick="SelectAll(this);" />
                        </HeaderTemplate>
                        <ItemTemplate>
                            <input runat="server" id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("CustomerID")%>' />
                        </ItemTemplate>
                        <ItemStyle Width="20px" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="CustomerID" HeaderText="编号" Visible="false">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" Width="30px" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="" Visible="false">
                        <ItemStyle HorizontalAlign="Left" Width="30px" />
                        <ItemTemplate>
                            <span id="spLock" runat="server"></span><span id="spImg" runat="server"></span>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="客户相关信息">
                        <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <div style="margin-top: 0px; float: left; width: 100%; color: #666666; font-size: 14px;
                                text-align: center; line-height: 20px;">
                                <asp:Image ID="Image1" runat="server" Width="16" Height="16" />
                                <asp:LinkButton ID="lnkbtnView" runat="server" CausesValidation="false" CommandName="lbtView"
                                    CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'><strong><%# Eval("CustomerName").ToString()%></strong></asp:LinkButton>
                                <span style="font-size: 12px; display:none">(<strong>种类:</strong><asp:Label ID="lblBizTypeName"
                                    runat="server"></asp:Label>)
                                    <br />
                                    <strong>行业：</strong><asp:Label ID="lblIndustryName" runat="server" Text='<%# Eval("IndustryName") %>'></asp:Label>&nbsp;
                                    <strong>联系人：</strong><asp:Label ID="lblContactMan" runat="server" Text='<%# Eval("MainContactName") %>'></asp:Label>&nbsp;
                                    <strong>电话：</strong><asp:Label ID="lblTelephone" runat="server" ForeColor="blue"
                                        Text='<%# DataBinder.Eval(Container.DataItem, "Telephone")%>'></asp:Label>
                                    <asp:Label ID="lbllLayAside" runat="server"></asp:Label><br />
                                    <%# ObjToStr(Eval("NextContactTime")).Contains("0001") ? "" : "下次联系时间：" + Eval("NextContactTime")%>
                                </span>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="CityName" HeaderText="城市">
                        <ItemStyle Width="60px" />
                    </asp:BoundField>
                    <asp:BoundField DataField="StageName" HeaderText="阶段" Visible="False">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                        <ItemTemplate>
                            <asp:Label ID="lblState" runat="server" Text="Label"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="级别">
                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                        <ItemTemplate>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="交易数">
                        <ItemStyle HorizontalAlign="Center" Width="40px" />
                        <ItemTemplate>
                            <%# ObjToStr(Eval("OrderCount")) == "0" ? "" : Eval("OrderCount")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="最近交易">
                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                        <ItemTemplate>
                            <%# ObjToStr(Eval("LastTradeDate")).Contains("0001") ? "" :Convert.ToDateTime(Eval("LastTradeDate")).ToShortDateString()%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="业务负责" Visible="false">
                        <HeaderStyle HorizontalAlign="Center" Width="60px"></HeaderStyle>
                        <ItemTemplate>
                            <asp:Label ID="lblOwnerName" runat="server" Text='<%#Eval("OwnerName") %>'></asp:Label>
                            <asp:Label ID="lblOwnerID" runat="server" Text='<%#Eval("OwnerID") %>' Visible="false"></asp:Label>
                            <asp:LinkButton ID="lnkbtnTrack" runat="server" CausesValidation="false" CommandName="cmdTrack"
                                CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'>领用</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="创建日期">
                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                        <ItemTemplate>
                            <%# ObjToStr(Eval("CreateDate")).Contains("0001") ? "" : Convert.ToDateTime(Eval("LastTradeDate")).ToShortDateString()%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    
                 
                    <asp:TemplateField HeaderText="操作">
                        <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                        <ItemTemplate>
                        
                        <a href='/User/UserEdit.aspx?CustomerId=<%# Eval("CustomerId") %>'>编辑</a>
                            <asp:LinkButton ID="lnkbtnEdit" Visible="false" runat="server" CausesValidation="false" CommandName="cmdEdit"
                                CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>'>编辑</asp:LinkButton>
                            <asp:LinkButton ID="lnkbtnDelete" runat="server" CausesValidation="false" CommandName="cmdDelete"
                                CommandArgument='<%#DataBinder.Eval(Container.DataItem,"CustomerID").ToString()%>' >删除</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <div class="pager-bar">
                <webdiyer:AspNetPager ID="plCustomer" runat="server" OnPageChanged="plCustomer_PageChanged"
                    PageSize="20">
                </webdiyer:AspNetPager>
            </div>
            <asp:HiddenField ID="hdfSql" runat="server" />
            <asp:HiddenField ID="hdfOwnerId" runat="server" />
        </div>
        <div class="left">
            <uc1:TaskNav ID="TaskNav1" runat="server" />
        </div>
    </div>
</asp:Content>
