﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/User/Main.Master"
    EnableViewState="true" CodeBehind="AddressList.aspx.cs" Inherits="OAWeb.User.AddressList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="/UserControls/UserLeft.ascx" TagName="TaskNav" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <script>
        function OpenAddressDialog(AddressId) {
            var Url = "/User/AddressEdit.aspx?CId=<%=UserCustomerID %>&type=add&Id="+AddressId;
            OpenDialog(Url, "收货地址");
            return false;

        }
    </script>
    <div class="w main">
        <div class="right">
            <table class="data_title" cellspacing="3"  style=" border:none">
                <tr>
                    <td class="data_caption" style="vertical-align: middle;">
                        收货地址
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        <a href="javascript:void(0)" onclick="OpenAddressDialog(0)">添加地址</a>
                    </td>
                </tr>
            </table>
            <div class="list">
                <asp:GridView ID="rptData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                    OnRowDataBound="rptData_RowDataBound" onrowcommand="rptData_RowCommand">
                    <RowStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <Columns>
                        <asp:TemplateField HeaderText="收货人">
                            <ItemTemplate>
                                <%# Eval("ShipTo")%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="地址">
                            <ItemTemplate>
                                <%#Eval("Address")%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="ZipCode" HeaderText="邮编"></asp:BoundField>
                        <asp:BoundField DataField="TelePhone" HeaderText="电话"></asp:BoundField>
                        <asp:BoundField DataField="Mobile" HeaderText="手机"></asp:BoundField>
                        <asp:BoundField HeaderText="交易状态" />
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <a href="javascript:void(0)" onclick='OpenAddressDialog(<%# Eval("Id") %>);return false;'>编辑</a>
                                <asp:LinkButton ID="lbtnDel" CommandName="Del" CommandArgument='<%# Eval("Id") %>' runat="server" OnClientClick="return confirm('确定要删除？')">删除</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                        PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                        ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
        <div class="left">
            <uc1:TaskNav ID="TaskNav1" runat="server" />
        </div>
    </div>
</asp:Content>
