﻿<%@ Page Language="C#" MasterPageFile="~/Dialog/DialogMaster.Master" AutoEventWireup="true"
    CodeBehind="SavedSearchList.aspx.cs" Inherits="OAWeb.SearchView.SavedSearchList"
    Theme="Default" EnableViewState="true" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <script language="javascript" type="text/javascript">
        function OpenView(Id, modulename, type) {
            switch (type) {
                case "add":
                    OpenDialog("/SearchView/SavedSearchEdit.aspx?modulename=" + modulename, "新建视图");
                    break;
                case "edit":
                    OpenDialog("/SearchView/SavedSearchEdit.aspx?modulename=" + modulename + "&Id=" + Id, "编辑视图");
                    break;
            }
            return false;
        }        
    </script>
    <div style="width: 600px; height: 400px; overflow-y: scroll; padding: 10px;">
        <table class="search-view">
            <tr>
                <td class="data-field">
                    视图名称：<asp:TextBox ID="txtSearchViewTitle" runat="server"></asp:TextBox>
                    &nbsp;系统视图：<asp:DropDownList ID="ddlIsSystem" runat="server">
                        
                        <asp:ListItem Value="1">系统视图</asp:ListItem>
                        <asp:ListItem Value="0">自定义视图</asp:ListItem>
                        <asp:ListItem Value="-1">所有视图</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;<asp:Button ID="btnSearch" runat="server" Text=" 搜 索 " OnClick="btnSearch_Click" />
                </td>
            </tr>
        </table>
        <div class="buttons-bar" style="margin-bottom: 10px; margin-top: 10px;">
            <asp:Button ID="lnkbtnNew" runat="server" Text="新建" CssClass="btn_77px" />
            <asp:Button ID="lnkbtnDel" runat="server" Text="删除" OnClick="lnkbtnDel_Click" CssClass="btn_77px" />
            <input type="button" onclick="CloseReload();" value="返回" class="btn_77px" />
        </div>
        <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" OnRowCommand="gvData_RowCommand"
            OnRowDataBound="gvData_RowDataBound" DataKeyNames="Id">
            <RowStyle Height="25px" HorizontalAlign="Center" />
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <HeaderTemplate>
                        <input name="chkHeader" onclick="javascript:selectAll(this);" type="checkbox" value="chkHeader" />
                    </HeaderTemplate>
                    <ItemTemplate>
                        <input runat="server" id="chkItem" name="chkItem" type="checkbox" value='<%#Eval("Id")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Title" HeaderText="视图名称">
                    <ItemStyle HorizontalAlign="Left" />
                </asp:BoundField>
                <asp:BoundField DataField="CreatedUserId" HeaderText="创建人"></asp:BoundField>
                <asp:BoundField DataField="CreatedDate" HeaderText="创建时间" DataFormatString="{0:d}">
                </asp:BoundField>
                <asp:BoundField DataField="IsSystem" HeaderText="系统视图"></asp:BoundField>
                <asp:BoundField DataField="IsDisplay" HeaderText="显示"></asp:BoundField>
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                        <asp:TextBox ID="txtOrder" runat="server" Text='<%#Eval("Order") %>' Width="40px"
                            OnTextChanged="txtSortOrder_TextChanged" AutoPostBack="true"></asp:TextBox>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemTemplate>
                        <asp:HyperLink ID="hyplnkEdit" runat="server">编辑</asp:HyperLink>
                        <asp:LinkButton ID="lbtnDel" runat="server" CommandName="cmdDelete" CommandArgument='<%#Eval("Id")%>'
                            OnClientClick="return confirm('确定要删除!')">删除</asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <div class="pager-bar">
            <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                PageSize="10" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                ShowBoxThreshold="10" SubmitButtonText="跳 转" AlwaysShow="True" OnPageChanged="pager_PageChanged">
            </webdiyer:AspNetPager>
        </div>
    </div>
</asp:Content>
