﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="SMSTaskList.aspx.cs" Inherits="OAWeb.SMSGateway.SMSTaskList" %>

<%@ Register Src="../UserControls/SMSGatewayNav.ascx" TagName="SMSGatewayNav" TagPrefix="uc1" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体左侧-->
    <table id="plc_profile" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td class="main_left">
                <uc1:SMSGatewayNav ID="SMSGatewayNav1" runat="server" />
            </td>
            <td class="main_center">
                <!--主体-->
                <div class="page_main">
                    <div class="page_content">
                        <div class="tabs">
                            <div class="tab_handles">
                                <span class="<%=SmsType == 0 ? "current":""%>">分触发型短信队列</span> <span t="1" class="<%=SmsType == 1 ? "current":""%>">
                                    推广型短信队列</span>
                            </div>
                            <table class="data_title" cellspacing="3">
                                <tr>
                                    <td class="data_field">
                                        客户：<asp:HiddenField ID="hdfCustomerId" runat="server" />
                                        <asp:TextBox ID="txtCustomerName" runat="server" CssClass="text_box width200" ReadOnly="True"></asp:TextBox>&nbsp;<asp:Button
                                            ID="btnSelect" runat="server" Text="选择" OnClientClick="OpenRadioDialog('/Dialog/CustomerDialog.aspx','选择客户',CallRadioFun);return false;" />&nbsp;<input
                                                type="button" value="清除" onclick="ClearCsutomer();" />
                                                <asp:DropDownList ID="ddlState"
                                                    runat="server">
                                                    <asp:ListItem>所有</asp:ListItem>
                                                    <asp:ListItem Value="wait">待发送</asp:ListItem>
                                                    <asp:ListItem Value="send">已发送</asp:ListItem>
                                                    <asp:ListItem Value="fail">发送失败</asp:ListItem>
                                                </asp:DropDownList>
                                        <asp:Button ID="btnSearch" runat="server" Text="查  询" class="btn_77px" />
                                        <asp:Button ID="btnDelete" runat="server" Text="删除" CssClass="btn_77px" />
                                        <asp:Button ID="btnSend" runat="server" Text="重发" CssClass="btn_77px" />
                                    </td>
                                </tr>
                            </table>
                            <div class="list">
                                <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                                    GridLines="None" CellPadding="0" CssClass="table_list" EnableModelValidation="True"
                                    OnRowDataBound="gvData_RowDataBound">
                                    <RowStyle HorizontalAlign="Left" />
                                    <Columns>
                                        <asp:TemplateField HeaderText="编号">
                                            <HeaderTemplate>
                                                <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                                            </HeaderTemplate>
                                            <ItemTemplate>
                                                <input id="chkItem" type="checkbox" value="<%#Eval("Id") %>" />
                                            </ItemTemplate>
                                            <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                                            <ItemStyle HorizontalAlign="Center" Width="10px"></ItemStyle>
                                        </asp:TemplateField>
                                        <asp:BoundField DataField="CustomerName" HeaderText="客户名称"></asp:BoundField>
                                        <asp:BoundField DataField="Mobile" HeaderText="手机号码" />
                                        <asp:BoundField DataField="" HeaderText="内容"></asp:BoundField>
                                        <asp:BoundField DataField="StateName" HeaderText="发送状态" />
                                        <asp:BoundField DataField="Remark" HeaderText="反馈信息" />
                                        <asp:BoundField DataField="CreateDate" HeaderText="创建时间" />
                                        <asp:BoundField DataField="CreateMan" HeaderText="创建人" />
                                        <asp:TemplateField HeaderText="操作">
                                            <ItemTemplate>
                                                <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                                <div class="pager-bar">
                                    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                                        PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                                        ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                                    </webdiyer:AspNetPager>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        $(document).ready(function () {
            $(".tab_handles span").click(function () {
                if ($(this).attr("t") == "1") window.location.href = "SMSTaskList.aspx?type=1";
                else window.location.href = "SMSTaskList.aspx";
            })
        })
        function CallRadioFun(text, value) {
            $("#<%=hdfCustomerId.ClientID %>").val(value);
            $("#<%=txtCustomerName.ClientID %>").val(text);
        }
        function ClearCsutomer() {
            $("#<%=hdfCustomerId.ClientID %>").val("");
            $("#<%=txtCustomerName.ClientID %>").val("");
        }
    </script>
</asp:Content>
