﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" Theme="Default" AutoEventWireup="true"
    CodeBehind="ModuleList.aspx.cs" Inherits="OAWeb.Modules.ModuleList" EnableViewState="true" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">

    <script language="javascript" type="text/javascript"> 
    function OpenModule(Id,type){
	  switch(Id, type)
	  {
	    case "add":
	        OpenDialog("/Modules/ModuleEdit.aspx", "模块添加");
	       break;
	    case "edit":
	        OpenDialog("/Modules/ModuleEdit.aspx?Id=" + Id, "模块修改");
	       break;
	    case "import":
	        OpenDialog("/Modules/ModuleExport.aspx", "导入表字段");
	       break;
	  }
	  return false;
    }

    function OpenFieldMeta(Id) {
        OpenDialog("/Dialog/FieldMetaList.aspx?Id="+Id, "编辑模块字段");
        return false;
    }

    function Export()
    {
       ExportImport('export');
    }
     function Import()
    {
       ExportImport('import');
    }
    function ExportImport(type)
    {
       var Url = "/Modules/ExportImport.aspx?type=" + type + "&random=" + Math.random();
       AjaxRequest(Url, function(status,text){
	            if (text.toString().indexOf("msg") != -1)
	            {
	                alert(text.toString().replace("msg:",""));
	            }
	            else
	            {
	                if (type == "export")
	                    alert("导出成功");
	                else
	                    alert("导入成功");
	            }
	        });       
	    return false;
    }
    </script>

    <table class="data_title">
        <tr>
            <td class="data_caption" >
                视图模块
            </td>
        </tr>
        <tr>
            <td class="data-field">
                <table>
                    <tr>
                        <td class="tb-label w80px">
                            模块名称：
                        </td>
                        <td class="tb-editor w100px">
                            <asp:TextBox runat="server" ID="txtModuleName"></asp:TextBox>
                        </td>
                        <td class="tb-editor">
                            <asp:Button runat="server" ID="btnSearch" Text=" 查 询 " OnClick="btnSearch_Click" CssClass="btn_77px"  />
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <div class="buttons-bar" style=" margin:10px">
    <input type="button" class="btn_77px" value="添加" onclick="OpenModule(null,'add');" />
    <input type="button" class="btn_77px" value="导入" onclick="OpenModule(null,'import')" />
    <asp:Button ID="Button1" runat="server" Text="更新缓存" OnClick="lnkbtnUpdateDataCache_Click" CssClass="btn_77px" />
    </div>
    <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" CssClass="tb-listview"
        OnRowCommand="gvData_RowCommand">
        <Columns>
            <asp:BoundField HeaderText="模块名称" DataField="ModuleName" />
            <asp:BoundField HeaderText="显示名称" DataField="DisplayName" />
            <asp:BoundField HeaderText="表名" DataField="TableName" />
            <asp:TemplateField HeaderText="字段设置">
                <ItemTemplate>
                    <a href="javascript:void(0)" onclick=" OpenFieldMeta(<%# Eval("Id") %>)">模块字段 </a>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <a href="javascript:void(0);" onclick="OpenModule(<%#Eval("Id") %>,'edit');">编辑
                    </a>
                    <asp:LinkButton ID="lnkbtnDel" runat="server" CommandName="cmdDel" CommandArgument='<%#Eval("Id") %>'
                        OnClientClick="return confirm('确定要删除?');">删除</asp:LinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <RowStyle BackColor="White" />
    </asp:GridView>
    <div class="pager-bar">
        <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
            PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
            ShowBoxThreshold="10" SubmitButtonText="跳 转" AlwaysShow="True">
        </webdiyer:AspNetPager>
    </div>
</asp:Content>
