if exists (select * from sysobjects where id = OBJECT_ID('[AgentGrade]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [AgentGrade]

CREATE TABLE [AgentGrade] (
[GradeID] [int]  NOT NULL,
[Name] [varchar]  (50) NULL,
[Discount] [numeric]  (18,1) NULL,
[IsDefault] [bit]  NULL,
[Is_Active] [bit]  NULL,
[Remark] [varchar]  (100) NULL)

ALTER TABLE [AgentGrade] WITH NOCHECK ADD  CONSTRAINT [PK_AgentGrade] PRIMARY KEY  NONCLUSTERED ( [GradeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[Attach]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Attach]

CREATE TABLE [Attach] (
[Id] [int]  NOT NULL,
[UserId] [int]  NULL,
[AttachPath] [varchar]  (200) NULL,
[CreateDate] [datetime]  NULL,
[CommentId] [int]  NULL,
[ReplyCommentId] [int]  NULL,
[ProjectId] [int]  NULL,
[IssueId] [uniqueidentifier]  NULL,
[RelateObject] [varchar]  (20) NULL,
[RelateId] [varchar]  (36) NULL,
[AttachTitle] [varchar]  (100) NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[base_FieldMeta]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [base_FieldMeta]

CREATE TABLE [base_FieldMeta] (
[Id] [uniqueidentifier]  NOT NULL,
[Deleted] [bit]  NULL,
[CreatedUserId] [int]  NULL,
[CreatedDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (1) NULL,
[ModifyDate] [datetime]  NULL,
[ModuleId] [int]  NULL,
[ModuleName] [varchar]  (50) NULL,
[Name] [varchar]  (100) NULL,
[Label] [varchar]  (100) NULL,
[DataType] [varchar]  (255) NULL,
[FieldLength] [int]  NULL,
[DefaultValue] [varchar]  (255) NULL,
[EnumTypeId] [int]  NULL,
[IsInsert] [bit]  NULL,
[IsUpdate] [bit]  NULL,
[IsShowEdit] [bit]  NULL,
[IsShowDetail] [bit]  NULL,
[IsShowList] [bit]  NULL,
[IsShowSearch] [bit]  NULL,
[IsSystem] [bit]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[base_SearchForm]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [base_SearchForm]

CREATE TABLE [base_SearchForm] (
[Id] [uniqueidentifier]  NOT NULL,
[Deleted] [bit]  NULL,
[CreatedUserId] [int]  NULL,
[CreatedDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (1) NULL,
[ModifyDate] [datetime]  NULL,
[ViewName] [varchar]  (50) NULL,
[ModuleId] [int]  NULL,
[ModuleName] [varchar]  (50) NULL,
[LabelWidth] [varchar]  (20) NULL,
[FieldWidth] [varchar]  (20) NULL,
[DataColumns] [int]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[base_SearchFormField]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [base_SearchFormField]

CREATE TABLE [base_SearchFormField] (
[Id] [uniqueidentifier]  NOT NULL,
[Deleted] [bit]  NULL,
[CreatedUserId] [int]  NULL,
[CreatedDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (1) NULL,
[ModifyDate] [datetime]  NULL,
[SearchViewId] [uniqueidentifier]  NULL,
[SearchViewName] [varchar]  (50) NULL,
[FieldIndex] [int]  NULL,
[FieldType] [varchar]  (50) NULL,
[FieldName] [varchar]  (100) NULL,
[DataLabel] [varchar]  (100) NULL,
[RelationshipTable] [varchar]  (50) NULL,
[DataTextField] [varchar]  (100) NULL,
[DataValueField] [varchar]  (100) NULL,
[ColSpan] [int]  NULL,
[LinkageControlID] [varchar]  (50) NULL,
[LinkageUrl] [varchar]  (100) NULL,
[DialogUrl] [varchar]  (100) NULL,
[IsChildQuery] [bit]  NULL,
[ChildTable] [varchar]  (50) NULL,
[PrimaryKey] [varchar]  (50) NULL,
[ChildForeignKey] [varchar]  (50) NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[base_ViewModule]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [base_ViewModule]

CREATE TABLE [base_ViewModule] (
[Id] [int]  NOT NULL,
[Deleted] [bit]  NULL,
[CreatedUserId] [int]  NULL,
[CreatedDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (1) NULL,
[ModifyDate] [datetime]  NULL,
[ModuleName] [varchar]  (50) NULL,
[DisplayName] [varchar]  (50) NULL,
[RelativePath] [varchar]  (100) NULL,
[ModuleEnabled] [bit]  NULL,
[TabEnabled] [bit]  NULL,
[IsAdmin] [bit]  NULL,
[TabOrder] [int]  NULL,
[TableName] [varchar]  (30) NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[BaseAnnounce]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseAnnounce]

CREATE TABLE [BaseAnnounce] (
[Title] [varchar]  (200) NULL,
[KeyWord] [varchar]  (200) NULL,
[AnnounceContent] [text]  NULL,
[CreateDate] [datetime]  NULL,
[Publicity] [bit]  NULL,
[CreateUserID] [varchar]  (20) NULL,
[Visible] [bit]  NULL,
[Enable] [bit]  NULL,
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[Id] [int]  NOT NULL,
[AnnounceTypeID] [int]  NULL,
[DepartmentList] [varchar]  (100) NULL,
[AuditMan] [varchar]  (20) NULL,
[AuditDate] [datetime]  NULL,
[CreateUserName] [varchar]  (20) NULL)

ALTER TABLE [BaseAnnounce] WITH NOCHECK ADD  CONSTRAINT [PK_BaseAnnounce] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseAnnounceType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseAnnounceType]

CREATE TABLE [BaseAnnounceType] (
[Id] [int]  NOT NULL,
[TypeName] [varchar]  (50) NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [BaseAnnounceType] WITH NOCHECK ADD  CONSTRAINT [PK_BaseAnnounceType] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseContract]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseContract]

CREATE TABLE [BaseContract] (
[Id] [int]  NOT NULL,
[ContractType] [int]  NULL,
[EmployFileId] [int]  NULL,
[SignedDate] [datetime]  NULL,
[ExpireDate] [datetime]  NULL,
[ProbationDate] [datetime]  NULL,
[CreateDate] [datetime]  NULL,
[ContractContent] [text]  NULL,
[DoUserId] [int]  NULL,
[AnnexFile] [varchar]  (200) NULL)

ALTER TABLE [BaseContract] WITH NOCHECK ADD  CONSTRAINT [PK_BaseContract] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseDepartment]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseDepartment]

CREATE TABLE [BaseDepartment] (
[Id] [int]  NOT NULL,
[FullName] [varchar]  (200) NULL,
[ShortName] [varchar]  (50) NULL,
[ParentId] [int]  NULL,
[ParentPath] [varchar]  (50) NULL,
[OuterPhone] [varchar]  (50) NULL,
[InnerPhone] [varchar]  (50) NULL,
[EmployId] [int]  NULL,
[AssistantEmployId] [varchar]  (100) NULL,
[SortCode] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL,
[Remark] [varchar]  (500) NULL)

ALTER TABLE [BaseDepartment] WITH NOCHECK ADD  CONSTRAINT [PK_BaseDepartment] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseDuties]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseDuties]

CREATE TABLE [BaseDuties] (
[DutieID] [int]  NOT NULL,
[Name] [varchar]  (50) NULL,
[ParentID] [int]  NULL,
[ParentPath] [varchar]  (20) NULL,
[Description] [varchar]  (200) NULL,
[CreateDate] [datetime]  NULL,
[CreateMan] [varchar]  (20) NULL,
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[DutieLevel] [varchar]  (10) NULL,
[DutieCode] [varchar]  (20) NULL,
[DutieSeries] [varchar]  (50) NULL,
[State] [int]  NULL,
[DeptID] [int]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[BaseInterviewRecord]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseInterviewRecord]

CREATE TABLE [BaseInterviewRecord] (
[Id] [int]  NOT NULL,
[Subject] [varchar]  (50) NULL,
[Content] [varchar]  (200) NULL,
[EmployId] [uniqueidentifier]  NULL,
[UserId] [int]  NULL,
[InterviewDate] [datetime]  NULL,
[CreateDate] [datetime]  NULL)

ALTER TABLE [BaseInterviewRecord] WITH NOCHECK ADD  CONSTRAINT [PK_BaseInterviewRecord] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseKnowledge]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseKnowledge]

CREATE TABLE [BaseKnowledge] (
[Id] [int]  IDENTITY (1, 1)  NOT NULL,
[TypeId] [int]  NULL,
[Title] [varchar]  (100) NULL,
[Content] [text]  NULL,
[Remark] [varchar]  (100) NULL,
[IsQA] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [BaseKnowledge] WITH NOCHECK ADD  CONSTRAINT [PK_BaseKnowledge] PRIMARY KEY  NONCLUSTERED ( [Id] )
SET IDENTITY_INSERT [BaseKnowledge] ON


SET IDENTITY_INSERT [BaseKnowledge] OFF
if exists (select * from sysobjects where id = OBJECT_ID('[BaseKnowledgeType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseKnowledgeType]

CREATE TABLE [BaseKnowledgeType] (
[Id] [int]  NOT NULL,
[TypeName] [varchar]  (50) NULL,
[ParentName] [varchar]  (50) NULL,
[ParentID] [int]  NULL,
[ParentPath] [varchar]  (50) NULL,
[IsUse] [int]  NULL,
[SortCode] [int]  NULL,
[ModifyMan] [varchar]  (50) NULL,
[ModifyDate] [datetime]  NULL)

ALTER TABLE [BaseKnowledgeType] WITH NOCHECK ADD  CONSTRAINT [PK_BaseKnowledgeType] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseLog]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseLog]

CREATE TABLE [BaseLog] (
[CreateUserName] [varchar]  (50) NULL,
[LogDateTime] [datetime]  NULL,
[LogContent] [varchar]  (255) NULL,
[LogIP] [varchar]  (15) NULL,
[LogID] [uniqueidentifier]  NOT NULL DEFAULT (newid()),
[LogCode] [varchar]  (50) NULL)

ALTER TABLE [BaseLog] WITH NOCHECK ADD  CONSTRAINT [PK_BaseLog] PRIMARY KEY  NONCLUSTERED ( [LogID] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseModule]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseModule]

CREATE TABLE [BaseModule] (
[Id] [int]  NOT NULL,
[ParentId] [int]  NULL,
[ParentPath] [varchar]  (50) NULL,
[Code] [varchar]  (50) NULL,
[FullName] [varchar]  (50) NULL,
[Icon] [varchar]  (50) NULL,
[NavigateUrl] [varchar]  (500) NULL,
[Target] [varchar]  (20) NULL,
[Enabled] [int]  NULL,
[IsMenu] [int]  NULL,
[IsPublic] [int]  NULL,
[SortCode] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL,
[IsWork] [int]  NULL,
[IsSys] [int]  NULL)

ALTER TABLE [BaseModule] WITH NOCHECK ADD  CONSTRAINT [PK_BaseModule] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BasePermission]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BasePermission]

CREATE TABLE [BasePermission] (
[Id] [int]  NOT NULL,
[ResourceId] [int]  NULL,
[ResourceCategory] [varchar]  (20) NULL,
[PermissionId] [int]  NULL,
[PermissionConstraint] [varchar]  (800) NULL,
[Enabled] [int]  NULL,
[Remark] [varchar]  (500) NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [BasePermission] WITH NOCHECK ADD  CONSTRAINT [PK_BasePermission] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BasePermissionItem]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BasePermissionItem]

CREATE TABLE [BasePermissionItem] (
[Id] [int]  NOT NULL,
[GroupClass] [varchar]  (50) NULL,
[ParentId] [int]  NULL,
[ParentPath] [varchar]  (50) NULL,
[Code] [varchar]  (50) NULL,
[FullName] [varchar]  (50) NULL,
[Enabled] [int]  NULL,
[IsScope] [int]  NULL,
[SortCode] [int]  NULL,
[Remark] [varchar]  (200) NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [BasePermissionItem] WITH NOCHECK ADD  CONSTRAINT [PK_BasePermissionItem] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BasePermissionItemGroup]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BasePermissionItemGroup]

CREATE TABLE [BasePermissionItemGroup] (
[Id] [int]  NOT NULL,
[ParentId] [int]  NULL,
[ParentPath] [varchar]  (255) NULL,
[GroupClassName] [varchar]  (50) NULL,
[GroupClassCode] [varchar]  (50) NULL,
[SortCode] [int]  NULL,
[IsExistChild] [int]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[BasePermissionScope]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BasePermissionScope]

CREATE TABLE [BasePermissionScope] (
[Id] [int]  NOT NULL,
[ResourceCategory] [varchar]  (20) NULL,
[ResourceId] [varchar]  (50) NULL,
[TargetCategory] [varchar]  (50) NULL,
[TargetId] [varchar]  (50) NULL,
[PermissionId] [int]  NULL,
[Remark] [varchar]  (500) NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [BasePermissionScope] WITH NOCHECK ADD  CONSTRAINT [PK_BasePermissionScope] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseResume]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseResume]

CREATE TABLE [BaseResume] (
[RealName] [varchar]  (20) NULL,
[IDcard] [varchar]  (19) NULL,
[Sex] [varchar]  (2) NULL,
[Nationality] [varchar]  (20) NULL,
[DeptID] [int]  NULL,
[BirthDate] [datetime]  NULL,
[DiplomaID] [int]  NULL,
[Marriage] [varchar]  (10) NULL,
[School] [varchar]  (50) NULL,
[Health] [varchar]  (100) NULL,
[Foreignlanguage] [varchar]  (100) NULL,
[Email] [varchar]  (50) NULL,
[QQ] [varchar]  (20) NULL,
[Political] [varchar]  (10) NULL,
[Height] [varchar]  (10) NULL,
[Telephone] [varchar]  (20) NULL,
[Mobile] [varchar]  (20) NULL,
[RegAddress] [varchar]  (50) NULL,
[MailAddress] [varchar]  (500) NULL,
[PostCode] [varchar]  (6) NULL,
[SelfAppraisal] [text]  NULL,
[EmployStateID] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateMan] [varchar]  (10) NULL,
[ModifyMan] [varchar]  (10) NULL,
[ModifyDate] [datetime]  NULL,
[IsDeleted] [bit]  NULL,
[Remark] [text]  NULL,
[SpecialName] [varchar]  (50) NULL,
[Education] [text]  NULL,
[WorkExperience] [text]  NULL,
[Society] [text]  NULL,
[Certificate] [text]  NULL,
[Train] [text]  NULL,
[Intention] [text]  NULL,
[DutieID] [int]  NULL,
[GraduationDate] [datetime]  NULL,
[EmployType] [int]  NULL,
[EmployID] [uniqueidentifier]  NOT NULL,
[RecentEmployer] [varchar]  (50) NULL,
[RecentPosts] [varchar]  (50) NULL,
[hobbies] [varchar]  (50) NULL,
[Technical] [varchar]  (500) NULL,
[salary] [varchar]  (50) NULL,
[SourceChannel] [varchar]  (50) NULL,
[SourceSite] [varchar]  (50) NULL,
[IsBlackList] [int]  NULL)

ALTER TABLE [BaseResume] WITH NOCHECK ADD  CONSTRAINT [PK_BaseResume] PRIMARY KEY  NONCLUSTERED ( [EmployID] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseRole]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseRole]

CREATE TABLE [BaseRole] (
[Id] [int]  NOT NULL,
[Code] [varchar]  (50) NULL,
[RoleName] [varchar]  (50) NULL,
[Remark] [varchar]  (500) NULL,
[Enabled] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL,
[SortCode] [int]  NULL)

ALTER TABLE [BaseRole] WITH NOCHECK ADD  CONSTRAINT [PK_BaseRole] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseSite]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseSite]

CREATE TABLE [BaseSite] (
[Id] [int]  NOT NULL,
[SiteName] [varchar]  (50) NULL,
[SiteUrl] [varchar]  (100) NULL,
[UserName] [varchar]  (50) NULL,
[PassWord] [varchar]  (50) NULL,
[State] [int]  NULL,
[Remark] [varchar]  (500) NULL)

ALTER TABLE [BaseSite] WITH NOCHECK ADD  CONSTRAINT [PK_BaseSite] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseUser]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseUser]

CREATE TABLE [BaseUser] (
[Id] [int]  NOT NULL,
[UserName] [varchar]  (20) NULL,
[Password] [varchar]  (32) NULL,
[Enabled] [int]  NULL,
[Deleted] [int]  NULL,
[Remark] [varchar]  (500) NULL,
[PreviousDate] [datetime]  NULL,
[LastLoginDate] [datetime]  NULL,
[LastLoginIP] [varchar]  (50) NULL,
[LogOnCount] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (32) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (32) NULL,
[ModifyUserName] [varchar]  (20) NULL,
[WorkNumBer] [varchar]  (50) NULL,
[RealName] [varchar]  (50) NULL,
[IDcard] [varchar]  (19) NULL,
[Sex] [varchar]  (2) NULL,
[Nationality] [varchar]  (20) NULL,
[RegAddress] [varchar]  (50) NULL,
[Height] [varchar]  (10) NULL,
[Marriage] [varchar]  (10) NULL,
[DiplomaID] [int]  NULL,
[Foreignlanguage] [varchar]  (100) NULL,
[SpecialName] [varchar]  (50) NULL,
[School] [varchar]  (50) NULL,
[GraduationDate] [datetime]  NULL,
[Political] [varchar]  (100) NULL,
[BirthDate] [datetime]  NULL,
[Health] [varchar]  (100) NULL,
[DutieID] [int]  NULL,
[telephone] [varchar]  (50) NULL,
[Mobile] [varchar]  (50) NULL,
[Email] [varchar]  (50) NULL,
[QQ] [varchar]  (20) NULL,
[MailAddress] [varchar]  (500) NULL,
[PostCode] [varchar]  (6) NULL,
[SelfAppraisal] [varchar]  (100) NULL,
[Education] [varchar]  (1000) NULL,
[WorkExperience] [text]  NULL,
[Society] [varchar]  (1000) NULL,
[Train] [varchar]  (1000) NULL,
[Certificate] [varchar]  (1000) NULL,
[Hobbies] [varchar]  (50) NULL,
[Technical] [varchar]  (50) NULL,
[SignedDate] [datetime]  NULL,
[ExpireDate] [datetime]  NULL,
[ProbationDate] [datetime]  NULL,
[State] [int]  NULL,
[DeptID] [int]  NULL,
[EmployPic] [varchar]  (50) NULL)

ALTER TABLE [BaseUser] WITH NOCHECK ADD  CONSTRAINT [PK_BaseUser] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BaseUserRole]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BaseUserRole]

CREATE TABLE [BaseUserRole] (
[Id] [int]  NOT NULL,
[UserId] [int]  NULL,
[RoleId] [int]  NULL)

ALTER TABLE [BaseUserRole] WITH NOCHECK ADD  CONSTRAINT [PK_BaseUserRole] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[BizOppTrack]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [BizOppTrack]

CREATE TABLE [BizOppTrack] (
[Id] [int]  NOT NULL,
[BizOppId] [uniqueidentifier]  NOT NULL,
[ExpectMoney] [money]  NULL,
[Probability] [int]  NULL,
[PhaseID] [int]  NULL,
[UserId] [int]  NULL,
[CreateDate] [datetime]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[CodeRule]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CodeRule]

CREATE TABLE [CodeRule] (
[Id] [uniqueidentifier]  NOT NULL,
[FieldName] [varchar]  (50) NULL,
[FieldValue] [varchar]  (100) NULL,
[TableName] [varchar]  (50) NULL,
[ContactChar] [varchar]  (10) NULL,
[Sort] [int]  NULL,
[AddFieldName] [varchar]  (50) NULL,
[IsDelete] [bit]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[Configuration]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Configuration]

CREATE TABLE [Configuration] (
[Id] [int]  NOT NULL,
[Key] [varchar]  (64) NULL,
[Value] [text]  NULL)

ALTER TABLE [Configuration] WITH NOCHECK ADD  CONSTRAINT [PK_Configuration] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[crm_Action]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [crm_Action]

CREATE TABLE [crm_Action] (
[ActionTypeID] [int]  NULL,
[Topic] [varchar]  (100) NULL,
[ActionDate] [datetime]  NULL,
[UserID] [int]  NULL,
[ContactMan] [varchar]  (100) NULL,
[RelateObject] [varchar]  (10) NULL,
[RelateID] [varchar]  (36) NULL,
[Content] [text]  NULL,
[CreateDate] [datetime]  NULL,
[IsDeleted] [bit]  NULL,
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[AuditDate] [datetime]  NULL,
[AuditMan] [varchar]  (20) NULL,
[AuditState] [int]  NULL,
[ActionID] [uniqueidentifier]  NOT NULL,
[CustomerID] [uniqueidentifier]  NULL,
[SpendTime] [int]  NULL,
[SolveDate] [datetime]  NULL,
[OverDate] [datetime]  NULL,
[ActionTypeInfo] [varchar]  (100) NULL,
[IsIn] [bit]  NULL,
[BizOppId] [uniqueidentifier]  NULL,
[ActionFile] [varchar]  (50) NULL)

ALTER TABLE [crm_Action] WITH NOCHECK ADD  CONSTRAINT [PK_crm_Action] PRIMARY KEY  NONCLUSTERED ( [ActionID] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_ClueClass]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_ClueClass]

CREATE TABLE [CRM_ClueClass] (
[Id] [int]  NOT NULL,
[FullName] [varchar]  (50) NULL,
[ParentId] [int]  NULL,
[ParentPath] [varchar]  (500) NULL,
[Remark] [varchar]  (500) NULL,
[SortCode] [int]  NULL)

ALTER TABLE [CRM_ClueClass] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_ClueClass] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[crm_CustomerClue]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [crm_CustomerClue]

CREATE TABLE [crm_CustomerClue] (
[Id] [uniqueidentifier]  NOT NULL,
[ContactMan] [varchar]  (50) NULL,
[Title] [varchar]  (30) NULL,
[CustomerName] [varchar]  (100) NULL,
[CustomerID] [uniqueidentifier]  NULL,
[Telephone] [varchar]  (50) NULL,
[Mobile] [varchar]  (50) NULL,
[Fax] [varchar]  (50) NULL,
[Email] [varchar]  (50) NULL,
[QQ] [varchar]  (50) NULL,
[MSN] [varchar]  (50) NULL,
[PostCode] [varchar]  (20) NULL,
[Address] [varchar]  (100) NULL,
[TransformState] [int]  NULL,
[Remark] [varchar]  (500) NULL,
[TransformMan] [varchar]  (20) NULL,
[TransformDate] [datetime]  NULL,
[IsDeleted] [int]  NULL,
[CreateMan] [varchar]  (20) NULL,
[CreateDate] [datetime]  NULL,
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ClueClassId] [int]  NULL,
[NoPhone] [int]  NULL,
[NoSMS] [int]  NULL,
[NoEmail] [int]  NULL,
[NoFax] [int]  NULL,
[OpportunityId] [uniqueidentifier]  NULL)

ALTER TABLE [crm_CustomerClue] WITH NOCHECK ADD  CONSTRAINT [PK_crm_CustomerClue] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[crm_CustomerFavorite]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [crm_CustomerFavorite]

CREATE TABLE [crm_CustomerFavorite] (
[Id] [uniqueidentifier]  NOT NULL,
[CustomerId] [uniqueidentifier]  NULL,
[CreateUserId] [int]  NULL,
[CreateUserName] [varchar]  (50) NULL,
[CreateDate] [datetime]  NULL,
[ModifyUserId] [int]  NULL,
[ModifyUserName] [varchar]  (50) NULL,
[ModifyDate] [datetime]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Delivery]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Delivery]

CREATE TABLE [CRM_Delivery] (
[Id] [uniqueidentifier]  NOT NULL,
[OrderId] [uniqueidentifier]  NULL,
[DeliveryCode] [varchar]  (32) NULL,
[CustomerId] [uniqueidentifier]  NULL,
[CustomerName] [varchar]  (50) NULL,
[TrackUserID] [int]  NULL,
[TrackUserName] [varchar]  (20) NULL,
[ShippingId] [int]  NULL,
[ShippingMothod] [varchar]  (50) NULL,
[Money] [decimal]  (18,2) NULL,
[LogiName] [varchar]  (50) NULL,
[LogiNo] [varchar]  (32) NULL,
[ShipName] [varchar]  (20) NULL,
[Province] [varchar]  (50) NULL,
[City] [varchar]  (50) NULL,
[County] [varchar]  (50) NULL,
[Address] [varchar]  (100) NULL,
[ZipCode] [varchar]  (10) NULL,
[TelePhone] [varchar]  (20) NULL,
[Mobile] [varchar]  (20) NULL,
[Remark] [varchar]  (500) NULL,
[State] [int]  NULL,
[ShipDate] [datetime]  NULL,
[Cause] [varchar]  (200) NULL,
[Type] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [CRM_Delivery] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Delivery] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_DeliveryProducts]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_DeliveryProducts]

CREATE TABLE [CRM_DeliveryProducts] (
[Id] [int]  NOT NULL,
[DeliveryId] [uniqueidentifier]  NULL,
[ProductId] [uniqueidentifier]  NULL,
[ProductName] [varchar]  (50) NULL,
[ProductSN] [varchar]  (32) NULL,
[Count] [int]  NULL,
[Unit] [varchar]  (20) NULL,
[CustomerId] [uniqueidentifier]  NULL,
[OrderId] [uniqueidentifier]  NULL,
[SN] [varchar]  (50) NULL,
[OrderItemId] [uniqueidentifier]  NULL)

ALTER TABLE [CRM_DeliveryProducts] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_DeliveryProducts] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Invoice]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Invoice]

CREATE TABLE [CRM_Invoice] (
[Id] [uniqueidentifier]  NOT NULL,
[OrderId] [uniqueidentifier]  NULL,
[OrderSN] [varchar]  (255) NULL,
[CustomerId] [uniqueidentifier]  NULL,
[CustomerName] [varchar]  (100) NULL,
[InvoiceType] [int]  NULL,
[InvoicePayee] [varchar]  (255) NULL,
[InvoiceContent] [text]  NULL,
[InvoiceAptitude] [text]  NULL,
[InvoiceTax] [decimal]  (18,0) NULL,
[InvoiceNo] [varchar]  (500) NULL,
[TrackUserName] [varchar]  (20) NULL,
[InvoiceDate] [datetime]  NULL,
[State] [int]  NULL,
[Remark] [text]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (20) NULL,
[InvoiceNum] [varchar]  (200) NULL,
[outDate] [datetime]  NULL)

ALTER TABLE [CRM_Invoice] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Invoice] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[crm_Opportunity]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [crm_Opportunity]

CREATE TABLE [crm_Opportunity] (
[Topic] [varchar]  (100) NULL,
[CreateUserID] [int]  NULL,
[CreateDate] [datetime]  NULL,
[TrackUserID] [int]  NULL,
[ExpectDate] [datetime]  NULL,
[ExpectMoney] [money]  NULL,
[Probability] [int]  NULL,
[PhaseID] [int]  NULL,
[OpportState] [int]  NULL,
[Remark] [varchar]  (200) NULL,
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[Reason] [varchar]  (200) NULL,
[EffectDate] [datetime]  NULL,
[HotLevel] [int]  NULL,
[BizTypeID] [int]  NULL,
[OwnerID] [int]  NULL,
[CustomerID] [uniqueidentifier]  NULL,
[OpportunityID] [uniqueidentifier]  NOT NULL,
[ProductID] [uniqueidentifier]  NULL,
[OpportunityCode] [int]  NULL,
[FromName] [varchar]  (50) NULL,
[FromUrl] [varchar]  (200) NULL,
[FromHost] [varchar]  (50) NULL,
[FromKey] [varchar]  (50) NULL,
[FromDate] [datetime]  NULL,
[CustomerClueId] [uniqueidentifier]  NULL,
[OrderId] [uniqueidentifier]  NULL)

ALTER TABLE [crm_Opportunity] WITH NOCHECK ADD  CONSTRAINT [PK_crm_Opportunity] PRIMARY KEY  NONCLUSTERED ( [OpportunityID] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Orders]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Orders]

CREATE TABLE [CRM_Orders] (
[Id] [uniqueidentifier]  NOT NULL,
[OrderSN] [varchar]  (50) NULL,
[CustomerId] [uniqueidentifier]  NULL,
[CustomerName] [varchar]  (100) NULL,
[CustomerLogin] [varchar]  (20) NULL,
[RegionId] [int]  NULL,
[ShipTo] [varchar]  (20) NULL,
[Country] [varchar]  (30) NULL,
[Province] [varchar]  (30) NULL,
[City] [varchar]  (30) NULL,
[County] [varchar]  (30) NULL,
[Address] [varchar]  (255) NULL,
[Mobile] [varchar]  (20) NULL,
[TelePhone] [varchar]  (20) NULL,
[Email] [varchar]  (50) NULL,
[ZipCode] [varchar]  (10) NULL,
[QQ] [varchar]  (50) NULL,
[Wangwang] [varchar]  (50) NULL,
[Skype] [varchar]  (50) NULL,
[ShippingId] [int]  NULL,
[ShippingName] [varchar]  (50) NULL,
[PayMothodId] [int]  NULL,
[PayMothodName] [varchar]  (50) NULL,
[PackId] [int]  NULL,
[PackName] [varchar]  (100) NULL,
[Currency] [int]  NULL,
[CurrencyRate] [decimal]  (18,2) NULL,
[PriceTerm] [varchar]  (100) NULL,
[DrawbackMoney] [decimal]  (18,2) NULL,
[PayedAmount] [decimal]  (18,2) NULL,
[OrderTotal] [decimal]  (18,2) NULL,
[GoodsAmount] [decimal]  (18,2) NULL,
[AdjustedDiscount] [decimal]  (18,2) NULL,
[Freight] [decimal]  (18,2) NULL,
[Insurance] [decimal]  (18,2) NULL,
[PayFee] [decimal]  (18,2) NULL,
[PackFee] [decimal]  (18,2) NULL,
[Tax] [decimal]  (18,2) NULL,
[CouponType] [int]  NULL,
[CouponName] [varchar]  (500) NULL,
[CouponCode] [varchar]  (100) NULL,
[CouponMoney] [decimal]  (18,2) NULL,
[PayPoints] [int]  NULL,
[GetPoints] [int]  NULL,
[GatewayOrderId] [varchar]  (100) NULL,
[Logistic] [varchar]  (50) NULL,
[FromPort] [varchar]  (100) NULL,
[ToPort] [varchar]  (100) NULL,
[ShippingMark] [varchar]  (1000) NULL,
[SignBuilding] [varchar]  (100) NULL,
[Weight] [int]  NULL,
[ProcedureFeeFree] [int]  NULL,
[bInvoice] [int]  NULL,
[InvType] [int]  NULL,
[InvPayee] [varchar]  (200) NULL,
[InvContent] [varchar]  (200) NULL,
[InvMore] [varchar]  (200) NULL,
[InvNo] [varchar]  (200) NULL,
[ShipOrderNumber] [varchar]  (50) NULL,
[AuditState] [int]  NULL,
[DeliveryStatus] [int]  NULL,
[RefundStatus] [int]  NULL,
[RefundAmount] [decimal]  (18,2) NULL,
[RefundRemark] [varchar]  (500) NULL,
[PayState] [int]  NULL,
[OrderCostPrice] [decimal]  (18,2) NULL,
[OrderProfit] [decimal]  (18,2) NULL,
[OrderDate] [datetime]  NULL,
[PayTime] [datetime]  NULL,
[DeliveryTime] [datetime]  NULL,
[BestTime] [datetime]  NULL,
[ShipDeadline] [datetime]  NULL,
[FinishDate] [datetime]  NULL,
[CloseReason] [varchar]  (500) NULL,
[AuditName] [varchar]  (20) NULL,
[AuditDate] [datetime]  NULL,
[TrackUserID] [int]  NULL,
[TrackUserName] [varchar]  (20) NULL,
[OrderSource] [int]  NULL,
[PrintStatus] [int]  NULL,
[Confirm] [int]  NULL,
[OpptunityID] [uniqueidentifier]  NULL,
[FromUrl] [varchar]  (255) NULL,
[FromHost] [varchar]  (255) NULL,
[FromKey] [varchar]  (255) NULL,
[FromName] [varchar]  (255) NULL,
[FromDate] [datetime]  NULL,
[ReferralId] [varchar]  (255) NULL,
[AgentUserName] [varchar]  (50) NULL,
[AgentId] [varchar]  (32) NULL,
[ShopID] [int]  NULL,
[Postscript] [varchar]  (500) NULL,
[Remark] [varchar]  (500) NULL,
[Deleted] [int]  NULL,
[IsRenewal] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (36) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (36) NULL,
[ModifyUserName] [varchar]  (20) NULL,
[InvoiceAptitude] [text]  NULL,
[Distributor] [varchar]  (50) NULL,
[ShopName] [varchar]  (50) NULL)

ALTER TABLE [CRM_Orders] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Orders] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_OrdersItems]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_OrdersItems]

CREATE TABLE [CRM_OrdersItems] (
[Id] [uniqueidentifier]  NOT NULL,
[OrderId] [uniqueidentifier]  NULL,
[ProductId] [uniqueidentifier]  NULL,
[ProductName] [varchar]  (100) NULL,
[ProductSN] [varchar]  (255) NULL,
[CostPrice] [decimal]  (18,2) NULL,
[MarketPrice] [decimal]  (18,2) NULL,
[RealPrice] [decimal]  (18,2) NULL,
[PayNum] [int]  NULL,
[SendNum] [int]  NULL,
[Unit] [varchar]  (10) NULL,
[Amount] [decimal]  (18,2) NULL,
[Weight] [int]  NULL,
[GiftId] [varchar]  (32) NULL,
[GiftName] [varchar]  (100) NULL,
[ThumbnailsUrl] [varchar]  (500) NULL,
[Points] [int]  NULL,
[State] [int]  NULL,
[Remark] [varchar]  (500) NULL,
[Type] [int]  NULL,
[CreateDate] [datetime]  NULL,
[SN] [varchar]  (255) NULL,
[IsRenewal] [int]  NULL,
[AdjustFee] [decimal]  (18,2) NULL,
[DiscountFee] [decimal]  (18,2) NULL)

ALTER TABLE [CRM_OrdersItems] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_OrdersItems] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Payment]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Payment]

CREATE TABLE [CRM_Payment] (
[Id] [int]  NOT NULL,
[PayType] [int]  NULL,
[PayName] [varchar]  (100) NULL,
[PayFee] [decimal]  (18,2) NULL,
[PayConfig] [varchar]  (500) NULL,
[Remark] [varchar]  (500) NULL,
[SortCode] [int]  NULL,
[PluginsCode] [varchar]  (50) NULL)

ALTER TABLE [CRM_Payment] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Payment] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_PayMents]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_PayMents]

CREATE TABLE [CRM_PayMents] (
[Id] [uniqueidentifier]  NOT NULL,
[OrderId] [uniqueidentifier]  NULL,
[CustomerId] [uniqueidentifier]  NULL,
[CustomerName] [varchar]  (100) NULL,
[Type] [int]  NULL,
[Amount] [decimal]  (18,2) NULL,
[PayType] [int]  NULL,
[PayMothodId] [int]  NULL,
[PayMothodName] [varchar]  (50) NULL,
[PayDate] [datetime]  NULL,
[TrackUserID] [int]  NULL,
[TrackUserName] [varchar]  (20) NULL,
[PayAuditMan] [varchar]  (20) NULL,
[PayAuditDate] [datetime]  NULL,
[IsPaid] [int]  NULL,
[Remark] [varchar]  (500) NULL,
[CreateDate] [datetime]  NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [CRM_PayMents] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_PayMents] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_ProductCategory]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_ProductCategory]

CREATE TABLE [CRM_ProductCategory] (
[CategoryId] [int]  NOT NULL,
[TypeId] [int]  NULL,
[ParentId] [int]  NULL,
[CategoryPath] [varchar]  (255) NULL,
[CategoryName] [varchar]  (20) NULL,
[ProductCount] [int]  NULL,
[ChildCount] [int]  NULL,
[Addon] [varchar]  (500) NULL,
[Is_Active] [int]  NULL,
[SortCode] [int]  NULL,
[Depth] [int]  NULL,
[CateCode] [varchar]  (50) NULL)

ALTER TABLE [CRM_ProductCategory] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_ProductCategory] PRIMARY KEY  NONCLUSTERED ( [CategoryId] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Products]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Products]

CREATE TABLE [CRM_Products] (
[Id] [uniqueidentifier]  NOT NULL,
[ProductName] [varchar]  (200) NULL,
[ProductCode] [varchar]  (50) NULL,
[CategoryId] [int]  NULL,
[TypeId] [int]  NULL,
[BrandId] [int]  NULL,
[BrandName] [varchar]  (255) NULL,
[HasSKU] [int]  NULL,
[HasSN] [int]  NULL,
[SellorRent] [int]  NULL,
[Brief] [varchar]  (2000) NULL,
[Description] [text]  NULL,
[Cost] [decimal]  (18,2) NULL,
[SalePrice] [decimal]  (18,2) NULL,
[WholeSalePrice] [decimal]  (18,2) NULL,
[MarketPrice] [decimal]  (18,2) NULL,
[Unit] [varchar]  (50) NULL,
[image_default] [int]  NULL,
[thumbnail_pic] [varchar]  (255) NULL,
[small_pic] [varchar]  (255) NULL,
[big_pic] [varchar]  (255) NULL,
[LineId] [int]  NULL,
[VistiCounts] [int]  NULL,
[SaleCounts] [int]  NULL,
[OrderPos] [int]  NULL,
[AddedDate] [datetime]  NULL,
[Is_Active] [int]  NULL,
[ShopCode] [varchar]  (50) NULL,
[IsAotuDelivery] [int]  NULL)

ALTER TABLE [CRM_Products] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Products] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_ProductTypes]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_ProductTypes]

CREATE TABLE [CRM_ProductTypes] (
[TypeId] [int]  NOT NULL,
[TypeName] [varchar]  (20) NULL,
[Remark] [varchar]  (200) NULL)

ALTER TABLE [CRM_ProductTypes] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_ProductTypes] PRIMARY KEY  NONCLUSTERED ( [TypeId] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Promote]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Promote]

CREATE TABLE [CRM_Promote] (
[Id] [uniqueidentifier]  NOT NULL,
[Title] [varchar]  (255) NULL,
[Subject] [varchar]  (255) NULL,
[Content] [text]  NULL,
[TraceID] [varchar]  (100) NULL,
[Method] [varchar]  (20) NULL,
[SentQty] [int]  NULL,
[RegQty] [int]  NULL,
[OrderQty] [int]  NULL,
[OrderMoney] [decimal]  (18,0) NULL,
[CreateDate] [datetime]  NULL,
[FromFilter] [varchar]  (500) NULL,
[FromType] [varchar]  (50) NULL,
[SendSet] [int]  NULL,
[CreateUserName] [varchar]  (20) NULL,
[IsAutoLoad] [int]  NULL,
[SendName] [varchar]  (50) NULL,
[AutoLoadDate] [int]  NULL,
[LastAutoLoadDate] [datetime]  NULL)

ALTER TABLE [CRM_Promote] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Promote] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[crm_ServiceAction]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [crm_ServiceAction]

CREATE TABLE [crm_ServiceAction] (
[Id] [uniqueidentifier]  NOT NULL,
[ServerType] [int]  NULL,
[Problem] [text]  NULL,
[Solution] [text]  NULL,
[Result] [text]  NULL,
[BeginDate] [datetime]  NULL,
[OverDate] [datetime]  NULL,
[SpendTime] [float]  NULL,
[SolveState] [int]  NULL,
[ServerRequestID] [uniqueidentifier]  NULL,
[SolveManID] [int]  NULL,
[AuditMan] [varchar]  (20) NULL,
[AuditDate] [datetime]  NULL,
[AuditState] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CustomerId] [uniqueidentifier]  NULL,
[ServerTopic] [varchar]  (200) NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Shipping]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Shipping]

CREATE TABLE [CRM_Shipping] (
[Id] [int]  NOT NULL,
[ShippingCode] [varchar]  (50) NULL,
[ShippingName] [varchar]  (20) NULL,
[Remark] [varchar]  (500) NULL,
[Freight] [decimal]  (18,2) NULL,
[SortCode] [int]  NULL,
[State] [int]  NULL)

ALTER TABLE [CRM_Shipping] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Shipping] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_SKUs]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_SKUs]

CREATE TABLE [CRM_SKUs] (
[SkuId] [uniqueidentifier]  NOT NULL,
[ProductId] [uniqueidentifier]  NULL,
[SKUCode] [varchar]  (50) NULL,
[Barcode] [varchar]  (128) NULL,
[SKUName] [varchar]  (100) NULL,
[SKUTitle] [varchar]  (100) NULL,
[SKUBrief] [varchar]  (255) NULL,
[AlertStock] [int]  NULL,
[Cost] [decimal]  (18,2) NULL,
[SalePrice] [decimal]  (18,2) NULL,
[WholeSalePrice] [decimal]  (18,2) NULL,
[MarketPrice] [decimal]  (18,2) NULL,
[Stock] [int]  NULL,
[Weight] [int]  NULL,
[image_default] [int]  NULL,
[thumbnail_pic] [varchar]  (255) NULL,
[small_pic] [varchar]  (255) NULL,
[big_pic] [varchar]  (255) NULL,
[AddedDate] [datetime]  NULL,
[Is_Active] [int]  NULL,
[Is_Init] [int]  NULL,
[ShopCode] [varchar]  (50) NULL)

ALTER TABLE [CRM_SKUs] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_SKUs] PRIMARY KEY  NONCLUSTERED ( [SkuId] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_SKUSpecs]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_SKUSpecs]

CREATE TABLE [CRM_SKUSpecs] (
[SpecId] [int]  NULL,
[SkuId] [uniqueidentifier]  NULL,
[ValueId] [int]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[CRM_SN]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_SN]

CREATE TABLE [CRM_SN] (
[SNId] [uniqueidentifier]  NOT NULL,
[ProductSN] [varchar]  (255) NULL,
[SKUId] [uniqueidentifier]  NULL,
[AccountId] [varchar]  (50) NULL,
[Password] [varchar]  (32) NULL,
[AvailDate] [datetime]  NULL,
[CustomerID] [uniqueidentifier]  NULL,
[CustomerName] [varchar]  (100) NULL,
[Contact] [varchar]  (50) NULL,
[Country] [varchar]  (50) NULL,
[ProvinceId] [int]  NULL,
[Province] [varchar]  (50) NULL,
[CityId] [int]  NULL,
[City] [varchar]  (50) NULL,
[District] [varchar]  (50) NULL,
[Address] [varchar]  (255) NULL,
[Zipcode] [varchar]  (20) NULL,
[Telephone] [varchar]  (50) NULL,
[MobilePhone] [varchar]  (50) NULL,
[Fax] [varchar]  (50) NULL,
[Email] [varchar]  (255) NULL,
[QQ] [varchar]  (50) NULL,
[MSN] [varchar]  (50) NULL,
[Wangwang] [varchar]  (50) NULL,
[IndustryId] [int]  NULL,
[Skype] [varchar]  (100) NULL,
[RegFrom] [varchar]  (255) NULL,
[RegIP] [varchar]  (255) NULL,
[RegDate] [datetime]  NULL,
[ReferralId] [varchar]  (255) NULL,
[AgentId] [varchar]  (50) NULL,
[AgentUserName] [varchar]  (50) NULL,
[VersionNum] [varchar]  (20) NULL,
[LastLoginDate] [datetime]  NULL,
[LastLoginIp] [varchar]  (255) NULL,
[ChargeOperator] [int]  NULL,
[ChargeOperatorName] [varchar]  (20) NULL,
[LastEditDate] [datetime]  NULL,
[AuditDate] [datetime]  NULL,
[AuditState] [int]  NULL,
[Is_Active] [int]  NULL,
[UseState] [int]  NULL,
[Remark] [varchar]  (500) NULL,
[LastUpgradeDate] [datetime]  NULL,
[RegSite] [varchar]  (10) NULL,
[MachineCode] [varchar]  (50) NULL,
[UserCount] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserId] [varchar]  (36) NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (36) NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [CRM_SN] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_SN] PRIMARY KEY  NONCLUSTERED ( [SNId] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_Specs]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_Specs]

CREATE TABLE [CRM_Specs] (
[SpecId] [int]  NOT NULL,
[SpecName] [varchar]  (50) NULL,
[TypeId] [int]  NULL,
[UsageMode] [int]  NULL,
[UseAttributeImage] [int]  NULL,
[SortCode] [int]  NULL)

ALTER TABLE [CRM_Specs] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_Specs] PRIMARY KEY  NONCLUSTERED ( [SpecId] )
if exists (select * from sysobjects where id = OBJECT_ID('[CRM_SpecValues]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CRM_SpecValues]

CREATE TABLE [CRM_SpecValues] (
[ValueId] [int]  NOT NULL,
[ValueStr] [varchar]  (200) NULL,
[SpecId] [int]  NULL,
[ImageUrl] [varchar]  (255) NULL,
[SortCode] [int]  NULL)

ALTER TABLE [CRM_SpecValues] WITH NOCHECK ADD  CONSTRAINT [PK_CRM_SpecValues] PRIMARY KEY  NONCLUSTERED ( [ValueId] )
if exists (select * from sysobjects where id = OBJECT_ID('[Customer]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Customer]

CREATE TABLE [Customer] (
[CustomerName] [varchar]  (100) NULL,
[IsHot] [bit]  NULL,
[HotLevel] [int]  NULL,
[BizTypeID] [int]  NULL,
[StageID] [int]  NULL,
[SourceID] [int]  NULL,
[OtherSource] [varchar]  (20) NULL,
[IndustryID] [int]  NULL,
[ProvinceID] [int]  NULL,
[City] [varchar]  (20) NULL,
[Telephone] [varchar]  (50) NULL,
[Fax] [varchar]  (50) NULL,
[Web] [varchar]  (100) NULL,
[Address] [varchar]  (200) NULL,
[PostCode] [varchar]  (20) NULL,
[CustomerInfo] [text]  NULL,
[OwnerID] [int]  NULL,
[TrackDate] [datetime]  NULL,
[LastContactTime] [datetime]  NULL,
[NextContactTime] [datetime]  NULL,
[IsPersonal] [bit]  NULL,
[IsPublic] [bit]  NULL,
[IsPurchase] [bit]  NULL,
[ReadUsers] [varchar]  (100) NULL,
[WriteUsers] [varchar]  (100) NULL,
[CreateUserID] [int]  NULL,
[CreateDate] [datetime]  NULL,
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[IsDeleted] [bit]  NULL,
[Remark] [varchar]  (500) NULL,
[Email] [varchar]  (50) NULL,
[SalePeriod] [int]  NULL,
[CityID] [int]  NULL,
[Nature] [varchar]  (100) NULL,
[Scale] [varchar]  (100) NULL,
[Turnover] [varchar]  (100) NULL,
[Service] [varchar]  (200) NULL,
[Categories] [varchar]  (200) NULL,
[LegalPerson] [varchar]  (20) NULL,
[FromUrl] [varchar]  (255) NULL,
[EffectDate] [datetime]  NULL,
[TrackCount] [int]  NULL,
[TrackUserID] [int]  NULL,
[IsCorporateResources] [bit]  NULL,
[CustomerID] [uniqueidentifier]  NOT NULL,
[ActionCount] [int]  NULL,
[CustomerCode] [int]  NULL,
[AssignID] [int]  NULL,
[AgentUserName] [varchar]  (50) NULL,
[FromName] [varchar]  (50) NULL,
[FromHost] [varchar]  (50) NULL,
[FromKey] [varchar]  (50) NULL,
[FromDate] [datetime]  NULL,
[CustomerLevel] [int]  NULL,
[CustomerClass] [varchar]  (20) NULL,
[CustomerClueId] [uniqueidentifier]  NULL,
[TypeId] [int]  NULL,
[IsLock] [bit]  NULL,
[ShortName] [varchar]  (50) NULL,
[GradeId] [int]  NULL,
[LoginName] [varchar]  (50) NULL,
[Password] [varchar]  (50) NULL,
[TradePassword] [varchar]  (50) NULL,
[pw_answer] [varchar]  (50) NULL,
[pw_question] [varchar]  (50) NULL,
[MainContactName] [varchar]  (50) NULL,
[Sex] [int]  NULL,
[BirthDay] [datetime]  NULL,
[IDnumber] [varchar]  (50) NULL,
[OrderCount] [int]  NULL,
[Expenditure] [numeric]  (18,1) NULL,
[LastTradeDate] [datetime]  NULL,
[Points] [int]  NULL,
[rank_points] [int]  NULL,
[Balance_freeze] [numeric]  (18,1) NULL,
[Credit_line] [numeric]  (18,1) NULL,
[Receivable] [numeric]  (18,1) NULL,
[AddressID] [int]  NULL,
[CellPhone] [varchar]  (50) NULL,
[QQ] [varchar]  (50) NULL,
[Wangwang] [varchar]  (50) NULL,
[Currency] [varchar]  (50) NULL,
[LogisticID] [int]  NULL,
[unreadmsg] [int]  NULL,
[login_count] [int]  NULL,
[is_validated] [bit]  NULL,
[reg_ip] [varchar]  (50) NULL,
[last_login] [datetime]  NULL,
[last_ip] [varchar]  (50) NULL,
[LastContact] [text]  NULL,
[IsSend] [bit]  NULL,
[TradeUserId] [int]  NULL,
[IsBlackList] [bit]  NULL,
[CurrentOppId] [uniqueidentifier]  NULL,
[Disabled] [bit]  NULL,
[LastAction] [varchar]  (500) NULL,
[AgencyStatus] [int]  NULL,
[ParentID] [uniqueidentifier]  NULL,
[AgentGradeId] [int]  NULL,
[AuthorizedGroups] [varchar]  (50) NULL,
[balance] [decimal]  (18,1) NULL,
[CustomerGradeId] [int]  NULL)

ALTER TABLE [Customer] WITH NOCHECK ADD  CONSTRAINT [PK_Customer] PRIMARY KEY  NONCLUSTERED ( [CustomerID] )
if exists (select * from sysobjects where id = OBJECT_ID('[Customer_Addrs]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Customer_Addrs]

CREATE TABLE [Customer_Addrs] (
[Id] [int]  NOT NULL,
[CustomerId] [uniqueidentifier]  NULL,
[ShipTo] [varchar]  (20) NULL,
[Country] [varchar]  (30) NULL,
[Province] [varchar]  (30) NULL,
[City] [varchar]  (30) NULL,
[County] [varchar]  (30) NULL,
[Address] [varchar]  (255) NULL,
[ZipCode] [varchar]  (20) NULL,
[TelePhone] [varchar]  (30) NULL,
[Mobile] [varchar]  (30) NULL,
[Email] [varchar]  (50) NULL,
[QQ] [varchar]  (50) NULL,
[Wangwang] [varchar]  (50) NULL,
[DefAddrs] [int]  NULL)

ALTER TABLE [Customer_Addrs] WITH NOCHECK ADD  CONSTRAINT [PK_Customer_Addrs] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[CustomerContact]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CustomerContact]

CREATE TABLE [CustomerContact] (
[Name] [varchar]  (50) NULL,
[Sex] [int]  NULL,
[ContactTypeID] [int]  NULL,
[IsPrimary] [bit]  NULL,
[Title] [varchar]  (20) NULL,
[JobTitle] [varchar]  (20) NULL,
[Department] [varchar]  (20) NULL,
[Telphone] [varchar]  (50) NULL,
[Fax] [varchar]  (50) NULL,
[MobilePhone] [varchar]  (50) NULL,
[Email] [varchar]  (50) NULL,
[HomePhone] [varchar]  (50) NULL,
[QQ] [varchar]  (50) NULL,
[MSN] [varchar]  (50) NULL,
[Birthday] [datetime]  NULL,
[Hobby] [varchar]  (100) NULL,
[Remark] [varchar]  (100) NULL,
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[IsDeleted] [bit]  NULL,
[ContactID] [uniqueidentifier]  NOT NULL,
[CustomerID] [uniqueidentifier]  NULL,
[CreateUserName] [varchar]  (50) NULL,
[CreateDate] [datetime]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[CustomerGrade]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CustomerGrade]

CREATE TABLE [CustomerGrade] (
[GradeID] [int]  NOT NULL,
[Name] [varchar]  (50) NULL,
[Discount] [numeric]  (18,1) NULL,
[Point] [int]  NULL,
[IsDefault] [bit]  NULL,
[Is_Active] [bit]  NULL,
[remark] [varchar]  (200) NULL)

ALTER TABLE [CustomerGrade] WITH NOCHECK ADD  CONSTRAINT [PK_CustomerGrade] PRIMARY KEY  NONCLUSTERED ( [GradeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[CustomerType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [CustomerType]

CREATE TABLE [CustomerType] (
[Id] [int]  NOT NULL,
[TypeName] [varchar]  (50) NULL,
[remark] [varchar]  (100) NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[dict_ActionType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_ActionType]

CREATE TABLE [dict_ActionType] (
[ActionTypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_ActionType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_ActionType] PRIMARY KEY  NONCLUSTERED ( [ActionTypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_BizType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_BizType]

CREATE TABLE [dict_BizType] (
[BizTypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_BizType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_BizType] PRIMARY KEY  NONCLUSTERED ( [BizTypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_city]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_city]

CREATE TABLE [dict_city] (
[city_id] [int]  NOT NULL,
[city_name] [varchar]  (30) NOT NULL,
[city_code] [varchar]  (8) NULL,
[alphabet_code] [varchar]  (15) NULL,
[province_id] [int]  NULL,
[post_code] [varchar]  (8) NULL,
[area_code] [varchar]  (8) NULL,
[set_date] [datetime]  NULL,
[remark] [varchar]  (100) NULL)

ALTER TABLE [dict_city] WITH NOCHECK ADD  CONSTRAINT [PK_dict_city] PRIMARY KEY  NONCLUSTERED ( [city_id] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_ContactType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_ContactType]

CREATE TABLE [dict_ContactType] (
[ContactTypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_ContactType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_ContactType] PRIMARY KEY  NONCLUSTERED ( [ContactTypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_Diploma]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_Diploma]

CREATE TABLE [dict_Diploma] (
[DiplomaID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_Diploma] WITH NOCHECK ADD  CONSTRAINT [PK_dict_Diploma] PRIMARY KEY  NONCLUSTERED ( [DiplomaID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_EmployState]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_EmployState]

CREATE TABLE [dict_EmployState] (
[EmployStateID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_EmployState] WITH NOCHECK ADD  CONSTRAINT [PK_dict_EmployState] PRIMARY KEY  NONCLUSTERED ( [EmployStateID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_HotType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_HotType]

CREATE TABLE [dict_HotType] (
[HotTypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_HotType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_HotType] PRIMARY KEY  NONCLUSTERED ( [HotTypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_Industry]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_Industry]

CREATE TABLE [dict_Industry] (
[IndustryID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_Industry] WITH NOCHECK ADD  CONSTRAINT [PK_dict_Industry] PRIMARY KEY  NONCLUSTERED ( [IndustryID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_KnowledgeType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_KnowledgeType]

CREATE TABLE [dict_KnowledgeType] (
[TypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL,
[ParentID] [int]  NULL,
[ParentPath] [varchar]  (50) NULL)

ALTER TABLE [dict_KnowledgeType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_KnowledgeType] PRIMARY KEY  NONCLUSTERED ( [TypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_Phase]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_Phase]

CREATE TABLE [dict_Phase] (
[PhaseID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_Phase] WITH NOCHECK ADD  CONSTRAINT [PK_dict_Phase] PRIMARY KEY  NONCLUSTERED ( [PhaseID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_ProductType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_ProductType]

CREATE TABLE [dict_ProductType] (
[ProductTypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_ProductType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_ProductType] PRIMARY KEY  NONCLUSTERED ( [ProductTypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_Province]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_Province]

CREATE TABLE [dict_Province] (
[ProvinceID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_Province] WITH NOCHECK ADD  CONSTRAINT [PK_dict_Province] PRIMARY KEY  NONCLUSTERED ( [ProvinceID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_Reason]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_Reason]

CREATE TABLE [dict_Reason] (
[ReasonID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_Reason] WITH NOCHECK ADD  CONSTRAINT [PK_dict_Reason] PRIMARY KEY  NONCLUSTERED ( [ReasonID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_ServiceMode]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_ServiceMode]

CREATE TABLE [dict_ServiceMode] (
[ServiceModeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_ServiceMode] WITH NOCHECK ADD  CONSTRAINT [PK_dict_ServiceMode] PRIMARY KEY  NONCLUSTERED ( [ServiceModeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_ServiceType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_ServiceType]

CREATE TABLE [dict_ServiceType] (
[ServiceTypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_ServiceType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_ServiceType] PRIMARY KEY  NONCLUSTERED ( [ServiceTypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_Source]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_Source]

CREATE TABLE [dict_Source] (
[SourceID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_Source] WITH NOCHECK ADD  CONSTRAINT [PK_dict_Source] PRIMARY KEY  NONCLUSTERED ( [SourceID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_Stage]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_Stage]

CREATE TABLE [dict_Stage] (
[StageID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (50) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_Stage] WITH NOCHECK ADD  CONSTRAINT [PK_dict_Stage] PRIMARY KEY  NONCLUSTERED ( [StageID] )
if exists (select * from sysobjects where id = OBJECT_ID('[dict_TaskTemplateType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [dict_TaskTemplateType]

CREATE TABLE [dict_TaskTemplateType] (
[TaskTemplateTypeID] [int]  NOT NULL,
[name] [varchar]  (30) NOT NULL,
[alphabet] [varchar]  (15) NULL,
[taxis] [int]  NULL,
[selected] [bit]  NULL,
[isuse] [bit]  NULL,
[remark] [varchar]  (100) NULL,
[modifyman] [varchar]  (20) NULL,
[modifydate] [datetime]  NULL)

ALTER TABLE [dict_TaskTemplateType] WITH NOCHECK ADD  CONSTRAINT [PK_dict_TaskTemplateType] PRIMARY KEY  NONCLUSTERED ( [TaskTemplateTypeID] )
if exists (select * from sysobjects where id = OBJECT_ID('[DictClass]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [DictClass]

CREATE TABLE [DictClass] (
[ID] [int]  NOT NULL,
[DictName] [varchar]  (100) NULL,
[TableName] [varchar]  (100) NULL,
[IDField] [varchar]  (100) NULL DEFAULT ('ID'),
[NameField] [varchar]  (100) NULL DEFAULT ('Name'),
[AlphabetField] [varchar]  (100) NULL DEFAULT ('Alphabet'),
[TaxisField] [varchar]  (100) NULL DEFAULT ('Taxis'),
[SelectedField] [varchar]  (100) NULL DEFAULT ('Selected'),
[RemarkField] [varchar]  (100) NULL DEFAULT ('Remark'),
[ModifyManField] [varchar]  (100) NULL DEFAULT ('ModifyMan'),
[ModifyDateField] [varchar]  (100) NULL DEFAULT ('ModifyDate'),
[ModifyMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL)

ALTER TABLE [DictClass] WITH NOCHECK ADD  CONSTRAINT [PK_DictClass] PRIMARY KEY  NONCLUSTERED ( [ID] )
if exists (select * from sysobjects where id = OBJECT_ID('[EmailTask]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [EmailTask]

CREATE TABLE [EmailTask] (
[Id] [uniqueidentifier]  NOT NULL,
[Subject] [varchar]  (500) NULL,
[Content] [text]  NULL,
[IsHtml] [bit]  NULL,
[ToEmail] [varchar]  (50) NULL,
[FromEmail] [varchar]  (50) NULL,
[State] [int]  NULL,
[StatusCode] [int]  NULL,
[ResponseText] [varchar]  (200) NULL,
[CreateDate] [datetime]  NULL,
[SendDate] [datetime]  NULL,
[PromoteId] [uniqueidentifier]  NULL,
[TaskType] [varchar]  (20) NULL,
[ResourceId] [uniqueidentifier]  NULL,
[AwokeClass] [int]  NULL,
[FromName] [varchar]  (50) NULL)

ALTER TABLE [EmailTask] WITH NOCHECK ADD  CONSTRAINT [PK_EmailTask] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[EmailTemplate]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [EmailTemplate]

CREATE TABLE [EmailTemplate] (
[Id] [int]  NOT NULL,
[TempType] [int]  NULL,
[Subject] [varchar]  (100) NULL,
[TempTitle] [varchar]  (50) NULL,
[Content] [varchar]  (1000) NULL,
[Enabled] [int]  NULL,
[IsHtml] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (20) NULL)

ALTER TABLE [EmailTemplate] WITH NOCHECK ADD  CONSTRAINT [PK_EmailTemplate] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[EmployFiles]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [EmployFiles]

CREATE TABLE [EmployFiles] (
[Id] [int]  NOT NULL,
[WorkNumber] [varchar]  (50) NULL,
[FilesType] [int]  NULL,
[UserId] [int]  NULL,
[RealName] [varchar]  (20) NULL,
[IDcard] [varchar]  (19) NULL,
[Sex] [varchar]  (2) NULL,
[Nationality] [varchar]  (20) NULL,
[DeptID] [int]  NULL,
[BirthDate] [datetime]  NULL,
[DiplomaID] [int]  NULL,
[Marriage] [varchar]  (10) NULL,
[School] [varchar]  (50) NULL,
[Health] [varchar]  (100) NULL,
[Foreignlanguage] [varchar]  (100) NULL,
[Email] [varchar]  (50) NULL,
[QQ] [varchar]  (20) NULL,
[Political] [varchar]  (10) NULL,
[Height] [varchar]  (10) NULL,
[Telephone] [varchar]  (20) NULL,
[Mobile] [varchar]  (20) NULL,
[RegAddress] [varchar]  (50) NULL,
[MailAddress] [varchar]  (500) NULL,
[PostCode] [varchar]  (6) NULL,
[SelfAppraisal] [text]  NULL,
[CreateDate] [datetime]  NULL,
[CreateMan] [varchar]  (10) NULL,
[ModifyMan] [varchar]  (10) NULL,
[ModifyDate] [datetime]  NULL,
[IsDeleted] [bit]  NULL,
[Remark] [varchar]  (500) NULL,
[SpecialName] [varchar]  (50) NULL,
[Education] [varchar]  (1000) NULL,
[WorkExperience] [text]  NULL,
[Society] [varchar]  (500) NULL,
[Certificate] [varchar]  (1000) NULL,
[Train] [varchar]  (1000) NULL,
[DutieID] [int]  NULL,
[GraduationDate] [datetime]  NULL,
[hobbies] [varchar]  (50) NULL,
[Technical] [varchar]  (50) NULL,
[SignedDate] [datetime]  NULL,
[ExpireDate] [datetime]  NULL,
[ProbationDate] [datetime]  NULL)

ALTER TABLE [EmployFiles] WITH NOCHECK ADD  CONSTRAINT [PK_EmployFiles] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[EnumData]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [EnumData]

CREATE TABLE [EnumData] (
[Id] [int]  NOT NULL,
[Name] [varchar]  (100) NULL,
[EnumTypeId] [int]  NULL,
[SortIndex] [int]  NULL,
[Value] [varchar]  (1000) NULL,
[Deleted] [bit]  NULL DEFAULT (0),
[CreateUserId] [varchar]  (50) NULL,
[CreateUserName] [varchar]  (50) NULL,
[CreateDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (50) NULL,
[ModifyUserName] [varchar]  (50) NULL,
[ModifyDate] [datetime]  NULL)

ALTER TABLE [EnumData] WITH NOCHECK ADD  CONSTRAINT [PK_EnumData] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[EnumType]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [EnumType]

CREATE TABLE [EnumType] (
[Id] [int]  NOT NULL,
[Name] [varchar]  (100) NULL,
[Code] [varchar]  (50) NULL,
[Remark] [varchar]  (100) NULL,
[SortIndex] [int]  NULL,
[Deleted] [bit]  NULL DEFAULT (0),
[CreateUserId] [varchar]  (50) NULL,
[CreateUserName] [varchar]  (50) NULL,
[CreateDate] [datetime]  NULL,
[ModifyUserId] [varchar]  (50) NULL,
[ModifyUserName] [varchar]  (50) NULL,
[ModifyDate] [datetime]  NULL)

ALTER TABLE [EnumType] WITH NOCHECK ADD  CONSTRAINT [PK_EnumType] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[FieldAudit]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [FieldAudit]

CREATE TABLE [FieldAudit] (
[Id] [uniqueidentifier]  NOT NULL,
[TableName] [varchar]  (50) NULL,
[RelateId] [uniqueidentifier]  NULL,
[FieldName] [varchar]  (50) NULL,
[BeforeValue] [text]  NULL,
[AfterValue] [text]  NULL,
[CreateUserId] [varchar]  (50) NULL,
[CreateUserName] [varchar]  (50) NULL,
[CreateDate] [datetime]  NULL)

ALTER TABLE [FieldAudit] WITH NOCHECK ADD  CONSTRAINT [PK_FieldAudit] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[Follow]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Follow]

CREATE TABLE [Follow] (
[Id] [int]  NOT NULL,
[UserId] [int]  NULL,
[Fid] [varchar]  (50) NULL,
[Type] [int]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[GeneralComment]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [GeneralComment]

CREATE TABLE [GeneralComment] (
[Id] [int]  NOT NULL,
[UserId] [int]  NULL,
[CreateDate] [datetime]  NULL,
[Content] [text]  NULL,
[IsSystem] [int]  NULL,
[IsPublic] [int]  NULL,
[ToUserId] [int]  NULL,
[CommentType] [varchar]  (100) NULL,
[ValueField] [varchar]  (100) NULL,
[CommentTypeChild] [varchar]  (100) NULL,
[ValueFieldChild] [varchar]  (100) NULL,
[LastReplyDate] [datetime]  NULL)

ALTER TABLE [GeneralComment] WITH NOCHECK ADD  CONSTRAINT [PK_GeneralComment] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[operlogs]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [operlogs]

CREATE TABLE [operlogs] (
[id] [int]  IDENTITY (1, 1)  NOT NULL,
[opertype] [varchar]  (10) NULL,
[tablename] [varchar]  (50) NULL,
[masterkey] [varchar]  (100) NULL,
[opertime] [datetime]  NULL DEFAULT (getdate()),
[s_121_207_232_122] [bit]  NULL)

ALTER TABLE [operlogs] WITH NOCHECK ADD  CONSTRAINT [PK_operlogs] PRIMARY KEY  NONCLUSTERED ( [id] )
SET IDENTITY_INSERT [operlogs] ON


SET IDENTITY_INSERT [operlogs] OFF
if exists (select * from sysobjects where id = OBJECT_ID('[PageState]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [PageState]

CREATE TABLE [PageState] (
[Id] [uniqueidentifier]  NOT NULL,
[UserName] [varchar]  (20) NULL,
[Page] [varchar]  (100) NULL,
[Content] [text]  NULL,
[AddDate] [datetime]  NULL)

ALTER TABLE [PageState] WITH NOCHECK ADD  CONSTRAINT [PK_PageState] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[PM_Info]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [PM_Info]

CREATE TABLE [PM_Info] (
[ProjectID] [int]  NOT NULL,
[Name] [varchar]  (20) NULL,
[ProjectDescription] [varchar]  (255) NULL,
[Status] [varchar]  (8) NULL,
[DeadLine] [datetime]  NULL,
[CreateUserID] [varchar]  (20) NULL,
[CreateTime] [datetime]  NULL,
[ResolveTime] [datetime]  NULL,
[CloseUser] [varchar]  (20) NULL,
[CloseTime] [datetime]  NULL,
[ModifiedUser] [varchar]  (20) NULL,
[ModifiedTime] [datetime]  NULL,
[Deleted] [bit]  NULL,
[ProJoinUser] [varchar]  (100) NULL,
[ProAssigneeId] [int]  NULL)

ALTER TABLE [PM_Info] WITH NOCHECK ADD  CONSTRAINT [PK_PM_Info] PRIMARY KEY  NONCLUSTERED ( [ProjectID] )
if exists (select * from sysobjects where id = OBJECT_ID('[PM_Issue]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [PM_Issue]

CREATE TABLE [PM_Issue] (
[ProjectId] [int]  NULL,
[ModuleId] [int]  NULL,
[AssigneeId] [int]  NULL,
[Title] [varchar]  (100) NULL,
[Description] [text]  NULL,
[Priority] [int]  NULL,
[IssueStatus] [int]  NULL,
[CreateById] [int]  NULL,
[CreateDate] [datetime]  NULL,
[LastEditedBy] [varchar]  (20) NULL,
[LastEditedDate] [datetime]  NULL,
[Progress] [int]  NULL,
[TimePlanBegin] [datetime]  NULL,
[TimePlanEnd] [datetime]  NULL,
[WorkHourPlan] [numeric]  (5,1) NULL,
[CloseBy] [varchar]  (20) NULL,
[CloseDate] [datetime]  NULL,
[TemplateID] [int]  NULL,
[IssueId] [uniqueidentifier]  NOT NULL,
[JoinUser] [varchar]  (100) NULL,
[CustomerId] [uniqueidentifier]  NULL)

ALTER TABLE [PM_Issue] WITH NOCHECK ADD  CONSTRAINT [PK_PM_Issue] PRIMARY KEY  NONCLUSTERED ( [IssueId] )
if exists (select * from sysobjects where id = OBJECT_ID('[PM_IssueAction]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [PM_IssueAction]

CREATE TABLE [PM_IssueAction] (
[ActionBody] [text]  NULL,
[CreateBy] [varchar]  (20) NULL,
[CreateDate] [datetime]  NULL,
[LastEditedBy] [varchar]  (20) NULL,
[LastEditedDate] [datetime]  NULL,
[IssueId] [uniqueidentifier]  NULL,
[ActionID] [uniqueidentifier]  NOT NULL,
[WorkHour] [numeric]  (5,1) NULL,
[ActionState] [int]  NULL,
[Progress] [numeric]  (5,0) NULL,
[CreateById] [int]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[PM_Module]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [PM_Module]

CREATE TABLE [PM_Module] (
[ModuleID] [int]  NOT NULL,
[ProjectID] [int]  NULL,
[ModuleName] [varchar]  (100) NULL,
[ModuleDescription] [text]  NULL,
[CreateUserID] [varchar]  (20) NULL,
[CreateTime] [datetime]  NULL,
[ModifiedUser] [varchar]  (20) NULL,
[ModifiedTime] [datetime]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[PM_Report]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [PM_Report]

CREATE TABLE [PM_Report] (
[UserID] [int]  NULL,
[Report_Tile] [varchar]  (20) NULL,
[ReportDesc] [text]  NULL,
[ReportType] [varchar]  (20) NULL,
[CreateTime] [datetime]  NULL,
[ModifiedTime] [datetime]  NULL,
[ModifiedUser] [varchar]  (20) NULL,
[Attach_ID1] [int]  NULL,
[Attach_ID2] [int]  NULL,
[Deleted] [bit]  NULL,
[AuditUserID] [int]  NULL,
[AuditState] [int]  NULL DEFAULT (0),
[QualityFactor] [decimal]  (2,1) NULL,
[AuditDate] [datetime]  NULL,
[AuditRemark] [varchar]  (200) NULL,
[ReportDate] [datetime]  NULL,
[ReportID] [uniqueidentifier]  NOT NULL DEFAULT (newid()))

ALTER TABLE [PM_Report] WITH NOCHECK ADD  CONSTRAINT [PK_PM_Report] PRIMARY KEY  NONCLUSTERED ( [ReportID] )
if exists (select * from sysobjects where id = OBJECT_ID('[PM_Report_Comment]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [PM_Report_Comment]

CREATE TABLE [PM_Report_Comment] (
[ReviewComment] [varchar]  (1000) NULL,
[CreateUserID] [varchar]  (20) NULL,
[CreateTime] [datetime]  NULL,
[ModifiedTime] [datetime]  NULL,
[ModifiedUser] [varchar]  (20) NULL,
[Attach_ID1] [int]  NULL,
[Attach_ID2] [int]  NULL,
[Deleted] [bit]  NULL,
[ReportID] [uniqueidentifier]  NULL,
[ReportReviewID] [uniqueidentifier]  NOT NULL DEFAULT (newid()))

ALTER TABLE [PM_Report_Comment] WITH NOCHECK ADD  CONSTRAINT [PK_PM_Report_Comment] PRIMARY KEY  NONCLUSTERED ( [ReportReviewID] )
if exists (select * from sysobjects where id = OBJECT_ID('[Prepaid]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Prepaid]

CREATE TABLE [Prepaid] (
[Id] [int]  NOT NULL,
[CustomerId] [uniqueidentifier]  NULL,
[CustomerName] [varchar]  (50) NULL,
[Income] [money]  NULL,
[Expenses] [money]  NULL,
[Balance] [money]  NULL,
[PayWay_id] [int]  NULL,
[Paid_Time] [datetime]  NULL,
[add_time] [datetime]  NULL,
[TrackUserId] [int]  NULL,
[AuditUserId] [int]  NULL,
[isPaid] [int]  NULL,
[remark] [text]  NULL)

ALTER TABLE [Prepaid] WITH NOCHECK ADD  CONSTRAINT [PK_Prepaid] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[ProductAlbum]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [ProductAlbum]

CREATE TABLE [ProductAlbum] (
[ImgUrl] [varchar]  (255) NULL,
[ImgDescription] [varchar]  (64) NULL,
[CreateDate] [datetime]  NULL,
[Big] [varchar]  (255) NULL,
[Small] [varchar]  (255) NULL,
[Thumbnail] [varchar]  (255) NULL,
[ProductId] [uniqueidentifier]  NULL,
[Id] [uniqueidentifier]  NOT NULL,
[IsDefault] [bit]  NULL)

ALTER TABLE [ProductAlbum] WITH NOCHECK ADD  CONSTRAINT [PK_ProductAlbum] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[ProductGroup]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [ProductGroup]

CREATE TABLE [ProductGroup] (
[Id] [int]  NOT NULL,
[Name] [varchar]  (50) NULL,
[Remark] [varchar]  (100) NULL)

ALTER TABLE [ProductGroup] WITH NOCHECK ADD  CONSTRAINT [PK_ProductGroup] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[ProductGroupItem]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [ProductGroupItem]

CREATE TABLE [ProductGroupItem] (
[Id] [int]  NOT NULL,
[GroupId] [int]  NULL,
[SkuId] [uniqueidentifier]  NULL)

ALTER TABLE [ProductGroupItem] WITH NOCHECK ADD  CONSTRAINT [PK_ProductGroupItem] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[ReplyComment]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [ReplyComment]

CREATE TABLE [ReplyComment] (
[Id] [int]  NOT NULL,
[UserId] [int]  NULL,
[ReplyId] [int]  NULL,
[ReplyUserId] [int]  NULL,
[CreateDate] [datetime]  NULL,
[Content] [text]  NULL,
[CommentId] [int]  NULL,
[IsSystem] [int]  NULL,
[IsPublic] [int]  NULL,
[ToUserId] [int]  NULL,
[ActionId] [uniqueidentifier]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[SavedSearch]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SavedSearch]

CREATE TABLE [SavedSearch] (
[Id] [uniqueidentifier]  NOT NULL,
[Deleted] [bit]  NULL,
[CreatedUserId] [int]  NULL,
[CreatedDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (1) NULL,
[ModifyDate] [datetime]  NULL,
[Title] [varchar]  (150) NULL,
[ModuleName] [varchar]  (150) NULL,
[Contents] [text]  NULL,
[AdvancedContents] [varchar]  (100) NULL,
[Order] [int]  NULL,
[Description] [text]  NULL,
[IsSystem] [bit]  NULL,
[IsDefault] [int]  NULL,
[IsDisplay] [int]  NULL,
[MenuKey] [varchar]  (50) NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[Shop]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Shop]

CREATE TABLE [Shop] (
[Id] [int]  NOT NULL,
[ShopName] [varchar]  (50) NULL,
[ShopType] [int]  NULL,
[ShopCode] [varchar]  (50) NULL,
[NickName] [varchar]  (50) NULL,
[SessionKey] [varchar]  (100) NULL,
[Token] [varchar]  (100) NULL,
[LastDate] [datetime]  NULL)

ALTER TABLE [Shop] WITH NOCHECK ADD  CONSTRAINT [PK_Shop] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[SMSFinance]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SMSFinance]

CREATE TABLE [SMSFinance] (
[ID] [uniqueidentifier]  NOT NULL,
[CustomerID] [uniqueidentifier]  NULL,
[Amount] [money]  NULL DEFAULT (0),
[CreateDate] [datetime]  NULL,
[ModifyDate] [datetime]  NULL)

ALTER TABLE [SMSFinance] WITH NOCHECK ADD  CONSTRAINT [PK_SMSFinance] PRIMARY KEY  NONCLUSTERED ( [ID] )
if exists (select * from sysobjects where id = OBJECT_ID('[SMSPayDetail]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SMSPayDetail]

CREATE TABLE [SMSPayDetail] (
[Id] [uniqueidentifier]  NOT NULL,
[CustomerID] [uniqueidentifier]  NULL,
[Amount] [money]  NULL,
[EnterMan] [varchar]  (50) NULL,
[EnterDate] [datetime]  NULL,
[AuditState] [int]  NULL,
[AuditMan] [varchar]  (50) NULL,
[AuditDate] [datetime]  NULL,
[EnterRemark] [varchar]  (100) NULL,
[AuditRemark] [varchar]  (100) NULL,
[PayType] [varchar]  (30) NULL)

ALTER TABLE [SMSPayDetail] WITH NOCHECK ADD  CONSTRAINT [PK_SMSPayDetail] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[SmsTask]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SmsTask]

CREATE TABLE [SmsTask] (
[Id] [uniqueidentifier]  NOT NULL,
[Mobile] [varchar]  (500) NULL,
[Content] [varchar]  (500) NULL,
[State] [int]  NULL,
[CreateDate] [datetime]  NULL,
[SendDate] [datetime]  NULL,
[PromoteId] [uniqueidentifier]  NULL,
[TaskType] [varchar]  (20) NULL,
[ResourceId] [uniqueidentifier]  NULL,
[RealName] [varchar]  (20) NULL,
[AwokeClass] [int]  NULL)

ALTER TABLE [SmsTask] WITH NOCHECK ADD  CONSTRAINT [PK_SmsTask] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[SMSTaskGateway]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SMSTaskGateway]

CREATE TABLE [SMSTaskGateway] (
[Id] [uniqueidentifier]  NOT NULL,
[CustomerID] [uniqueidentifier]  NULL,
[Mobile] [varchar]  (50) NULL,
[Content] [text]  NULL,
[State] [varchar]  (10) NULL,
[Remark] [varchar]  (50) NULL,
[SmsType] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateMan] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyMan] [varchar]  (20) NULL,
[SendDate] [datetime]  NULL)

ALTER TABLE [SMSTaskGateway] WITH NOCHECK ADD  CONSTRAINT [PK_SMSTaskGateway] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[SMSTemplate]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SMSTemplate]

CREATE TABLE [SMSTemplate] (
[Id] [int]  NOT NULL,
[TempType] [int]  NULL,
[TempTitle] [varchar]  (50) NULL,
[Content] [varchar]  (1000) NULL,
[Enabled] [int]  NULL,
[CreateDate] [datetime]  NULL,
[CreateUserName] [varchar]  (20) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (20) NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[SmtpAccount]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SmtpAccount]

CREATE TABLE [SmtpAccount] (
[Id] [uniqueidentifier]  NOT NULL,
[SmtpHost] [varchar]  (100) NULL,
[SmtpPort] [int]  NULL,
[UserName] [varchar]  (100) NULL,
[Password] [varchar]  (50) NULL,
[EnableSsl] [bit]  NULL,
[FromAddress] [varchar]  (100) NULL,
[FailCount] [int]  NULL,
[Enabled] [int]  NULL,
[SendNum] [int]  NULL,
[Type] [int]  NULL)

ALTER TABLE [SmtpAccount] WITH NOCHECK ADD  CONSTRAINT [PK_SmtpAccount] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[SysTemplate]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [SysTemplate]

CREATE TABLE [SysTemplate] (
[Id] [uniqueidentifier]  NOT NULL,
[Type] [varchar]  (20) NULL,
[TemplateCode] [varchar]  (50) NULL,
[Html] [text]  NULL,
[Css] [text]  NULL,
[CreateDate] [datetime]  NULL,
[ModifyDate] [datetime]  NULL)

ALTER TABLE [SysTemplate] WITH NOCHECK ADD  CONSTRAINT [PK_SysTemplate] PRIMARY KEY  NONCLUSTERED ( [Id] )
if exists (select * from sysobjects where id = OBJECT_ID('[UserConfig]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [UserConfig]

CREATE TABLE [UserConfig] (
[Id] [uniqueidentifier]  NOT NULL,
[UserId] [int]  NULL,
[Name] [varchar]  (50) NULL,
[Content] [varchar]  (50) NULL,
[CreateDate] [datetime]  NULL,
[CreateUserName] [varchar]  (50) NULL,
[CreateUserId] [varchar]  (50) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyUserName] [varchar]  (50) NULL,
[ModifyUserId] [varchar]  (50) NULL,
[Deleted] [int]  NULL)

if exists (select * from sysobjects where id = OBJECT_ID('[Version]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [Version]

CREATE TABLE [Version] (
[id] [int]  NOT NULL,
[version] [varchar]  (30) NULL,
[UpgradeDate] [datetime]  NULL,
[Remark] [varchar]  (100) NULL)

ALTER TABLE [Version] WITH NOCHECK ADD  CONSTRAINT [PK_Version] PRIMARY KEY  NONCLUSTERED ( [id] )
if exists (select * from sysobjects where id = OBJECT_ID('[WorkPoints]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
DROP TABLE [WorkPoints]

CREATE TABLE [WorkPoints] (
[Points] [int]  NULL,
[TotalPoints] [int]  NULL,
[UserID] [int]  NULL,
[StatDate] [datetime]  NULL,
[Remark] [varchar]  (200) NULL,
[PointCode] [varchar]  (100) NULL,
[ModifyDate] [datetime]  NULL,
[ModifyMan] [varchar]  (50) NULL,
[ID] [uniqueidentifier]  NOT NULL DEFAULT (newid()))

ALTER TABLE [WorkPoints] WITH NOCHECK ADD  CONSTRAINT [PK_WorkPoints] PRIMARY KEY  NONCLUSTERED ( [ID] )
