﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="BaseAnnounceList.aspx.cs" Inherits="OAWeb.Announce.BaseAnnounceList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlace" runat="server">
    <!--主体-->
    <div class="page_main">
        <div class="page_content">
            <table class="data_title" cellspacing="3">
                <tr>
                    <td class="data_caption">
                        公告管理
                    </td>
                </tr>
                <tr>
                    <td class="data_field">
                        标题：<asp:TextBox ID="txtTitle" runat="server" CssClass="text_box"></asp:TextBox>
                        <asp:Button ID="btnSearch" runat="server" Text="搜 索" CssClass="btn_77px" />
                    </td>
                </tr>
            </table>
            <div class="page_op">
                <asp:Button ID="btnNewUser" runat="server" Text="新增公告" CssClass="btn_77px" OnClientClick="return OpenDialog('/Announce/BaseAnnounceEdit.aspx','新增公告');" />
                <asp:Button ID="BtnDelete" runat="server" Text="删除公告" CssClass="btn_77px" />
                <asp:Button ID="btnType" runat="server" Text="类型管理" CssClass="btn_77px" OnClientClick="return OpenDialog('BaseAnnounceTypeList.aspx','类型管理');" />
            </div>
            <div class="list">
                <asp:GridView ID="gvData" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                    GridLines="None" OnRowDataBound="gvData_RowDataBound" CellPadding="0" CssClass="table_list"
                    EnableModelValidation="True">
                    <RowStyle HorizontalAlign="Left" />
                    <Columns>
                        <asp:TemplateField HeaderText="编号">
                            <HeaderTemplate>
                                <input name="chkHeader" onclick="javascript:SelectAll(this);" type="checkbox" value="chkHeader" />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <input id="chkItem" type="checkbox" value="<%#Eval("Id") %>" />
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" ForeColor="White"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="10px"></ItemStyle>
                        </asp:TemplateField>
                        <asp:HyperLinkField DataNavigateUrlFields="Id" DataNavigateUrlFormatString="BaseAnnounceView.aspx?Id={0}"
                            DataTextField="Title" HeaderText="标题" />
                        <asp:BoundField DataField="CreateUserName" HeaderText="发布人"></asp:BoundField>
                        <asp:BoundField DataField="CreateDate" HeaderText="发布时间"></asp:BoundField>
                        <asp:TemplateField HeaderText="显示状态">
                            <ItemTemplate>
                                <img class='<%#Eval("Visible").ToString() == "False" ? "ico02" : "ico01"%>' src="/images/transparent.gif" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbtnAudit" runat="server" CommandName="cmdAudit">审批</asp:LinkButton>
                                <asp:LinkButton ID="lbtnEdit" runat="server">编辑</asp:LinkButton>
                                <asp:LinkButton ID="lbtnDelete" runat="server">删除</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <div class="pager-bar">
                    <webdiyer:AspNetPager ID="pager" runat="server" CssClass="anpager" currentpagebuttonclass="cpb"
                        PageSize="20" NextPageText="下一页" LastPageText="页 尾" FirstPageText="第一页" PrevPageText="上一页"
                        ShowBoxThreshold="10" SubmitButtonText="跳 转" UrlPaging="True">
                    </webdiyer:AspNetPager>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
