<?php
//defined('IN_PHPCMS') or exit('No permission resources.');

class okcollection {
		
	protected static $url,$config;
	
	/**
	 * 采集内容
	 * @param string $url    采集地址
	 * @param array $config  配置参数
	 * @param integer $page  分页采集模式
	 */
	public static function get_content($html, $config) {
		set_time_limit(300);
		$html = str_replace(array("\r", "\n"), '', $html);
		$arr=explode('<item>',$html);
		$data=array();
		foreach($arr as $k=>$v){
			if($k==0) continue;
			if ($config['customize_config']) {
				foreach ($config['customize_config'] as $key=>$val) {
					if (empty($val['rule'])) continue;
					$rule =  self::replace_sg($val['rule']);
					$data[$k][$val['en_name']] = self::replace_item(self::cut_html($v, $rule[0], $rule[1]), $val['html_rule']);
				}
			}
		}
		return $data;
	}
	
	/**
	 * 转换图片地址为绝对路径，为下载做准备。
	 * @param array $out 图片地址
	 */
	protected static function download_img($old, $out) {
		if (!empty($old) && !empty($out) && strpos($out, '://') === false) {
			return str_replace($out, self::url_check($out, self::$url, self::$config), $old);
		} else {
			return $old;
		}
	}
	
	/**
	 * 得到需要采集的网页列表页
	 * @param array $config 配置参数
	 * @param integer $num  返回数
	 */
	public static function url_list(&$config, $num = '') {
		$url = array();
		switch ($config['sourcetype']) {
			case '1'://序列化
				$num = empty($num) ? $config['pagesize_end'] : $num;
				for ($i = $config['pagesize_start']; $i <= $num; $i = $i + $config['par_num']) {
					$url[$i] = str_replace('(*)', $i, $config['urlpage']);
				}
				break;
			case '2'://多网址
				$url = explode("\r\n", $config['urlpage']);
				break;
			case '3'://单一网址
			case '4'://RSS
				$url[] = $config['urlpage'];
				break;
		}
		return $url;
	}
	
	/**
	 * 获取文章网址
	 * @param string $url           采集地址
	 * @param array $config         配置
	 */
	public static function get_url_lists($url, &$config) {
		if ($html = self::get_html($url, $config)) {
			if ($config['sourcetype'] == 4) { //RSS
				$xml = pc_base::load_sys_class('xml');
				$html = $xml->xml_unserialize($html);
				if (pc_base::load_config('system', 'charset') == 'gbk') {
					$html = array_iconv($html, 'utf-8', 'gbk');
				}
				$data = array();
				if (is_array($html['rss']['channel']['item']))foreach ($html['rss']['channel']['item'] as $k=>$v) {
					$data[$k]['url'] = $v['link'];
					$data[$k]['title'] = $v['title'];
				}
			} else {
				$data = array();
				$data[0]['total']=self::get_page($html,$config);
				$html = self::cut_html($html, $config['url_start'], $config['url_end']);
				$html = str_replace(array("\r", "\n"), '', $html);
				$html = str_replace(array("</a>", "</A>"), "</a>\n", $html);
				
				preg_match_all('/<a([^>]*)>([^\/a>].*)<\/a>/i', $html, $out);
				$out[1] = array_unique($out[1]);
				$out[2] = array_unique($out[2]);
				
				foreach ($out[1] as $k=>$v) {
					if (preg_match('/href=[\'"]?([^\'" ]*)[\'"]?/i', $v, $match_out)) {
						if ($config['url_contain']) {
							if (strpos($match_out[1], $config['url_contain']) === false) {
								continue;
							} 
						}
	
						if ($config['url_except']) {
							if (strpos($match_out[1], $config['url_except']) !== false) {
								continue;
							} 
						}
						$url2 = $match_out[1];
						$url2 = self::url_check($url2, $url, $config);
						
						$data[$k]['url'] = $url2;
						$data[$k]['title'] = strip_tags($out[2][$k]);
					} else {
						continue;
					}
				}
				
			}
			return $data;
		} else {
			return false;
		}
	}
	/**
	 * 获取分类
	 * @param string $url           采集地址
	 * @param array $config         配置
	 */
	public static function get_class_lists($html, &$config) {
		if ($html) {
			$html = self::cut_html($html, $config['class_start'], $config['class_end']);
			$html = str_replace(array("\r", "\n"), '', $html);
			$html = str_replace(array("</a>", "</A>"), "</a>\n", $html);
			preg_match_all('/<cid>([^>]*)<\/cid>/i', $html, $cids);
			preg_match_all('/<cname>([^>]*)<\/cname>/i', $html, $cnames);
			
			$out[1] = array_unique($cids[0]);
			$out[2] = array_unique($cnames[0]);
			$data = array();
			foreach ($out[1] as $k=>$v) {
				if (preg_match('/<cid>(.*)<\/cid>/i', $v, $match_out)) {
					preg_match('/<cname>(.*)<\/cname>/i', $out[2][$k], $match_out2);
					$data[$k]['cid'] =$match_out[1];
					$data[$k]['cname'] =$match_out2[1];
				} else {
					continue;
				}
			}
			return $data;
		} else {
			return false;
		}
	}
	public static function get_pageinfo($html, &$config) {
		if ($html) {
			$html = self::cut_html($html, $config['page_start'], $config['page_end']);
			$html = str_replace(array("\r", "\n"), '', $html);
			$data = array();
			//获取总数
			if ($config['total']) {
				$total_rule =  self::replace_sg($config['total']);
				$data['total'] = self::cut_html($html,$total_rule[0], $total_rule[1]);
			}
			if ($config['curpage']) {
				$curpage_rule =  self::replace_sg($config['curpage']);
				$data['curpage'] = self::cut_html($html,$curpage_rule[0], $curpage_rule[1]);
			}
			if ($config['pagenum']) {
				$pagenum_rule =  self::replace_sg($config['pagenum']);
				$data['pagenum'] = self::cut_html($html,$pagenum_rule[0], $pagenum_rule[1]);
			}
			return $data;
		} else {
			return false;
		}
	}
	
	/**
	 * 获取远程HTML
	 * @param string $url    获取地址
	 * @param array $config  配置
	 */
	protected static function get_html($url, &$config) {
		if (!empty($url) && $html = @file_get_contents($url)) {
			if (CHARSET != $config['sourcecharset'] && $config['sourcetype'] != 4) {
				$html = iconv($config['sourcecharset'], CHARSET.'//IGNORE', $html);
			}
			return $html;
		} else {
			return false;
		}
	}
	
	/**
	 * 
	 * HTML切取
	 * @param string $html    要进入切取的HTML代码
	 * @param string $start   开始
	 * @param string $end     结束
	 */
	protected static function cut_html($html, $start, $end) {
		if (empty($html)) return false;
		$html = str_replace(array("\r", "\n"), "", $html);
		$start = str_replace(array("\r", "\n"), "", $start);
		$end = str_replace(array("\r", "\n"), "", $end);
		$html = explode(trim($start), $html);
		if(is_array($html)) $html = explode(trim($end), $html[1]);
		return $html[0];
	}
	
	/**
	 * 过滤代码
	 * @param string $html  HTML代码
	 * @param array $config 过滤配置
	 */
	protected static function replace_item($html, $config) {
		if (empty($config)) return $html;
		$config = explode("\n", $config);
		$patterns = $replace = array();
		$p = 0;
		foreach ($config as $k=>$v) {
			if (empty($v)) continue;
			$c = explode('[|]', $v);
			$patterns[$k] = '/'.str_replace('/', '\/', $c[0]).'/i';
			$replace[$k] = $c[1];
			$p = 1;
		}
		return $p ? @preg_replace($patterns, $replace, $html) : false;
	}
	
	/**
	 * 替换采集内容
	 * @param $html 采集规则
	 */
	protected static function replace_sg($html) {
		$list = explode('[内容]', $html);
		if (is_array($list)) foreach ($list as $k=>$v) {
			$list[$k] = str_replace(array("\r", "\n"), '', trim($v));
		}
		return $list;
	}
	
	/**
	 * URL地址检查
	 * @param string $url      需要检查的URL
	 * @param string $baseurl  基本URL
	 * @param array $config    配置信息
	 */
	protected static function url_check($url, $baseurl, $config) {
		$urlinfo = parse_url($baseurl);
		
		$baseurl = $urlinfo['scheme'].'://'.$urlinfo['host'].(substr($urlinfo['path'], -1, 1) === '/' ? substr($urlinfo['path'], 0, -1) : str_replace('\\', '/', dirname($urlinfo['path']))).'/';
		if (strpos($url, '://') === false) {
			if ($url[0] == '/') {
				$url = $urlinfo['scheme'].'://'.$urlinfo['host'].$url;
			} else {
				if ($config['page_base']) {
					$url = $config['page_base'].$url;
				} else {
					$url = $baseurl.$url;
				}
			}
		}
		return $url;
	}
	/**
	 * 
	 * 获取总数、页数
	 * @param string $html    要进入切取的HTML代码
	 * @param string $start   开始
	 * @param string $end     结束
	 */
	protected static function get_page($html, $config) {
		if (empty($html)) return false;
		$html = str_replace(array("\r", "\n"), "", $html);
		$total_start = str_replace(array("\r", "\n"), "", $config['total_start']);
		$total_end = str_replace(array("\r", "\n"), "", $config['total_end']);
		$page=array();
		$total=explode(trim($total_start), $html);
		$total=explode(trim($total_end), $total[1]);
		return $total=$total[0];
	}
}