<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class ZibanmaBase{
	public $_common;
	public $_db;
	public $_view;
	public $_request;
	public $_zibanma;
	public static $_base;
	public $_session;
	
	private function __construct(){
		$this->_db = ZibanmaDatabase::get_instance();
		$this->_view = ZibanmaView::get_instance();
		$this->_common = new ZibanmaCommon();
		$this->_request = new ZibanmaRequest();
		$this->_zibanma = Zibanma::get_instance();
		if(!$_SESSION['global']){
			$_SESSION['global'] = $this->_zibanma;
			$navigation_model = new NavigationModel();
			$_SESSION['global']->navigation = $navigation_model->zibanma_navigation_list();
			$config_model = new ConfigModel();
			$_SESSION['global']->site_config = $config_model->zibanma_get_sys_config('global');
		}
		$this->_session = $_SESSION['global'];
	}
	
	public static function get_instance(){
		if(!(self::$_base instanceof self)){
			self::$_base = new self();
		}
		return self::$_base;
	}
	
	public function table($table){
		if($table){
			return Database::get_instance($table);
		}
	}
	
	public function view($templateName, $assign){
		if($templateName){
			return $this->_view->make($templateName, $assign);
		}
	}
}
?>