<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
class PicModel{
	private $_model;
	public function __construct(){
		$this->_model = ZibanmaModel::get_instance();
	}
	
	/**
	 * 添加分类
	 * @param array $post
	 */
	public function zibanma_category_add($post){
		if($post){
			return $this->_model->_db->execute("insert into ".ZIBANMA_DB_PREFIX."pic_category (category_name, category_keywords, category_description) values ('{$post[category_name]}', '{$post[category_keywords]}',  '{$post[category_description]}'); ");
		}
		return null;
	}
	
	/**
	 * 获取分类列表
	 * @param $sort desc/asc
	 */
	public function zibanma_get_category_list($sort='asc'){
		return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."pic_category where status=1 order by sort {$sort}; ");
	}
	
	/**
	 * 获取分类信息
	 */
	public function zibanma_get_category_info_by_id($id){
		if($id>0){
			return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."pic_category where status=1 and id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 更新分类信息
	 */
	public function zibanma_update_category_info($post){
		if($post){
			$post['id'] = intval($post['id']);
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."pic_category set category_name='{$post[category_name]}',category_keywords='{$post[category_keywords]}',category_description='{$post[category_description]}' where id={$post[id]} ; ");
		}
		return null;
	}
	
	/**
	 * 删除分类
	 */
	public function zibanma_delete_category($id){
		if($id>0){
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."pic_category set status=0 where id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 更新排序
	 * @param $arr id/value
	 */
	public function zibanma_update_category_sort($arr){
		if($arr){
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."pic_category set sort={$arr[value]} where id={$arr[id]}; ");
		}
	}
	
	/**
	 * 添加相册
	 * @param array $post
	 */
	public function zibanma_album_add($post){
		if($post){
			$post['category'] = $post['category'] ? intval($post['category']) : 0;
			$post['click'] = $post['click'] ? intval($post['click']) : 0;
			$post['create_time'] = $post['create_time'] ? strtotime($post['create_time']) : time();
			return $this->_model->_db->execute("insert into ".ZIBANMA_DB_PREFIX."pic_album (title, keywords, description, content, click, create_user, create_time, category, status) values ('{$post[title]}', '{$post[keywords]}',  '{$post[description]}','{$post[content]}', {$post[click]}, '{$post[create_user]}', '{$post[create_time]}', {$post[category]}, 1); ");
		}
		return null;
	}
	
	/**
	 * 记录统计
	 */
	public function zibanma_get_album_count($set){
		if($set->category_id != 0){
			$search = " and category={$set->category_id}";
		}
		$rs = $this->_model->_db->query("select count(id) as count from ".ZIBANMA_DB_PREFIX."pic_album where status=1 {$search}; ");
		return $rs[0]->count;
	}
	
	/**
	 * 相册列表
	 * Obejct $set
	 * $set->category_id
	 * $set->page_current
	 * $set->page_size
	 * $set->first_limit
	 * $set->end_limit
	 * $set->sort
	 * @return object
	 */
	public function zibanma_get_album_list($set){
		if($set->category_id != 0){
			$search = " and cat.id={$set->category_id}";
		}
		$sql = "select cat.id category_id,cat.*,album.id album_id,album.* from ".ZIBANMA_DB_PREFIX."pic_category cat left join ".ZIBANMA_DB_PREFIX."pic_album album
		on cat.id=album.category where cat.status=1 and album.status=1 {$search} order by album.id {$set->sort} limit {$set->first_limit},{$set->end_limit}; ";
		$set->rs = $this->_model->_db->query($sql);
		$set->count = $this->zibanma_get_album_count($set);
		$set->links = $this->_model->_page->links($set, $set->links, $this->_model->_common);
		return $set;
	}
	
	/**
	 * 获取相册信息
	 */
	public function zibanma_get_album_info_by_id($id){
		if($id>0){
			return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."pic_album where status=1 and id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 更新相册
	 */
	public function zibanma_update_album_info($post){
		if($post){
			$post['id'] = $post['id'] ? intval($post['id']) : 0;
			$post['title'] = $post['title'] != '' ? trim($post['title']) : '相册没有标题';
			$post['keywords'] = $post['keywords'] != '' ? $post['keywords'] : $post['title'];
			$post['description'] = $post['description'] != '' ? $post['description'] : $post['title'];
			$post['content'] = $post['content'] != '' ? $post['content'] : '本文没有内容';
			$post['category'] = $post['category'] != '' ? intval($post['category']) : 0;
			$post['click'] = $post['click'] != '' ? intval($post['click']) : 0;
			$post['create_user'] = $post['create_user'] != '' ? trim($post['create_user']) : $post['author'];
			$post['create_time'] = $post['create_time'] != '' ? strtotime(trim($post['create_time'])) : time();
			$sql = "update ".ZIBANMA_DB_PREFIX."pic_album set title='{$post[title]}',keywords='{$post[keywords]}',description='{$post[description]}',
			content='{$post[content]}',category={$post[category]},click={$post[click]},create_user='{$post[create_user]}',create_time={$post[create_time]} where id={$post[id]} ; ";
			return $this->_model->_db->execute($sql);
		}
		return null;
	}
	
	/**
	 * 删除相册
	 */
	public function zibanma_delete_album($id){
		if($id>0){
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."pic_album set status=0 where id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 查询用户是否存在
	 * return boolean
	 */
	public function zibanma_select_user_is_exists($user){
		if($user){
			$rs = $this->_model->_db->query("select count(id) as count from ".ZIBANMA_DB_PREFIX."member_user where status=1 and user='{$user}'; ");
			return $rs[0]->count>0 ? true : false;
		}
		return false;
	}
	
	/**
	 * 获取用户相册列表
	 */
	public function zibanma_user_album_list($user){
		if($user){
			return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."pic_album where status=1 and create_user='{$user}' order by id desc; ");
		}
		return null;
	}
	
	/**
	 * 添加图片
	 * @param array $post
	 * @return boolean
	 */
	public function zibanma_user_graph_add($post){
		$post['album'] = $post['album'] ? intval($post['album']) : 0;
		$post['create_time'] = $post['create_time'] ? strtotime($post['create_time']) : time();
		$post['click'] = $post['click'] ? intval($post['click']) : 0;
		$set_arr = array();
		$graph_arr = explode(',', $post['graph']);
		if(count($graph_arr)){
			foreach ($graph_arr as $v){
				$post['graph'] = ZIBANMA_SYS_APP_ROOT.$v;
				$this->_model->_thumb->build($post['graph']);
				if($this->_model->_thumb->get_status()){
					$temp = explode('.', $v);
					$temp[0] .= '_small';
					$post['pic_thumb_small'] = implode('.', $temp);
					$post['pic_thumb_big'] = $v;
					$post['pic_original'] = $v;
					$set_arr[] = $post;
				}
			}
		}
		if(count($set_arr)){
			foreach ($set_arr as $v){
				$sql = "insert into ".ZIBANMA_DB_PREFIX."pic_graph (content, keywords, description, pic_thumb_small, pic_thumb_big, pic_original, create_user, create_time, album, click, status)
				values ('{$v['content']}', '{$v['keywords']}', '{$v['description']}', '{$v['pic_thumb_small']}', '{$v['pic_thumb_big']}', '{$v['pic_original']}', '{$v['create_user']}', {$v['create_time']}, {$v['album']}, {$v['click']}, 1)";
				$this->_model->_db->execute($sql);
			}
			return true;
		}
		return false;
	}
	
	/**
	 * 记录统计图片
	 */
	public function zibanma_get_graph_count($set){
		if($set->category_id != 0){
			$search = " and album={$set->category_id}";
		}
		$rs = $this->_model->_db->query("select count(id) as count from ".ZIBANMA_DB_PREFIX."pic_graph where status=1 {$search}; ");
		return $rs[0]->count;
	}
	
	/**
	 * 图片列表
	 * Obejct $set
	 * $set->category_id
	 * $set->page_current
	 * $set->page_size
	 * $set->first_limit
	 * $set->end_limit
	 * $set->sort
	 * @return object
	 */
	public function zibanma_get_graph_list($set){
		if($set->category_id != 0){
			$search = " and graph.album={$set->category_id}";
		}
		$sql = "select graph.id graph_id,graph.*,album.id album_id,album.title album_title,album.* from ".ZIBANMA_DB_PREFIX."pic_graph graph left join ".ZIBANMA_DB_PREFIX."pic_album album
		on graph.album=album.id where graph.status=1 and album.status=1 {$search} order by graph.id {$set->sort} limit {$set->first_limit},{$set->end_limit}; ";
		$set->rs = $this->_model->_db->query($sql);
		$set->count = $this->zibanma_get_graph_count($set);
		$set->links = $this->_model->_page->links($set, $set->links, $this->_model->_common);
		return $set;
	}
	
	/**
	 * 获取图片信息
	 */
	public function zibanma_get_graph_info_by_id($id){
		if($id>0){
			return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."pic_graph where status=1 and id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 更新图片
	 */
	public function zibanma_update_garph_info($post){
		if($post){
			$post['id'] = $post['id'] ? intval($post['id']) : 0;
			$post['keywords'] = $post['keywords'] != '' ? $post['keywords'] : $post['title'];
			$post['description'] = $post['description'] != '' ? $post['description'] : $post['title'];
			$post['content'] = $post['content'] != '' ? $post['content'] : '本文没有内容';
			$post['click'] = $post['click'] != '' ? intval($post['click']) : 0;
			$post['create_user'] = $post['create_user'] != '' ? trim($post['create_user']) : 'guest';
			$post['create_time'] = $post['create_time'] != '' ? strtotime(trim($post['create_time'])) : time();
			$sql = "update ".ZIBANMA_DB_PREFIX."pic_graph set keywords='{$post[keywords]}',description='{$post[description]}',content='{$post[content]}',
			click={$post[click]},create_user='{$post[create_user]}',create_time={$post[create_time]} where id={$post[id]} ; ";
			return $this->_model->_db->execute($sql);
		}
		return null;
	}
	
	/**
	 * 删除图片
	 */
	public function zibanma_delete_graph($id){
		if($id>0){
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."pic_graph set status=0 where id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 获取频道列表
	 */
	public function zibanma_channel_list(){
		$category = $this->zibanma_get_category_list();
		if($category && count($category)){
			foreach ($category as $v){
				$v->article = $this->_model->_db->query("select id,title,create_user,create_time from [prefix]pic_album where category={$v->id} and status=1 order by id desc limit 8;");
			}
		}
		return $category;
	}
	
	/**
	 * 热门文章列表
	 */
	public function zibanma_get_host_list($limit=10){
		return $this->_model->_db->query("select id,title from [prefix]pic_album where status=1 order by id desc limit {$limit};");
	}
	
	/**
	 * 随机相册列表
	 */
	public function zibanma_get_random_list($limit=10){
		return $this->_model->_db->query("select id,title from [prefix]pic_album where status=1 order by rand() limit {$limit};");
	}
	
	/**
	 * 最新图片列表
	 */
	public function zibanma_get_new_graph_list($limit=10){
		return $this->_model->_db->query("select gra.id,gra.pic_thumb_small,gra.pic_thumb_big,album.title from [prefix]pic_graph gra left join [prefix]pic_album album on gra.album=album.id where gra.status=1 order by gra.id desc limit {$limit};");
	}
	
	/**
	 * 更新点击
	 */
	public function zibanma_update_cilck($id){
		$interval = explode(',', ZIBANMA_CLICK_NUM);
		if($interval[0]>=0 && $interval[1]>0){
			$click = rand(intval($interval[0]), intval($interval[1]));
			$this->_model->_db->query("update [prefix]pic_album set click=click+{$click} where id={$id};");
		}else{
			echo '点击随机增量设置异常！';
		}
	}
}
?>