<?php
/**
 * 紫斑马软件
 * email:service@zibanma.com
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class PicControl{
	private $_base;
	
	public function __construct(){
		$this->_base = ZibanmaBase::get_instance();
	}
	
	public function zibanma_index(){
		$pic = new PicModel();
		$assign = array(
			'navigation' => $this->_base->_session->navigation,
			'site_config' => $this->_base->_session->site_config,
			'channel_list' => $pic->zibanma_channel_list(),
			'hot_list' => $pic->zibanma_get_host_list(),
			'random_list' => $pic->zibanma_get_random_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('pic.index', $assign);
	}
	
	public function zibanma_category(){
		$param = $this->_base->_request->get_parameter();
		$set = $this->_base->_zibanma;
		$set->category_id = $param[2] ? intval($param[2]) : 0;
		$set->page_current = $param[3] ? intval($param[3]) : 1;
		$set->page_size = 20;
		$set->first_limit = $set->page_current * $set->page_size - $set->page_size;
		$set->end_limit = $set->page_size;
		$set->sort = 'desc';
		$set->links = array('pic','category');
		$pic = new PicModel();
		$assign = array(
			'navigation' => $this->_base->_session->navigation,
			'site_config' => $this->_base->_session->site_config,
			'category_info' => $pic->zibanma_get_category_info_by_id($set->category_id),
			'album_list' => $pic->zibanma_get_album_list($set),
			'hot_list' => $pic->zibanma_get_host_list(),
			'random_list' => $pic->zibanma_get_random_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('pic.category', $assign);
	}
	
	public function zibanma_album(){
		$param = $this->_base->_request->get_parameter();
		$set = $this->_base->_zibanma;
		$set->category_id = $param[2] ? intval($param[2]) : 0;
		$set->page_current = $param[3] ? intval($param[3]) : 1;
		$set->page_size = 20;
		$set->first_limit = $set->page_current * $set->page_size - $set->page_size;
		$set->end_limit = $set->page_size;
		$set->sort = 'desc';
		$set->links = array('pic','album');
		$pic = new PicModel();
		$album_info = $pic->zibanma_get_album_info_by_id($set->category_id);
		$assign = array(
			'navigation' => $this->_base->_session->navigation,
			'site_config' => $this->_base->_session->site_config,
			'album_info' => $album_info[0],
			'graph_list' => $pic->zibanma_get_graph_list($set),
			'hot_list' => $pic->zibanma_get_host_list(),
			'random_list' => $pic->zibanma_get_random_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('pic.album', $assign);
	}
}
?>