<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class NewsControl{
	private $_base;
	
	public function __construct(){
		$this->_base = ZibanmaBase::get_instance();
	}
	
	public function zibanma_index(){
		$news = new NewsModel();
		$assign = array(
			'navigation' => $this->_base->_session->navigation,
			'site_config' => $this->_base->_session->site_config,
			'channel_list' => $news->zibanma_channel_list(),
			'hot_list' => $news->zibanma_get_host_list(),
			'random_list' => $news->zibanma_get_random_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('news.index', $assign);
	}
	
	public function zibanma_category(){
		$param = $this->_base->_request->get_parameter();
		$set = $this->_base->_zibanma;
		$set->category_id = $param[2] ? intval($param[2]) : 0;
		$set->page_current = $param[3] ? intval($param[3]) : 1;
		$set->page_size = 20;
		$set->first_limit = $set->page_current * $set->page_size - $set->page_size;
		$set->end_limit = $set->page_size;
		$set->sort = 'desc';
		$set->links = array('news','category');
		$news = new NewsModel();
		$assign = array(
			'navigation' => $this->_base->_session->navigation,
			'site_config' => $this->_base->_session->site_config,
			'category_info' => $news->zibanma_get_category_info_by_id($set->category_id),
			'article_list' => $news->zibanma_get_article_list($set),
			'hot_list' => $news->zibanma_get_host_list(),
			'random_list' => $news->zibanma_get_random_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('news.category', $assign);
	}
	
	public function zibanma_article(){
		$param = $this->_base->_request->get_parameter();
		$news = new NewsModel();
		$id = isset($param[2]) ? intval($param[2]) : 0;
		$article_info = $news->zibanma_get_article_info($id);
		$assign = array(
			'navigation' => $this->_base->_session->navigation,
			'site_config' => $this->_base->_session->site_config,
			'article_info' => $article_info[0],
			'hot_list' => $news->zibanma_get_host_list(),
			'random_list' => $news->zibanma_get_random_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('news.article', $assign);
		$news->zibanma_update_cilck($id);
	}
}
?>